/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.migration;

import java.net.Proxy;
import java.util.HashMap;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.migration.PropertyConfiguration;

public final class ProxyServiceMigration {
    static final String PROXY_SERVICE_CLASSNAME = "org.apache.nifi.proxy.StandardProxyConfigurationService";
    static final String PROXY_SERVICE_TYPE = "proxy-type";
    static final String PROXY_SERVICE_HOST = "proxy-server-host";
    static final String PROXY_SERVICE_PORT = "proxy-server-port";
    static final String PROXY_SERVICE_USERNAME = "proxy-user-name";
    static final String PROXY_SERVICE_PASSWORD = "proxy-user-password";
    public static final String OBSOLETE_PROXY_CONFIGURATION_SERVICE = "proxy-configuration-service";
    public static final String PROXY_CONFIGURATION_SERVICE = "Proxy Configuration Service";

    private ProxyServiceMigration() {
    }

    public static void renameProxyConfigurationServiceProperty(PropertyConfiguration config) {
        config.renameProperty(OBSOLETE_PROXY_CONFIGURATION_SERVICE, PROXY_CONFIGURATION_SERVICE);
    }

    public static void migrateProxyProperties(PropertyConfiguration config, PropertyDescriptor proxyServiceProperty, String proxyHostProperty, String proxyPortProperty, String proxyUsernameProperty, String proxyPasswordProperty) {
        ProxyServiceMigration.migrateProxyProperties(config, proxyServiceProperty, Proxy.Type.HTTP, proxyHostProperty, proxyPortProperty, proxyUsernameProperty, proxyPasswordProperty);
    }

    public static void migrateProxyProperties(PropertyConfiguration config, PropertyDescriptor proxyServiceProperty, String proxyTypeProperty, String proxyHostProperty, String proxyPortProperty, String proxyUsernameProperty, String proxyPasswordProperty) {
        Proxy.Type proxyType = Proxy.Type.valueOf(config.getRawPropertyValue(proxyTypeProperty).orElse(Proxy.Type.DIRECT.name()));
        ProxyServiceMigration.migrateProxyProperties(config, proxyServiceProperty, proxyType, proxyHostProperty, proxyPortProperty, proxyUsernameProperty, proxyPasswordProperty);
        config.removeProperty(proxyTypeProperty);
    }

    private static void migrateProxyProperties(PropertyConfiguration config, PropertyDescriptor proxyServiceProperty, Proxy.Type proxyType, String proxyHostProperty, String proxyPortProperty, String proxyUsernameProperty, String proxyPasswordProperty) {
        ProxyServiceMigration.renameProxyConfigurationServiceProperty(config);
        if (config.isPropertySet(proxyHostProperty)) {
            HashMap<String, String> proxyProperties = new HashMap<String, String>();
            proxyProperties.put(PROXY_SERVICE_TYPE, proxyType.name());
            proxyProperties.put(PROXY_SERVICE_HOST, (String)config.getRawPropertyValue(proxyHostProperty).get());
            config.getRawPropertyValue(proxyPortProperty).ifPresent(value -> proxyProperties.put(PROXY_SERVICE_PORT, (String)value));
            config.getRawPropertyValue(proxyUsernameProperty).ifPresent(value -> proxyProperties.put(PROXY_SERVICE_USERNAME, (String)value));
            config.getRawPropertyValue(proxyPasswordProperty).ifPresent(value -> proxyProperties.put(PROXY_SERVICE_PASSWORD, (String)value));
            String serviceId = config.createControllerService(PROXY_SERVICE_CLASSNAME, proxyProperties);
            config.setProperty(proxyServiceProperty, serviceId);
        }
        config.removeProperty(proxyHostProperty);
        config.removeProperty(proxyPortProperty);
        config.removeProperty(proxyUsernameProperty);
        config.removeProperty(proxyPasswordProperty);
    }
}

