/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kubernetes.client;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.nifi.kubernetes.client.NamespaceProvider;

public class ServiceAccountNamespaceProvider
implements NamespaceProvider {
    protected static final String NAMESPACE_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/namespace";
    protected static final String DEFAULT_NAMESPACE = "default";

    @Override
    public String getNamespace() {
        Path namespacePath = Paths.get(NAMESPACE_PATH, new String[0]);
        return Files.isReadable(namespacePath) ? this.getNamespace(namespacePath) : DEFAULT_NAMESPACE;
    }

    private String getNamespace(Path namespacePath) {
        try {
            byte[] bytes = Files.readAllBytes(namespacePath);
            return new String(bytes, StandardCharsets.UTF_8).trim();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Read Service Account namespace failed", e);
        }
    }
}

