/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.shared.component;

import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.kafka.shared.property.AwsRoleSource;
import org.apache.nifi.kafka.shared.property.SaslMechanism;
import org.apache.nifi.kafka.shared.property.SecurityProtocol;
import org.apache.nifi.kerberos.SelfContainedKerberosUserService;
import org.apache.nifi.oauth2.OAuth2AccessTokenProvider;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.ssl.SSLContextService;

public interface KafkaClientComponent {
    public static final PropertyDescriptor BOOTSTRAP_SERVERS = new PropertyDescriptor.Builder().name("bootstrap.servers").displayName("Bootstrap Servers").description("Comma-separated list of Kafka Bootstrap Servers in the format host:port. Corresponds to Kafka bootstrap.servers property").required(true).addValidator(StandardValidators.HOSTNAME_PORT_LIST_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final PropertyDescriptor SECURITY_PROTOCOL = new PropertyDescriptor.Builder().name("security.protocol").displayName("Security Protocol").description("Security protocol used to communicate with brokers. Corresponds to Kafka Client security.protocol property").required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues((Enum[])SecurityProtocol.values()).defaultValue(SecurityProtocol.PLAINTEXT.name()).build();
    public static final PropertyDescriptor SASL_MECHANISM = new PropertyDescriptor.Builder().name("sasl.mechanism").displayName("SASL Mechanism").description("SASL mechanism used for authentication. Corresponds to Kafka Client sasl.mechanism property").required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues(SaslMechanism.getAvailableSaslMechanisms()).defaultValue((DescribedValue)SaslMechanism.GSSAPI).dependsOn(SECURITY_PROTOCOL, SecurityProtocol.SASL_PLAINTEXT.name(), new String[]{SecurityProtocol.SASL_SSL.name()}).build();
    public static final PropertyDescriptor SASL_USERNAME = new PropertyDescriptor.Builder().name("sasl.username").displayName("SASL Username").description("Username provided with configured password when using PLAIN or SCRAM SASL Mechanisms").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dependsOn(SASL_MECHANISM, (DescribedValue)SaslMechanism.PLAIN, new DescribedValue[]{SaslMechanism.SCRAM_SHA_256, SaslMechanism.SCRAM_SHA_512}).build();
    public static final PropertyDescriptor SASL_PASSWORD = new PropertyDescriptor.Builder().name("sasl.password").displayName("SASL Password").description("Password provided with configured username when using PLAIN or SCRAM SASL Mechanisms").required(true).sensitive(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dependsOn(SASL_MECHANISM, (DescribedValue)SaslMechanism.PLAIN, new DescribedValue[]{SaslMechanism.SCRAM_SHA_256, SaslMechanism.SCRAM_SHA_512}).build();
    public static final PropertyDescriptor TOKEN_AUTHENTICATION = new PropertyDescriptor.Builder().name("sasl.token.auth").displayName("Token Authentication").description("Enables or disables Token authentication when using SCRAM SASL Mechanisms").required(false).allowableValues(new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).defaultValue(Boolean.FALSE.toString()).dependsOn(SASL_MECHANISM, (DescribedValue)SaslMechanism.SCRAM_SHA_256, new DescribedValue[]{SaslMechanism.SCRAM_SHA_512}).build();
    public static final PropertyDescriptor AWS_ROLE_SOURCE = new PropertyDescriptor.Builder().name("AWS Role Source").description("Select how AWS credentials are sourced for AWS MSK IAM: Default Profile searches standard locations, Specified Profile selects a named profile, or Specified Role configures a Role ARN and Session Name.").required(true).allowableValues(AwsRoleSource.class).defaultValue((DescribedValue)AwsRoleSource.DEFAULT_PROFILE).dependsOn(SASL_MECHANISM, (DescribedValue)SaslMechanism.AWS_MSK_IAM, new DescribedValue[0]).build();
    public static final PropertyDescriptor AWS_PROFILE_NAME = new PropertyDescriptor.Builder().name("aws.profile.name").displayName("AWS Profile Name").description("The Amazon Web Services Profile to select when multiple profiles are available.").dependsOn(AWS_ROLE_SOURCE, (DescribedValue)AwsRoleSource.SPECIFIED_PROFILE, new DescribedValue[0]).required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final PropertyDescriptor AWS_ASSUME_ROLE_ARN = new PropertyDescriptor.Builder().name("AWS Assume Role ARN").description("The AWS Role ARN for cross-account access when using AWS MSK IAM. Used with Assume Role Session Name.").required(true).dependsOn(AWS_ROLE_SOURCE, (DescribedValue)AwsRoleSource.SPECIFIED_ROLE, new DescribedValue[]{AwsRoleSource.WEB_IDENTITY_TOKEN}).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final PropertyDescriptor AWS_ASSUME_ROLE_SESSION_NAME = new PropertyDescriptor.Builder().name("AWS Assume Role Session Name").description("The AWS Role Session Name for cross-account access. Used in conjunction with Assume Role ARN.").required(true).dependsOn(AWS_ROLE_SOURCE, (DescribedValue)AwsRoleSource.SPECIFIED_ROLE, new DescribedValue[]{AwsRoleSource.WEB_IDENTITY_TOKEN}).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final PropertyDescriptor AWS_WEB_IDENTITY_TOKEN_PROVIDER = new PropertyDescriptor.Builder().name("AWS Web Identity Token Provider").description("Controller Service providing tokens with OAuth2 OpenID Connect for AWS Web Identity federation.").identifiesControllerService(OAuth2AccessTokenProvider.class).required(true).dependsOn(AWS_ROLE_SOURCE, (DescribedValue)AwsRoleSource.WEB_IDENTITY_TOKEN, new DescribedValue[0]).build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("Service supporting SSL communication with Kafka brokers").required(false).identifiesControllerService(SSLContextService.class).dependsOn(SECURITY_PROTOCOL, SecurityProtocol.SSL.name(), new String[]{SecurityProtocol.SASL_SSL.name()}).build();
    public static final PropertyDescriptor KERBEROS_SERVICE_NAME = new PropertyDescriptor.Builder().name("sasl.kerberos.service.name").displayName("Kerberos Service Name").description("The service name that matches the primary name of the Kafka server configured in the broker JAAS configuration").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dependsOn(SASL_MECHANISM, (DescribedValue)SaslMechanism.GSSAPI, new DescribedValue[0]).build();
    public static final PropertyDescriptor SELF_CONTAINED_KERBEROS_USER_SERVICE = new PropertyDescriptor.Builder().name("kerberos-user-service").displayName("Kerberos User Service").description("Service supporting user authentication with Kerberos").identifiesControllerService(SelfContainedKerberosUserService.class).required(true).dependsOn(SASL_MECHANISM, (DescribedValue)SaslMechanism.GSSAPI, new DescribedValue[0]).build();
    public static final PropertyDescriptor OAUTH2_ACCESS_TOKEN_PROVIDER_SERVICE = new PropertyDescriptor.Builder().name("oauth2-access-token-provider-service").displayName("OAuth2 Access Token Provider Service").description("Service providing OAuth2 Access Tokens for authentication").identifiesControllerService(OAuth2AccessTokenProvider.class).required(true).dependsOn(SASL_MECHANISM, (DescribedValue)SaslMechanism.OAUTHBEARER, new DescribedValue[0]).build();
}

