/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.jolt;

import com.bazaarvoice.jolt.JoltTransform;
import com.bazaarvoice.jolt.JsonUtil;
import com.bazaarvoice.jolt.JsonUtils;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.jolt.util.JoltTransformStrategy;
import org.apache.nifi.jolt.util.TransformUtils;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.jolt.AbstractJoltTransform;
import org.apache.nifi.processors.jolt.JsonSourceStrategy;
import org.apache.nifi.util.StopWatch;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;

@SideEffectFree
@SupportsBatching
@Tags(value={"json", "jolt", "transform", "chainr", "shift", "default", "remove", "cardinality", "sort"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@WritesAttribute(attribute="mime.type", description="Always set to application/json")
@CapabilityDescription(value="Applies a list of Jolt specifications to either the FlowFile JSON content or a specified FlowFile JSON attribute. If the JSON transform fails, the original FlowFile is routed to the 'failure' relationship.")
@RequiresInstanceClassLoading
public class JoltTransformJSON
extends AbstractJoltTransform {
    public static final PropertyDescriptor JSON_SOURCE = new PropertyDescriptor.Builder().name("JSON Source").description("Specifies whether the Jolt transformation is applied to FlowFile JSON content or to specified FlowFile JSON attribute.").required(true).allowableValues(JsonSourceStrategy.class).defaultValue((DescribedValue)JsonSourceStrategy.FLOW_FILE).build();
    public static final PropertyDescriptor JSON_SOURCE_ATTRIBUTE = new PropertyDescriptor.Builder().name("JSON Source Attribute").description("The FlowFile attribute containing JSON to be transformed.").dependsOn(JSON_SOURCE, (DescribedValue)JsonSourceStrategy.ATTRIBUTE, new DescribedValue[0]).required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).addValidator(StandardValidators.ATTRIBUTE_KEY_VALIDATOR).build();
    public static final PropertyDescriptor PRETTY_PRINT = new PropertyDescriptor.Builder().name("Pretty Print").displayName("Pretty Print").description("Apply pretty print formatting to the output of the Jolt transform").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor MAX_STRING_LENGTH = new PropertyDescriptor.Builder().name("Max String Length").displayName("Max String Length").description("The maximum allowed length of a string value when parsing the JSON document").required(true).defaultValue("20 MB").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("The FlowFile with successfully transformed content or updated attribute will be routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("If the JSON transformation fails (e.g., due to invalid JSON in the content or attribute), the original FlowFile is routed to this relationship.").build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = Stream.concat(JoltTransformJSON.getCommonPropertyDescriptors().stream(), Stream.of(JSON_SOURCE, JSON_SOURCE_ATTRIBUTE, PRETTY_PRINT, MAX_STRING_LENGTH)).toList();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE);
    private volatile ClassLoader customClassLoader;
    private volatile JsonUtil jsonUtil;

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        String jsonString;
        Object inputJson;
        String jsonSourceAttributeName;
        boolean sourceStrategyFlowFile;
        StopWatch stopWatch;
        ComponentLog logger;
        FlowFile original;
        block22: {
            original = session.get();
            if (original == null) {
                return;
            }
            logger = this.getLogger();
            stopWatch = new StopWatch(true);
            sourceStrategyFlowFile = JsonSourceStrategy.FLOW_FILE == context.getProperty(JSON_SOURCE).asAllowableValue(JsonSourceStrategy.class);
            jsonSourceAttributeName = null;
            if (sourceStrategyFlowFile) {
                try (InputStream in = session.read(original);){
                    inputJson = this.jsonUtil.jsonToObject(in);
                    break block22;
                }
                catch (Exception e) {
                    logger.error("JSON parsing failed on FlowFile content for {}", new Object[]{original, e});
                    session.transfer(original, REL_FAILURE);
                    return;
                }
            }
            jsonSourceAttributeName = context.getProperty(JSON_SOURCE_ATTRIBUTE).getValue();
            String jsonSourceAttributeValue = original.getAttribute(jsonSourceAttributeName);
            if (StringUtils.isBlank((String)jsonSourceAttributeValue)) {
                logger.error("FlowFile attribute '{}' value is blank", new Object[]{jsonSourceAttributeName});
                session.transfer(original, REL_FAILURE);
                return;
            }
            try {
                inputJson = this.jsonUtil.jsonToObject(jsonSourceAttributeValue);
            }
            catch (Exception e) {
                logger.error("JSON parsing failed on attribute '{}' of FlowFile {}", new Object[]{jsonSourceAttributeName, original, e});
                session.transfer(original, REL_FAILURE);
                return;
            }
        }
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            JoltTransform transform = this.getTransform(context, original);
            if (this.customClassLoader != null) {
                Thread.currentThread().setContextClassLoader(this.customClassLoader);
            }
            Object transformedJson = TransformUtils.transform((JoltTransform)transform, (Object)inputJson);
            jsonString = context.getProperty(PRETTY_PRINT).asBoolean() != false ? this.jsonUtil.toPrettyJsonString(transformedJson) : this.jsonUtil.toJsonString(transformedJson);
        }
        catch (Exception e) {
            logger.error("Transform failed for {}", new Object[]{original, e});
            session.transfer(original, REL_FAILURE);
            return;
        }
        finally {
            if (this.customClassLoader != null && originalContextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }
        if (sourceStrategyFlowFile) {
            FlowFile transformed = session.write(original, out -> out.write(jsonString.getBytes(StandardCharsets.UTF_8)));
            String transformType = context.getProperty(JOLT_TRANSFORM).getValue();
            transformed = session.putAttribute(transformed, CoreAttributes.MIME_TYPE.key(), "application/json");
            session.transfer(transformed, REL_SUCCESS);
            session.getProvenanceReporter().modifyContent(transformed, "Modified With " + transformType, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
            logger.info("Transform completed on FlowFile content for {}", new Object[]{original});
        } else {
            session.putAttribute(original, jsonSourceAttributeName, jsonString);
            session.transfer(original, REL_SUCCESS);
            logger.info("Transform completed on attribute '{}' of FlowFile {}", new Object[]{jsonSourceAttributeName, original});
        }
    }

    @Override
    @OnScheduled
    public void setup(ProcessContext context) {
        super.setup(context);
        int maxStringLength = context.getProperty(MAX_STRING_LENGTH).asDataSize(DataUnit.B).intValue();
        StreamReadConstraints streamReadConstraints = StreamReadConstraints.builder().maxStringLength(maxStringLength).build();
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.getFactory().setStreamReadConstraints(streamReadConstraints);
        this.jsonUtil = JsonUtils.customJsonUtil((ObjectMapper)objectMapper);
        try {
            JoltTransformStrategy strategy = (JoltTransformStrategy)context.getProperty(JOLT_TRANSFORM).asAllowableValue(JoltTransformStrategy.class);
            this.customClassLoader = strategy == JoltTransformStrategy.CUSTOMR && context.getProperty(MODULES).isSet() ? ClassLoaderUtils.getCustomClassLoader((String)context.getProperty(MODULES).evaluateAttributeExpressions().getValue(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (FilenameFilter)this.getJarFilenameFilter()) : ((Object)((Object)this)).getClass().getClassLoader();
        }
        catch (Exception e) {
            this.getLogger().error("ClassLoader configuration failed", (Throwable)e);
        }
    }
}

