/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.processors;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.MessageEOFException;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;

abstract class MessageBodyToBytesConverter {
    MessageBodyToBytesConverter() {
    }

    public static byte[] toBytes(TextMessage message) {
        return MessageBodyToBytesConverter.toBytes(message, null);
    }

    public static byte[] toBytes(TextMessage message, Charset charset) {
        try {
            if (message.getText() == null) {
                return new byte[0];
            }
            if (charset == null) {
                return message.getText().getBytes();
            }
            return message.getText().getBytes(charset);
        }
        catch (JMSException e) {
            throw new MessageConversionException("Failed to convert " + TextMessage.class.getSimpleName() + " to byte[]", e);
        }
    }

    public static byte[] toBytes(BytesMessage message) {
        try {
            BytesMessageInputStream is = new BytesMessageInputStream(message);
            return IOUtils.toByteArray((InputStream)is);
        }
        catch (Exception e) {
            throw new MessageConversionException("Failed to convert " + BytesMessage.class.getSimpleName() + " to byte[]", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] toBytes(StreamMessage message) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                try {
                    Object element;
                    while (true) {
                        if ((element = message.readObject()) instanceof Boolean) {
                            dataOutputStream.writeBoolean((Boolean)element);
                            continue;
                        }
                        if (element instanceof byte[]) {
                            dataOutputStream.write((byte[])element);
                            continue;
                        }
                        if (element instanceof Byte) {
                            dataOutputStream.writeByte(((Byte)element).byteValue());
                            continue;
                        }
                        if (element instanceof Short) {
                            dataOutputStream.writeShort(((Short)element).shortValue());
                            continue;
                        }
                        if (element instanceof Integer) {
                            dataOutputStream.writeInt((Integer)element);
                            continue;
                        }
                        if (element instanceof Long) {
                            dataOutputStream.writeLong((Long)element);
                            continue;
                        }
                        if (element instanceof Float) {
                            dataOutputStream.writeFloat(((Float)element).floatValue());
                            continue;
                        }
                        if (element instanceof Double) {
                            dataOutputStream.writeDouble((Double)element);
                            continue;
                        }
                        if (element instanceof Character) {
                            dataOutputStream.writeChar(((Character)element).charValue());
                            continue;
                        }
                        if (!(element instanceof String)) break;
                        dataOutputStream.writeUTF((String)element);
                    }
                    throw new MessageConversionException("Unsupported type in " + StreamMessage.class.getSimpleName() + ": '" + String.valueOf(element.getClass()) + "'");
                }
                catch (MessageEOFException mEofE) {
                    byte[] bytes;
                    dataOutputStream.flush();
                    byte[] byArray = bytes = byteArrayOutputStream.toByteArray();
                    dataOutputStream.close();
                    return byArray;
                }
            }
            catch (Throwable throwable) {
                try {
                    dataOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new MessageConversionException("Failed to convert " + StreamMessage.class.getSimpleName() + " to byte[]", e);
        }
    }

    public static byte[] toBytes(MapMessage message) {
        byte[] byArray;
        ObjectMapper objectMapper = new ObjectMapper();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] jsonAsByteArray;
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            Enumeration mapNames = message.getMapNames();
            while (mapNames.hasMoreElements()) {
                String name = (String)mapNames.nextElement();
                Object value = message.getObject(name);
                if (value instanceof byte[]) {
                    byte[] bytes = (byte[])value;
                    ArrayList<Byte> byteList = new ArrayList<Byte>(bytes.length);
                    for (byte aByte : bytes) {
                        byteList.add(aByte);
                    }
                    objectMap.put(name, byteList);
                    continue;
                }
                objectMap.put(name, value);
            }
            objectMapper.writeValue((OutputStream)byteArrayOutputStream, objectMap);
            byArray = jsonAsByteArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JMSException e) {
                throw new MessageConversionException("Couldn't read incoming " + MapMessage.class.getSimpleName(), e);
            }
            catch (IOException e) {
                throw new MessageConversionException("Couldn't transform incoming " + MapMessage.class.getSimpleName() + " to JSON", e);
            }
        }
        byteArrayOutputStream.close();
        return byArray;
    }

    static class MessageConversionException
    extends RuntimeException {
        private static final long serialVersionUID = -1464448549601643887L;

        public MessageConversionException(String msg) {
            super(msg);
        }

        public MessageConversionException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    private static class BytesMessageInputStream
    extends InputStream {
        private final BytesMessage message;

        public BytesMessageInputStream(BytesMessage message) {
            this.message = message;
        }

        @Override
        public int read() throws IOException {
            try {
                int value = Byte.toUnsignedInt(this.message.readByte());
                return value;
            }
            catch (MessageEOFException eof) {
                return -1;
            }
            catch (JMSException e) {
                throw new IOException(e.toString());
            }
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            try {
                if (offset == 0) {
                    return this.message.readBytes(buffer, length);
                }
                return super.read(buffer, offset, length);
            }
            catch (MessageEOFException eof) {
                return -1;
            }
            catch (JMSException e) {
                throw new IOException(e.toString());
            }
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            try {
                return this.message.readBytes(buffer);
            }
            catch (MessageEOFException eof) {
                return -1;
            }
            catch (JMSException e) {
                throw new IOException(e.toString());
            }
        }
    }
}

