/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.processors;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.nifi.jms.processors.JMSWorker;
import org.apache.nifi.jms.processors.MessageBodyToBytesConverter;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.SessionCallback;
import org.springframework.jms.support.JmsUtils;

final class JMSConsumer
extends JMSWorker {
    JMSConsumer(CachingConnectionFactory connectionFactory, JmsTemplate jmsTemplate, ComponentLog logger) {
        super(connectionFactory, jmsTemplate, logger);
        logger.debug("Created Message Consumer for '{}'", new Object[]{jmsTemplate});
    }

    private MessageConsumer createMessageConsumer(Session session, String destinationName, boolean durable, boolean shared, String subscriberName) throws JMSException {
        boolean isPubSub = this.jmsTemplate.isPubSubDomain();
        Destination destination = this.jmsTemplate.getDestinationResolver().resolveDestinationName(session, destinationName, isPubSub);
        if (isPubSub) {
            if (shared) {
                try {
                    if (durable) {
                        return session.createSharedDurableConsumer((Topic)destination, subscriberName);
                    }
                    return session.createSharedConsumer((Topic)destination, subscriberName);
                }
                catch (AbstractMethodError e) {
                    throw new ProcessException("Failed to create a shared consumer. Make sure the target broker is JMS 2.0 compliant.", (Throwable)e);
                }
            }
            if (durable) {
                return session.createDurableConsumer((Topic)destination, subscriberName, null, this.jmsTemplate.isPubSubDomain());
            }
            return session.createConsumer(destination, null, this.jmsTemplate.isPubSubDomain());
        }
        return session.createConsumer(destination, null, this.jmsTemplate.isPubSubDomain());
    }

    public void consume(final String destinationName, final String errorQueueName, final boolean durable, final boolean shared, final String subscriberName, final String charset, final ConsumerCallback consumerCallback) {
        this.jmsTemplate.execute((SessionCallback)new SessionCallback<Void>(){

            public Void doInJms(Session session) throws JMSException {
                MessageConsumer msgConsumer = JMSConsumer.this.createMessageConsumer(session, destinationName, durable, shared, subscriberName);
                try {
                    Message message = msgConsumer.receive(JMSConsumer.this.jmsTemplate.getReceiveTimeout());
                    JMSResponse response = null;
                    if (message != null) {
                        byte[] messageBody;
                        String messageType;
                        block20: {
                            try {
                                if (message instanceof TextMessage) {
                                    messageType = TextMessage.class.getSimpleName();
                                    messageBody = MessageBodyToBytesConverter.toBytes((TextMessage)message, Charset.forName(charset));
                                    break block20;
                                }
                                if (message instanceof BytesMessage) {
                                    messageType = BytesMessage.class.getSimpleName();
                                    messageBody = MessageBodyToBytesConverter.toBytes((BytesMessage)message);
                                    break block20;
                                }
                                if (message instanceof ObjectMessage) {
                                    messageType = ObjectMessage.class.getSimpleName();
                                    messageBody = MessageBodyToBytesConverter.toBytes((ObjectMessage)message);
                                    break block20;
                                }
                                if (message instanceof StreamMessage) {
                                    messageType = StreamMessage.class.getSimpleName();
                                    messageBody = MessageBodyToBytesConverter.toBytes((StreamMessage)message);
                                    break block20;
                                }
                                if (message instanceof MapMessage) {
                                    messageType = MapMessage.class.getSimpleName();
                                    messageBody = MessageBodyToBytesConverter.toBytes((MapMessage)message);
                                    break block20;
                                }
                                JMSConsumer.this.acknowledge(message, session);
                                if (errorQueueName != null) {
                                    JMSConsumer.this.processLog.error("Received unsupported JMS Message type [{}]; rerouting message to error queue [{}].", new Object[]{message, errorQueueName});
                                    JMSConsumer.this.jmsTemplate.send(errorQueueName, __ -> message);
                                } else {
                                    JMSConsumer.this.processLog.error("Received unsupported JMS Message type [{}]; will skip this message.", new Object[]{message});
                                }
                                Void void_ = null;
                                return void_;
                            }
                            catch (MessageBodyToBytesConverter.MessageConversionException mce) {
                                JMSConsumer.this.processLog.error("Received a JMS Message [{}] but failed to obtain the content of the message; will acknowledge this message without creating a FlowFile for it.", new Object[]{message}, (Throwable)mce);
                                JMSConsumer.this.acknowledge(message, session);
                                if (errorQueueName != null) {
                                    JMSConsumer.this.jmsTemplate.send(errorQueueName, __ -> message);
                                }
                                Void void_ = null;
                                return void_;
                            }
                        }
                        Map messageHeaders = JMSConsumer.this.extractMessageHeaders(message);
                        Map messageProperties = JMSConsumer.this.extractMessageProperties(message);
                        response = new JMSResponse(messageType, messageBody, messageHeaders, messageProperties);
                    }
                    consumerCallback.accept(response);
                    JMSConsumer.this.acknowledge(message, session);
                }
                catch (Exception e) {
                    try {
                        session.recover();
                    }
                    catch (Exception e1) {
                        JMSConsumer.this.processLog.debug("Failed to recover JMS session while handling initial error. The recover error is: ", (Throwable)e1);
                    }
                    throw e;
                }
                finally {
                    JmsUtils.closeMessageConsumer((MessageConsumer)msgConsumer);
                }
                return null;
            }
        }, true);
    }

    private void acknowledge(Message message, Session session) throws JMSException {
        if (message != null && session.getAcknowledgeMode() == 2) {
            message.acknowledge();
        }
    }

    private Map<String, String> extractMessageProperties(Message message) {
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            Enumeration propertyNames = message.getPropertyNames();
            while (propertyNames.hasMoreElements()) {
                String propertyName = (String)propertyNames.nextElement();
                properties.put(propertyName, String.valueOf(message.getObjectProperty(propertyName)));
            }
        }
        catch (JMSException e) {
            this.processLog.warn("Failed to extract message properties", (Throwable)e);
        }
        return properties;
    }

    private Map<String, String> extractMessageHeaders(Message message) throws JMSException {
        String destinationName;
        HashMap<String, String> messageHeaders = new HashMap<String, String>();
        messageHeaders.put("jms_deliveryMode", String.valueOf(message.getJMSDeliveryMode()));
        messageHeaders.put("jms_expiration", String.valueOf(message.getJMSExpiration()));
        messageHeaders.put("jms_priority", String.valueOf(message.getJMSPriority()));
        messageHeaders.put("jms_redelivered", String.valueOf(message.getJMSRedelivered()));
        messageHeaders.put("jms_timestamp", String.valueOf(message.getJMSTimestamp()));
        messageHeaders.put("jms_correlationId", message.getJMSCorrelationID());
        messageHeaders.put("jms_messageId", message.getJMSMessageID());
        messageHeaders.put("jms_type", message.getJMSType());
        String replyToDestinationName = this.retrieveDestinationName(message.getJMSReplyTo(), "jms_replyTo");
        if (replyToDestinationName != null) {
            messageHeaders.put("jms_replyTo", replyToDestinationName);
        }
        if ((destinationName = this.retrieveDestinationName(message.getJMSDestination(), "jms_destination")) != null) {
            messageHeaders.put("jms_destination", destinationName);
        }
        return messageHeaders;
    }

    private String retrieveDestinationName(Destination destination, String headerName) {
        String destinationName = null;
        if (destination != null) {
            try {
                destinationName = destination instanceof Queue ? ((Queue)destination).getQueueName() : ((Topic)destination).getTopicName();
            }
            catch (JMSException e) {
                this.processLog.warn("Failed to retrieve Destination name for '" + headerName + "' header", (Throwable)e);
            }
        }
        return destinationName;
    }

    static interface ConsumerCallback {
        public void accept(JMSResponse var1);
    }

    static class JMSResponse {
        private final byte[] messageBody;
        private final String messageType;
        private final Map<String, String> messageHeaders;
        private final Map<String, String> messageProperties;

        JMSResponse(String messageType, byte[] messageBody, Map<String, String> messageHeaders, Map<String, String> messageProperties) {
            this.messageType = messageType;
            this.messageBody = messageBody;
            this.messageHeaders = Collections.unmodifiableMap(messageHeaders);
            this.messageProperties = Collections.unmodifiableMap(messageProperties);
        }

        public String getMessageType() {
            return this.messageType;
        }

        public byte[] getMessageBody() {
            return this.messageBody;
        }

        public Map<String, String> getMessageHeaders() {
            return this.messageHeaders;
        }

        public Map<String, String> getMessageProperties() {
            return this.messageProperties;
        }
    }
}

