/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.cf;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.jms.ConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.jms.cf.JMSConnectionFactoryProviderDefinition;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

@Tags(value={"jms", "jndi", "messaging", "integration", "queue", "topic", "publish", "subscribe"})
@CapabilityDescription(value="Provides a service to lookup an existing JMS ConnectionFactory using the Java Naming and Directory Interface (JNDI).")
@DynamicProperty(description="In order to perform a JNDI Lookup, an Initial Context must be established. When this is done, an Environment can be established for the context. Any dynamic/user-defined property that is added to this Controller Service will be added as an Environment configuration/variable to this Context.", name="The name of a JNDI Initial Context environment variable.", value="The value of the JNDI Initial Context Environment variable.", expressionLanguageScope=ExpressionLanguageScope.VARIABLE_REGISTRY)
@SeeAlso(classNames={"org.apache.nifi.jms.processors.ConsumeJMS", "org.apache.nifi.jms.processors.PublishJMS", "org.apache.nifi.jms.cf.JMSConnectionFactoryProvider"})
public class JndiJmsConnectionFactoryProvider
extends AbstractControllerService
implements JMSConnectionFactoryProviderDefinition {
    static final PropertyDescriptor INITIAL_NAMING_FACTORY_CLASS = new PropertyDescriptor.Builder().name("java.naming.factory.initial").displayName("Initial Naming Factory Class").description("The fully qualified class name of the Java Initial Naming Factory (java.naming.factory.initial).").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(true).build();
    static final PropertyDescriptor NAMING_PROVIDER_URL = new PropertyDescriptor.Builder().name("java.naming.provider.url").displayName("Naming Provider URL").description("The URL of the JNDI Naming Provider to use").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    static final PropertyDescriptor CONNECTION_FACTORY_NAME = new PropertyDescriptor.Builder().name("connection.factory.name").displayName("Connection Factory Name").description("The name of the JNDI Object to lookup for the Connection Factory").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    static final PropertyDescriptor NAMING_FACTORY_LIBRARIES = new PropertyDescriptor.Builder().name("naming.factory.libraries").displayName("Naming Factory Libraries").description("Specifies .jar files or directories to add to the ClassPath in order to find the Initial Naming Factory Class").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.createListValidator((boolean)true, (boolean)true, (Validator)StandardValidators.createURLorFileValidator())).dynamicallyModifiesClasspath(true).build();
    static final PropertyDescriptor PRINCIPAL = new PropertyDescriptor.Builder().name("java.naming.security.principal").displayName("JNDI Principal").description("The Principal to use when authenticating with JNDI").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor CREDENTIALS = new PropertyDescriptor.Builder().name("java.naming.security.credentials").displayName("Credentials").description("The Credentials to use when authenticating with JNDI").required(false).expressionLanguageSupported(ExpressionLanguageScope.NONE).addValidator(Validator.VALID).sensitive(true).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = Arrays.asList(INITIAL_NAMING_FACTORY_CLASS, NAMING_PROVIDER_URL, CONNECTION_FACTORY_NAME, NAMING_FACTORY_LIBRARIES, PRINCIPAL, CREDENTIALS);
    private ConnectionFactory connectionFactory;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).displayName(propertyDescriptorName).description("JNDI Initial Context Environment configuration for '" + propertyDescriptorName + "'").required(false).dynamic(true).addValidator(Validator.VALID).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    }

    @OnDisabled
    public void shutdown() {
        this.connectionFactory = null;
    }

    public synchronized void resetConnectionFactory(ConnectionFactory cachedFactory) {
        if (cachedFactory == this.connectionFactory) {
            this.getLogger().debug("Resetting connection factory");
            this.connectionFactory = null;
        }
    }

    public synchronized ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = this.lookupConnectionFactory();
        } else {
            this.getLogger().debug("Connection Factory has already been obtained from JNDI. Will return cached instance.");
        }
        return this.connectionFactory;
    }

    private ConnectionFactory lookupConnectionFactory() {
        try {
            ConfigurationContext context = this.getConfigurationContext();
            String factoryName = context.getProperty(CONNECTION_FACTORY_NAME).evaluateAttributeExpressions().getValue().trim();
            this.getLogger().debug("Looking up Connection Factory with name [{}]", new Object[]{factoryName});
            Context initialContext = this.createInitialContext();
            Object factoryObject = initialContext.lookup(factoryName);
            this.getLogger().debug("Obtained {} from JNDI", new Object[]{factoryObject});
            if (factoryObject == null) {
                throw new ProcessException("Got a null Factory Object from JNDI");
            }
            if (!(factoryObject instanceof ConnectionFactory)) {
                throw new ProcessException("Successfully performed JNDI lookup with Object Name [" + factoryName + "] but the returned object is not a ConnectionFactory. Instead, is of type " + factoryObject.getClass() + " : " + factoryObject);
            }
            return (ConnectionFactory)JndiJmsConnectionFactoryProvider.instrumentWithClassLoader(factoryObject, Thread.currentThread().getContextClassLoader(), ConnectionFactory.class);
        }
        catch (NamingException ne) {
            throw new ProcessException("Could not obtain JMS Connection Factory from JNDI", (Throwable)ne);
        }
    }

    private Context createInitialContext() throws NamingException {
        String credentials;
        ConfigurationContext context = this.getConfigurationContext();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", context.getProperty(INITIAL_NAMING_FACTORY_CLASS).evaluateAttributeExpressions().getValue().trim());
        env.put("java.naming.provider.url", context.getProperty(NAMING_PROVIDER_URL).evaluateAttributeExpressions().getValue().trim());
        String principal = context.getProperty(PRINCIPAL).evaluateAttributeExpressions().getValue();
        if (principal != null) {
            env.put("java.naming.security.principal", principal);
        }
        if ((credentials = context.getProperty(CREDENTIALS).getValue()) != null) {
            env.put("java.naming.security.credentials", credentials);
        }
        context.getProperties().keySet().forEach(descriptor -> {
            if (descriptor.isDynamic()) {
                env.put(descriptor.getName(), context.getProperty(descriptor).evaluateAttributeExpressions().getValue());
            }
        });
        this.getLogger().debug("Creating Initial Context using JNDI Environment {}", new Object[]{env});
        InitialContext initialContext = new InitialContext(env);
        return initialContext;
    }

    public static Object instrumentWithClassLoader(final Object obj, final ClassLoader classLoader, Class<?> ... interfaces) {
        InvocationHandler invocationHandler = new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Thread thread = Thread.currentThread();
                ClassLoader currentClassLoader = thread.getContextClassLoader();
                try {
                    thread.setContextClassLoader(classLoader);
                    Object object = method.invoke(obj, args);
                    return object;
                }
                finally {
                    thread.setContextClassLoader(currentClassLoader);
                }
            }
        };
        return Proxy.newProxyInstance(classLoader, interfaces, invocationHandler);
    }
}

