/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.server.handler;

import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class HeaderWriterHandler
extends Handler.Wrapper {
    private static final String CONTENT_SECURITY_POLICY_HEADER = "Content-Security-Policy";
    private static final String CONTENT_SECURITY_POLICY = "frame-ancestors 'self'";
    private static final String CONTENT_TYPE_OPTIONS_HEADER = "X-Content-Type-Options";
    private static final String CONTENT_TYPE_OPTIONS = "nosniff";
    private static final String FRAME_OPTIONS_HEADER = "X-Frame-Options";
    private static final String FRAME_OPTIONS = "SAMEORIGIN";
    private static final String STRICT_TRANSPORT_SECURITY_HEADER = "Strict-Transport-Security";
    private static final String STRICT_TRANSPORT_SECURITY = "max-age=31540000";
    private static final String XSS_PROTECTION_HEADER = "X-XSS-Protection";
    private static final String XSS_PROTECTION = "1; mode=block";

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        HttpFields.Mutable responseHeaders = response.getHeaders();
        responseHeaders.put(CONTENT_SECURITY_POLICY_HEADER, CONTENT_SECURITY_POLICY);
        responseHeaders.put(CONTENT_TYPE_OPTIONS_HEADER, CONTENT_TYPE_OPTIONS);
        responseHeaders.put(FRAME_OPTIONS_HEADER, FRAME_OPTIONS);
        responseHeaders.put(XSS_PROTECTION_HEADER, XSS_PROTECTION);
        if (request.isSecure()) {
            responseHeaders.put(STRICT_TRANSPORT_SECURITY_HEADER, STRICT_TRANSPORT_SECURITY);
        }
        return super.handle(request, response, callback);
    }
}

