/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.server.handler;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.nifi.web.servlet.shared.ProxyHeader;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.rewrite.handler.RedirectPatternRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class ContextPathRedirectPatternRule
extends RedirectPatternRule {
    private static final String EMPTY_PATH = "";
    private static final String ROOT_PATH = "/";
    private final List<String> allowedContextPaths;

    public ContextPathRedirectPatternRule(String pattern, String location, List<String> allowedContextPaths) {
        super(pattern, location);
        this.allowedContextPaths = Objects.requireNonNull(allowedContextPaths, "Allowed Context Paths required");
    }

    public Rule.Handler apply(final Rule.Handler input) throws IOException {
        return new Rule.Handler(input){

            protected boolean handle(Response response, Callback callback) {
                String redirectUri = ContextPathRedirectPatternRule.this.getRedirectUri(input);
                response.setStatus(ContextPathRedirectPatternRule.this.getStatusCode());
                response.getHeaders().put(HttpHeader.LOCATION, redirectUri);
                callback.succeeded();
                return true;
            }
        };
    }

    private String getRedirectUri(Rule.Handler inputHandler) {
        HttpFields requestHeaders = inputHandler.getHeaders();
        String contextPath = this.getContextPath(requestHeaders);
        String location = this.getLocation();
        String contextPathLocation = contextPath + location;
        return Response.toRedirectURI((Request)inputHandler, (String)contextPathLocation);
    }

    private String getContextPath(HttpFields requestHeaders) {
        String path;
        String headerPath = this.getFirstHeader(requestHeaders, ProxyHeader.PROXY_CONTEXT_PATH, ProxyHeader.FORWARDED_CONTEXT, ProxyHeader.FORWARDED_PREFIX);
        if (headerPath == null) {
            path = EMPTY_PATH;
        } else if (ROOT_PATH.equals(headerPath)) {
            path = ROOT_PATH;
        } else if (this.allowedContextPaths.contains(headerPath)) {
            path = headerPath;
        } else {
            throw new IllegalArgumentException("Request Header Context Path not allowed based on properties [nifi.web.proxy.context.path]");
        }
        return path;
    }

    private String getFirstHeader(HttpFields requestFields, ProxyHeader ... proxyHeaders) {
        return Arrays.stream(proxyHeaders).map(ProxyHeader::getHeader).map(arg_0 -> ((HttpFields)requestFields).get(arg_0)).filter(Objects::nonNull).filter(Predicate.not(String::isBlank)).findFirst().orElse(null);
    }
}

