/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.server.filter;

import java.util.List;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.server.filter.FilterParameter;
import org.apache.nifi.web.server.filter.StandardRequestFilterProvider;
import org.eclipse.jetty.ee11.servlet.FilterHolder;
import org.eclipse.jetty.ee11.servlets.DoSFilter;

public class RestApiRequestFilterProvider
extends StandardRequestFilterProvider {
    public static final String RELATIVE_PATH_ACCESS_TOKEN = "/access/token";
    private static final int DOS_FILTER_REJECT_REQUEST = -1;

    @Override
    public List<FilterHolder> getFilters(NiFiProperties properties) {
        List<FilterHolder> filters = super.getFilters(properties);
        FilterHolder accessTokenDenialOfServiceFilter = this.getAccessTokenDenialOfServiceFilter(properties);
        filters.add(accessTokenDenialOfServiceFilter);
        return filters;
    }

    private FilterHolder getAccessTokenDenialOfServiceFilter(NiFiProperties properties) {
        FilterHolder filter = this.getDenialOfServiceFilter(properties, DoSFilter.class);
        int maxWebAccessTokenRequestsPerSecond = properties.getMaxWebAccessTokenRequestsPerSecond();
        filter.setInitParameter("maxRequestsPerSec", Integer.toString(maxWebAccessTokenRequestsPerSecond));
        filter.setInitParameter("maxWaitMs", Integer.toString(-1));
        filter.setInitParameter("delayMs", Integer.toString(-1));
        filter.setInitParameter(FilterParameter.PATH_SPECIFICATION.name(), RELATIVE_PATH_ACCESS_TOKEN);
        filter.setName("AccessToken-DoSFilter");
        return filter;
    }
}

