/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.server.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import org.apache.nifi.web.servlet.shared.RequestUriBuilder;

public class LogoutCompleteRedirectFilter
implements Filter {
    private static final String LOGOUT_COMPLETE_PATH = "/nifi/logout-complete";
    private static final String USER_INTERFACE_PATH = "/nifi/";
    private static final String FRAGMENT_PATH = "/logout-complete";
    private static final String LOCATION_HEADER = "Location";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            String requestUri = httpServletRequest.getRequestURI();
            if (requestUri.endsWith(LOGOUT_COMPLETE_PATH)) {
                HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
                this.doRedirect(httpServletRequest, httpServletResponse);
            } else {
                filterChain.doFilter(servletRequest, servletResponse);
            }
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private void doRedirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        URI redirectUri = RequestUriBuilder.fromHttpServletRequest((HttpServletRequest)httpServletRequest).path(USER_INTERFACE_PATH).fragment(FRAGMENT_PATH).build();
        String redirectLocation = redirectUri.toString();
        httpServletResponse.setStatus(302);
        httpServletResponse.setHeader(LOCATION_HEADER, redirectLocation);
    }
}

