/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.server;

import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.server.ServerProvider;
import org.apache.nifi.web.server.connector.FrameworkServerConnectorFactory;
import org.apache.nifi.web.server.handler.ContextPathRedirectPatternRule;
import org.apache.nifi.web.server.handler.HeaderWriterHandler;
import org.apache.nifi.web.server.log.StandardRequestLogProvider;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

class StandardServerProvider
implements ServerProvider {
    private static final String ALL_PATHS_PATTERN = "/*";
    private static final String FRONTEND_CONTEXT_PATH = "/nifi";
    private static final String FRONTEND_CONTEXT_PATH_DIRECTORY = "/nifi/";
    private final SSLContext sslContext;

    StandardServerProvider(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    @Override
    public Server getServer(NiFiProperties properties) {
        Objects.requireNonNull(properties, "Properties required");
        QueuedThreadPool threadPool = new QueuedThreadPool(properties.getWebThreads());
        threadPool.setName("NiFi Web Server");
        Server server = new Server((ThreadPool)threadPool);
        this.addConnectors(server, properties, this.sslContext);
        Handler standardHandler = this.getStandardHandler();
        server.setHandler(standardHandler);
        RewriteHandler defaultRewriteHandler = this.getDefaultRewriteHandler(properties);
        server.setDefaultHandler((Handler)defaultRewriteHandler);
        String requestLogFormat = properties.getProperty("nifi.web.request.log.format");
        StandardRequestLogProvider requestLogProvider = new StandardRequestLogProvider(requestLogFormat);
        RequestLog requestLog = requestLogProvider.getRequestLog();
        server.setRequestLog(requestLog);
        return server;
    }

    private RewriteHandler getDefaultRewriteHandler(NiFiProperties properties) {
        RewriteHandler defaultRewriteHandler = new RewriteHandler();
        List allowedContextPaths = properties.getAllowedContextPathsAsList();
        ContextPathRedirectPatternRule redirectFrontend = new ContextPathRedirectPatternRule(FRONTEND_CONTEXT_PATH, FRONTEND_CONTEXT_PATH_DIRECTORY, allowedContextPaths);
        defaultRewriteHandler.addRule((Rule)redirectFrontend);
        ContextPathRedirectPatternRule redirectDefault = new ContextPathRedirectPatternRule(ALL_PATHS_PATTERN, FRONTEND_CONTEXT_PATH_DIRECTORY, allowedContextPaths);
        defaultRewriteHandler.addRule((Rule)redirectDefault);
        return defaultRewriteHandler;
    }

    private void addConnectors(Server server, NiFiProperties properties, SSLContext sslContext) {
        Map interfaces;
        Set interfaceNames;
        FrameworkServerConnectorFactory serverConnectorFactory = new FrameworkServerConnectorFactory(server, properties);
        if (properties.isHTTPSConfigured()) {
            serverConnectorFactory.setSslContext(sslContext);
        }
        if ((interfaceNames = (interfaces = properties.isHTTPSConfigured() ? properties.getHttpsNetworkInterfaces() : properties.getHttpNetworkInterfaces()).values().stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet())).isEmpty()) {
            String host2;
            ServerConnector serverConnector = serverConnectorFactory.getServerConnector();
            String string = host2 = properties.isHTTPSConfigured() ? properties.getProperty("nifi.web.https.host") : properties.getProperty("nifi.web.http.host");
            if (StringUtils.isNotBlank((CharSequence)host2)) {
                serverConnector.setHost(host2);
            }
            server.addConnector((Connector)serverConnector);
        } else {
            interfaceNames.stream().map(interfaceName -> {
                try {
                    return NetworkInterface.getByName(interfaceName);
                }
                catch (SocketException e) {
                    throw new UncheckedIOException(String.format("Network Interface [%s] not found", interfaceName), e);
                }
            }).filter(Objects::nonNull).flatMap(networkInterface -> Collections.list(networkInterface.getInetAddresses()).stream()).map(InetAddress::getHostAddress).map(host -> {
                ServerConnector serverConnector = serverConnectorFactory.getServerConnector();
                serverConnector.setHost(host);
                return serverConnector;
            }).forEach(arg_0 -> ((Server)server).addConnector(arg_0));
        }
    }

    private Handler getStandardHandler() {
        Handler.Sequence standardHandler = new Handler.Sequence(new Handler[0]);
        standardHandler.addHandler((Handler)new HeaderWriterHandler());
        return standardHandler;
    }
}

