/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;

public class DatabaseField {
    private String tsName;
    private TSDataType dataType;
    private TSEncoding encoding;
    private CompressionType compressionType;
    private static final Map<String, TSDataType> typeMap = new HashMap<String, TSDataType>();
    private static final Map<String, TSEncoding> encodingMap = new HashMap<String, TSEncoding>();
    private static final Map<String, CompressionType> compressionMap = new HashMap<String, CompressionType>();

    public DatabaseField() {
    }

    public DatabaseField(String tsName, TSDataType dataType) {
        this.tsName = tsName;
        this.dataType = dataType;
    }

    public String getTsName() {
        return this.tsName;
    }

    public void setTsName(String tsName) {
        this.tsName = tsName;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(TSDataType dataType) {
        this.dataType = dataType;
    }

    public TSEncoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(TSEncoding encoding) {
        this.encoding = encoding;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public static Set<String> getSupportedDataType() {
        return typeMap.keySet();
    }

    public static Set<String> getSupportedEncoding() {
        return encodingMap.keySet();
    }

    public static Set<String> getSupportedCompressionType() {
        return compressionMap.keySet();
    }

    static {
        typeMap.put("INT32", TSDataType.INT32);
        typeMap.put("INT64", TSDataType.INT64);
        typeMap.put("FLOAT", TSDataType.FLOAT);
        typeMap.put("DOUBLE", TSDataType.DOUBLE);
        typeMap.put("BOOLEAN", TSDataType.BOOLEAN);
        typeMap.put("TEXT", TSDataType.TEXT);
        encodingMap.put("PLAIN", TSEncoding.PLAIN);
        encodingMap.put("DICTIONARY", TSEncoding.DICTIONARY);
        encodingMap.put("RLE", TSEncoding.RLE);
        encodingMap.put("DIFF", TSEncoding.DIFF);
        encodingMap.put("TS_2DIFF", TSEncoding.TS_2DIFF);
        encodingMap.put("BITMAP", TSEncoding.BITMAP);
        encodingMap.put("GORILLA_V1", TSEncoding.GORILLA_V1);
        encodingMap.put("REGULAR", TSEncoding.REGULAR);
        encodingMap.put("GORILLA", TSEncoding.GORILLA);
        compressionMap.put("UNCOMPRESSED", CompressionType.UNCOMPRESSED);
        compressionMap.put("SNAPPY", CompressionType.SNAPPY);
        compressionMap.put("GZIP", CompressionType.GZIP);
        compressionMap.put("LZ4", CompressionType.LZ4);
    }
}

