/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.session.Session;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.model.DatabaseField;
import org.apache.nifi.processors.model.DatabaseSchema;
import org.apache.nifi.processors.model.ValidationResult;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.MeasurementSchema;

public abstract class AbstractIoTDB
extends AbstractProcessor {
    private static final int DEFAULT_IOTDB_PORT = 6667;
    protected static ObjectMapper mapper = new ObjectMapper();
    private static final String FIELDS = "fields";
    private static final Map<RecordFieldType, TSDataType> typeMap = new HashMap<RecordFieldType, TSDataType>();
    private static final Map<String, RecordFieldType> reversedTypeMap = new HashMap<String, RecordFieldType>();
    static final Set<RecordFieldType> supportedType = new HashSet<RecordFieldType>();
    static final PropertyDescriptor IOTDB_HOST = new PropertyDescriptor.Builder().name("Host").description("IoTDB server host address").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).build();
    static final PropertyDescriptor IOTDB_PORT = new PropertyDescriptor.Builder().name("Port").description("IoTDB server port number").defaultValue(String.valueOf(6667)).addValidator(StandardValidators.PORT_VALIDATOR).required(true).build();
    static final PropertyDescriptor USERNAME = new PropertyDescriptor.Builder().name("Username").description("Username for access to IoTDB").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).build();
    static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("Password").description("Password for access to IoTDB").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).sensitive(true).build();
    protected static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Processing succeeded").build();
    protected static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Processing failed").build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(IOTDB_HOST, IOTDB_PORT, USERNAME, PASSWORD);
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE);
    protected final AtomicReference<Session> session = new AtomicReference<Object>(null);

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws IoTDBConnectionException {
        if (this.session.get() == null) {
            String host = context.getProperty(IOTDB_HOST).getValue();
            int port = Integer.parseInt(context.getProperty(IOTDB_PORT).getValue());
            String username = context.getProperty(USERNAME).getValue();
            String password = context.getProperty(PASSWORD).getValue();
            this.session.set(new Session.Builder().host(host).port(port).username(username).password(password).build());
            this.session.get().open();
        }
    }

    @OnStopped
    public void stop() {
        if (this.session.get() != null) {
            try {
                this.session.get().close();
            }
            catch (IoTDBConnectionException e) {
                this.getLogger().error("IoTDB disconnection failed", (Throwable)e);
            }
            this.session.set(null);
        }
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected TSDataType getType(RecordFieldType type) {
        return typeMap.get(type);
    }

    protected RecordFieldType getType(String type) {
        return reversedTypeMap.get(type);
    }

    protected ValidationResult validateSchemaAttribute(String schemaAttribute) {
        JsonNode schema;
        try {
            schema = mapper.readTree(schemaAttribute);
        }
        catch (JsonProcessingException e) {
            return new ValidationResult(false, e.getMessage());
        }
        HashSet keySet = new HashSet();
        schema.fieldNames().forEachRemaining(keySet::add);
        if (!keySet.contains(FIELDS)) {
            String msg = "The JSON of schema must contain `fields`";
            return new ValidationResult(false, msg);
        }
        for (int i = 0; i < schema.get(FIELDS).size(); ++i) {
            String msg;
            JsonNode field = schema.get(FIELDS).get(i);
            HashSet fieldKeySet = new HashSet();
            field.fieldNames().forEachRemaining(fieldKeySet::add);
            if (!fieldKeySet.contains("tsName") || !fieldKeySet.contains("dataType")) {
                msg = "`tsName` or `dataType` has not been set";
                return new ValidationResult(false, msg);
            }
            if (!DatabaseField.getSupportedDataType().contains(field.get("dataType").asText())) {
                msg = String.format("Unknown `dataType`: %s. The supported dataTypes are %s", field.get("dataType").asText(), DatabaseField.getSupportedDataType());
                return new ValidationResult(false, msg);
            }
            HashSet<String> supportedKeySet = new HashSet<String>();
            supportedKeySet.add("tsName");
            supportedKeySet.add("dataType");
            supportedKeySet.add("encoding");
            supportedKeySet.add("compressionType");
            HashSet<String> tmpKetSet = new HashSet<String>();
            tmpKetSet.addAll(supportedKeySet);
            tmpKetSet.addAll(fieldKeySet);
            tmpKetSet.removeAll(supportedKeySet);
            if (!tmpKetSet.isEmpty()) {
                String msg2 = "Unknown property or properties: " + String.valueOf(tmpKetSet);
                return new ValidationResult(false, msg2);
            }
            if (fieldKeySet.contains("compressionType") && !fieldKeySet.contains("encoding")) {
                String msg3 = "The `compressionType` has been set, but the `encoding` has not. The property `compressionType` will not take effect";
                return new ValidationResult(true, msg3);
            }
            if (field.get("encoding") != null && !DatabaseField.getSupportedEncoding().contains(field.get("encoding").asText())) {
                String msg4 = String.format("Unknown `encoding`: %s, The supported encoding types are %s", field.get("encoding").asText(), DatabaseField.getSupportedEncoding());
                return new ValidationResult(false, msg4);
            }
            if (field.get("compressionType") == null || DatabaseField.getSupportedCompressionType().contains(field.get("compressionType").asText())) continue;
            String msg5 = String.format("Unknown `compressionType`: %s, The supported compressionType are %s", field.get("compressionType").asText(), DatabaseField.getSupportedCompressionType());
            return new ValidationResult(false, msg5);
        }
        return new ValidationResult(true, null);
    }

    protected ValidationResult validateSchema(String timeField, RecordSchema recordSchema) {
        List fieldNames = recordSchema.getFieldNames();
        List dataTypes = recordSchema.getDataTypes();
        if (!fieldNames.contains(timeField)) {
            return new ValidationResult(false, "The fields must contain " + timeField);
        }
        fieldNames.remove(timeField);
        for (DataType type : dataTypes) {
            RecordFieldType dataType = type.getFieldType();
            if (supportedType.contains(dataType)) continue;
            String msg = String.format("Unknown `dataType`: %s. The supported dataTypes are %s", dataType.toString(), supportedType);
            return new ValidationResult(false, msg);
        }
        return new ValidationResult(true, null);
    }

    protected Map<String, List<String>> parseSchema(List<String> fieldNames) {
        LinkedHashMap<String, List<String>> deviceMeasurementMap = new LinkedHashMap<String, List<String>>();
        fieldNames.forEach(field -> {
            ArrayList<String> paths = new ArrayList<String>(Arrays.asList(field.split("\\.")));
            int lastIndex = paths.size() - 1;
            String lastPath = (String)paths.remove(lastIndex);
            String device = String.join((CharSequence)".", paths);
            if (!deviceMeasurementMap.containsKey(device)) {
                deviceMeasurementMap.put(device, new ArrayList());
            }
            ((List)deviceMeasurementMap.get(device)).add(lastPath);
        });
        return deviceMeasurementMap;
    }

    protected Map<String, Tablet> generateTablets(DatabaseSchema schema, String prefix, int maxRowNumber) {
        Map<String, List<String>> deviceMeasurementMap = this.parseSchema(schema.getFieldNames(prefix));
        LinkedHashMap<String, Tablet> tablets = new LinkedHashMap<String, Tablet>();
        deviceMeasurementMap.forEach((device, measurements) -> {
            ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
            for (String measurement : measurements) {
                TSDataType dataType = schema.getDataType(measurement);
                TSEncoding encoding = schema.getEncodingType(measurement);
                CompressionType compressionType = schema.getCompressionType(measurement);
                if (encoding == null) {
                    schemas.add(new MeasurementSchema(measurement, dataType));
                    continue;
                }
                if (compressionType == null) {
                    schemas.add(new MeasurementSchema(measurement, dataType, encoding));
                    continue;
                }
                schemas.add(new MeasurementSchema(measurement, dataType, encoding, compressionType));
            }
            Tablet tablet = new Tablet(device, schemas, maxRowNumber);
            tablets.put((String)device, tablet);
        });
        return tablets;
    }

    protected Object convertType(Object value, TSDataType type) {
        return switch (type) {
            case TSDataType.TEXT -> new Binary(String.valueOf(value), StandardCharsets.UTF_8);
            case TSDataType.INT32 -> Integer.valueOf(Integer.parseInt(value.toString()));
            case TSDataType.INT64 -> Long.valueOf(Long.parseLong(value.toString()));
            case TSDataType.FLOAT -> Float.valueOf(Float.parseFloat(value.toString()));
            case TSDataType.DOUBLE -> Double.valueOf(Double.parseDouble(value.toString()));
            case TSDataType.BOOLEAN -> Boolean.valueOf(Boolean.parseBoolean(value.toString()));
            default -> null;
        };
    }

    protected DatabaseSchema convertSchema(String timeField, RecordSchema recordSchema) {
        List fieldNames = recordSchema.getFieldNames();
        fieldNames.remove(timeField);
        ArrayList<DatabaseField> fields = new ArrayList<DatabaseField>();
        fieldNames.forEach(fieldName -> {
            Optional dataTypeFound = recordSchema.getDataType(fieldName);
            DataType dataType = (DataType)dataTypeFound.orElseThrow(() -> new IllegalArgumentException(String.format("Field [%s] Data Type not found", fieldName)));
            RecordFieldType recordFieldType = dataType.getFieldType();
            TSDataType timeSeriesDataType = this.getType(recordFieldType);
            DatabaseField field = new DatabaseField((String)fieldName, timeSeriesDataType);
            fields.add(field);
        });
        return new DatabaseSchema(fields);
    }

    static {
        typeMap.put(RecordFieldType.STRING, TSDataType.TEXT);
        typeMap.put(RecordFieldType.BOOLEAN, TSDataType.BOOLEAN);
        typeMap.put(RecordFieldType.INT, TSDataType.INT32);
        typeMap.put(RecordFieldType.LONG, TSDataType.INT64);
        typeMap.put(RecordFieldType.FLOAT, TSDataType.FLOAT);
        typeMap.put(RecordFieldType.DOUBLE, TSDataType.DOUBLE);
        for (Map.Entry<RecordFieldType, TSDataType> it : typeMap.entrySet()) {
            reversedTypeMap.put(String.valueOf(it.getValue()), it.getKey());
        }
        supportedType.add(RecordFieldType.BOOLEAN);
        supportedType.add(RecordFieldType.STRING);
        supportedType.add(RecordFieldType.INT);
        supportedType.add(RecordFieldType.LONG);
        supportedType.add(RecordFieldType.FLOAT);
        supportedType.add(RecordFieldType.DOUBLE);
        supportedType.add(RecordFieldType.TIMESTAMP);
        supportedType.add(RecordFieldType.TIME);
        supportedType.add(RecordFieldType.DATE);
    }
}

