/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.ignite.cache;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.IgniteCache;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.ignite.AbstractIgniteProcessor;

public abstract class AbstractIgniteCacheProcessor
extends AbstractIgniteProcessor {
    protected static final PropertyDescriptor CACHE_NAME = new PropertyDescriptor.Builder().displayName("Ignite Cache Name").name("ignite-cache-name").description("The name of the ignite cache").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor IGNITE_CACHE_ENTRY_KEY = new PropertyDescriptor.Builder().displayName("Ignite Cache Entry Identifier").name("ignite-cache-entry-identifier").description("A FlowFile attribute, or attribute expression used for determining Ignite cache key for the Flow File content").required(true).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    protected static Set<Relationship> relationships;
    private String cacheName;

    protected IgniteCache<String, byte[]> getIgniteCache() {
        if (this.getIgnite() == null) {
            return null;
        }
        return this.getIgnite().getOrCreateCache(this.cacheName);
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public void initializeIgniteCache(ProcessContext context) throws ProcessException {
        this.getLogger().info("Initializing Ignite cache");
        try {
            if (this.getIgnite() == null) {
                this.getLogger().info("Initializing ignite as client");
                super.initializeIgnite(context);
            }
            this.cacheName = context.getProperty(CACHE_NAME).getValue();
        }
        catch (Exception e) {
            this.getLogger().error("Failed to initialize ignite cache due to {}", new Object[]{e}, (Throwable)e);
            throw new ProcessException((Throwable)e);
        }
    }

    @OnShutdown
    public void closeIgniteCache() {
        if (this.getIgniteCache() != null) {
            this.getLogger().info("Closing ignite cache");
            this.getIgniteCache().close();
        }
        super.closeIgnite();
    }

    static {
        HashSet<Relationship> rels = new HashSet<Relationship>();
        rels.add(REL_SUCCESS);
        rels.add(REL_FAILURE);
        relationships = Collections.unmodifiableSet(rels);
    }
}

