/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hl7.query.evaluator.logic;

import java.util.Map;
import org.apache.nifi.hl7.query.evaluator.BooleanEvaluator;

public class AndEvaluator
extends BooleanEvaluator {
    private final BooleanEvaluator lhs;
    private final BooleanEvaluator rhs;

    public AndEvaluator(BooleanEvaluator lhs, BooleanEvaluator rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public Boolean evaluate(Map<String, Object> objectMap) {
        Boolean lhsValue = (Boolean)this.lhs.evaluate(objectMap);
        if (lhsValue == null || Boolean.FALSE.equals(lhsValue)) {
            return false;
        }
        Boolean rhsValue = (Boolean)this.rhs.evaluate(objectMap);
        return rhsValue != null && Boolean.TRUE.equals(rhsValue);
    }
}

