/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hl7.query.evaluator.comparison;

import java.util.Collection;
import java.util.Map;
import org.apache.nifi.hl7.model.HL7Component;
import org.apache.nifi.hl7.query.evaluator.BooleanEvaluator;
import org.apache.nifi.hl7.query.evaluator.Evaluator;

public class IsNullEvaluator
extends BooleanEvaluator {
    private final Evaluator<?> subjectEvaluator;

    public IsNullEvaluator(Evaluator<?> subjectEvaluator) {
        this.subjectEvaluator = subjectEvaluator;
    }

    @Override
    public Boolean evaluate(Map<String, Object> objectMap) {
        Object subjectValue = this.subjectEvaluator.evaluate(objectMap);
        if (subjectValue == null) {
            return true;
        }
        return this.isNull(subjectValue);
    }

    private boolean isNull(Object subjectValue) {
        if (subjectValue == null) {
            return true;
        }
        if (subjectValue instanceof HL7Component) {
            subjectValue = ((HL7Component)subjectValue).getValue();
        }
        if (subjectValue instanceof Collection) {
            Collection collection = (Collection)subjectValue;
            if (collection.isEmpty()) {
                return true;
            }
            for (Object obj : collection) {
                if (this.isNull(obj)) continue;
                return false;
            }
            return true;
        }
        return subjectValue == null;
    }
}

