/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hl7.hapi;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.hl7.hapi.HapiSegment;
import org.apache.nifi.hl7.model.HL7Message;
import org.apache.nifi.hl7.model.HL7Segment;

public class HapiMessage
implements HL7Message {
    private final Message message;
    private final List<HL7Segment> allSegments;
    private final Map<String, List<HL7Segment>> segmentMap;

    public HapiMessage(Message message) throws HL7Exception {
        this.message = message;
        this.allSegments = new ArrayList<HL7Segment>();
        this.populateSegments((Group)message, this.allSegments);
        this.segmentMap = new HashMap<String, List<HL7Segment>>();
        for (HL7Segment segment : this.allSegments) {
            String segmentName = segment.getName();
            List<HL7Segment> segmentList = this.segmentMap.get(segmentName);
            if (segmentList == null) {
                segmentList = new ArrayList<HL7Segment>();
                this.segmentMap.put(segmentName, segmentList);
            }
            segmentList.add(segment);
        }
    }

    private void populateSegments(Group group, List<HL7Segment> segments) throws HL7Exception {
        for (String structureName : group.getNames()) {
            Structure[] structures = group.getAll(structureName);
            if (group.isGroup(structureName)) {
                for (Structure structure : structures) {
                    this.populateSegments((Group)structure, segments);
                }
                continue;
            }
            for (Structure structure : structures) {
                Segment segment = (Segment)structure;
                HapiSegment hapiSegment = new HapiSegment(segment);
                segments.add(hapiSegment);
            }
        }
    }

    @Override
    public List<HL7Segment> getSegments() {
        return Collections.unmodifiableList(this.allSegments);
    }

    @Override
    public List<HL7Segment> getSegments(String segmentType) {
        List<HL7Segment> segments = this.segmentMap.get(segmentType);
        if (segments == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(segments);
    }

    public String toString() {
        return this.message.toString();
    }
}

