/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hl7.hapi;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.ExtraComponents;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.PipeParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.hl7.hapi.SingleValueField;
import org.apache.nifi.hl7.model.HL7Component;
import org.apache.nifi.hl7.model.HL7Field;

public class HapiField
implements HL7Field,
HL7Component {
    private final String value;
    private final List<HL7Component> components;

    public HapiField(Type type) {
        ExtraComponents extra;
        this.value = PipeParser.encode((Type)type, (EncodingCharacters)EncodingCharacters.defaultInstance());
        ArrayList<HL7Field> componentList = new ArrayList<HL7Field>();
        if (type instanceof Composite) {
            Composite composite = (Composite)type;
            for (Type component : composite.getComponents()) {
                componentList.add(new HapiField(component));
            }
        }
        if ((extra = type.getExtraComponents()) != null && extra.numComponents() > 0) {
            String singleFieldValue = type instanceof Primitive ? ((Primitive)type).getValue() : this.value;
            componentList.add(new SingleValueField(singleFieldValue));
            for (int i = 0; i < extra.numComponents(); ++i) {
                componentList.add(new HapiField((Type)extra.getComponent(i)));
            }
        }
        this.components = Collections.unmodifiableList(componentList);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public List<HL7Component> getComponents() {
        return this.components;
    }

    public String toString() {
        return this.value;
    }
}

