/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop.util.writer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.PathFilter;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processors.hadoop.util.FileStatusIterable;
import org.apache.nifi.processors.hadoop.util.FileStatusManager;
import org.apache.nifi.processors.hadoop.util.writer.HadoopFileStatusWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;

public class FlowFileHadoopFileStatusWriter
extends HadoopFileStatusWriter {
    public FlowFileHadoopFileStatusWriter(ProcessSession session, Relationship successRelationship, FileStatusIterable fileStatusIterable, FileStatusManager fileStatusManager, PathFilter pathFilter, long minimumAge, long maximumAge, long previousLatestTimestamp, List<String> previousLatestFiles, RecordSetWriterFactory writerFactory, String hdfsPrefix, ComponentLog logger) {
        super(session, successRelationship, fileStatusIterable, fileStatusManager, pathFilter, minimumAge, maximumAge, previousLatestTimestamp, previousLatestFiles, writerFactory, hdfsPrefix, logger);
    }

    @Override
    public void write() {
        for (FileStatus status : this.fileStatusIterable) {
            if (!this.determineListable(status)) continue;
            Map<String, String> attributes = this.createAttributes(status);
            FlowFile flowFile = this.session.create();
            flowFile = this.session.putAllAttributes(flowFile, attributes);
            this.session.transfer(flowFile, this.successRelationship);
            this.fileStatusManager.update(status);
            ++this.fileCount;
        }
    }

    private Map<String, String> createAttributes(FileStatus status) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(CoreAttributes.FILENAME.key(), status.getPath().getName());
        attributes.put(CoreAttributes.PATH.key(), this.getAbsolutePath(status.getPath().getParent()));
        attributes.put(this.hdfsPrefix + ".owner", status.getOwner());
        attributes.put(this.hdfsPrefix + ".group", status.getGroup());
        attributes.put(this.hdfsPrefix + ".lastModified", String.valueOf(status.getModificationTime()));
        attributes.put(this.hdfsPrefix + ".length", String.valueOf(status.getLen()));
        attributes.put(this.hdfsPrefix + ".replication", String.valueOf(status.getReplication()));
        attributes.put(this.hdfsPrefix + ".permissions", this.getPermissionsString(status.getPermission()));
        return attributes;
    }
}

