/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop.util.writer;

import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processors.hadoop.util.FileStatusIterable;
import org.apache.nifi.processors.hadoop.util.FileStatusManager;
import org.apache.nifi.processors.hadoop.util.writer.FlowFileHadoopFileStatusWriter;
import org.apache.nifi.processors.hadoop.util.writer.RecordHadoopFileStatusWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;

public abstract class HadoopFileStatusWriter {
    protected final ProcessSession session;
    protected final Relationship successRelationship;
    protected final FileStatusIterable fileStatusIterable;
    protected final FileStatusManager fileStatusManager;
    protected final PathFilter pathFilter;
    protected final long minimumAge;
    protected final long maximumAge;
    protected final long previousLatestTimestamp;
    protected final List<String> previousLatestFiles;
    protected final RecordSetWriterFactory writerFactory;
    protected final String hdfsPrefix;
    protected final ComponentLog logger;
    protected final long currentTimeMillis;
    protected long fileCount;

    public HadoopFileStatusWriter(ProcessSession session, Relationship successRelationship, FileStatusIterable fileStatusIterable, FileStatusManager fileStatusManager, PathFilter pathFilter, long minimumAge, long maximumAge, long previousLatestTimestamp, List<String> previousLatestFiles, RecordSetWriterFactory writerFactory, String hdfsPrefix, ComponentLog logger) {
        this.session = session;
        this.successRelationship = successRelationship;
        this.fileStatusIterable = fileStatusIterable;
        this.fileStatusManager = fileStatusManager;
        this.pathFilter = pathFilter;
        this.minimumAge = minimumAge;
        this.maximumAge = maximumAge;
        this.previousLatestTimestamp = previousLatestTimestamp;
        this.previousLatestFiles = previousLatestFiles;
        this.writerFactory = writerFactory;
        this.hdfsPrefix = hdfsPrefix;
        this.logger = logger;
        this.currentTimeMillis = System.currentTimeMillis();
        this.fileCount = 0L;
    }

    public abstract void write();

    public long getListedFileCount() {
        return this.fileCount;
    }

    protected boolean determineListable(FileStatus status) {
        boolean isCopyInProgress = status.getPath().getName().endsWith("_COPYING_");
        boolean isFilterAccepted = this.pathFilter.accept(status.getPath());
        if (isCopyInProgress || !isFilterAccepted) {
            return false;
        }
        if (status.getModificationTime() == this.previousLatestTimestamp) {
            return !this.previousLatestFiles.contains(status.getPath().toString());
        }
        long fileAge = this.currentTimeMillis - status.getModificationTime();
        if (this.minimumAge > fileAge || fileAge > this.maximumAge) {
            return false;
        }
        return status.getModificationTime() > this.previousLatestTimestamp;
    }

    String getAbsolutePath(Path path) {
        Path parent = path.getParent();
        String prefix = parent == null || parent.getName().equals("") ? "" : this.getAbsolutePath(parent);
        return prefix + "/" + path.getName();
    }

    String getPerms(FsAction action) {
        StringBuilder sb = new StringBuilder();
        sb.append(action.implies(FsAction.READ) ? "r" : "-");
        sb.append(action.implies(FsAction.WRITE) ? "w" : "-");
        sb.append(action.implies(FsAction.EXECUTE) ? "x" : "-");
        return sb.toString();
    }

    String getPermissionsString(FsPermission permission) {
        return String.format("%s%s%s", this.getPerms(permission.getUserAction()), this.getPerms(permission.getGroupAction()), this.getPerms(permission.getOtherAction()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public ProcessSession getSession() {
        return this.session;
    }

    public Relationship getSuccessRelationship() {
        return this.successRelationship;
    }

    public FileStatusIterable getFileStatusIterable() {
        return this.fileStatusIterable;
    }

    public FileStatusManager getFileStatusManager() {
        return this.fileStatusManager;
    }

    public PathFilter getPathFilter() {
        return this.pathFilter;
    }

    public long getMinimumAge() {
        return this.minimumAge;
    }

    public long getMaximumAge() {
        return this.maximumAge;
    }

    public long getPreviousLatestTimestamp() {
        return this.previousLatestTimestamp;
    }

    public List<String> getPreviousLatestFiles() {
        return this.previousLatestFiles;
    }

    public RecordSetWriterFactory getWriterFactory() {
        return this.writerFactory;
    }

    public String getHdfsPrefix() {
        return this.hdfsPrefix;
    }

    public ComponentLog getLogger() {
        return this.logger;
    }

    public static class Builder {
        private ProcessSession session;
        private FileStatusIterable fileStatusIterable;
        private long minimumAge;
        private long maximumAge;
        private PathFilter pathFilter;
        private FileStatusManager fileStatusManager;
        private long previousLatestTimestamp;
        private List<String> previousLatestFiles;
        private Relationship successRelationship;
        private RecordSetWriterFactory writerFactory;
        private ComponentLog logger;
        private String hdfsPrefix;

        public Builder session(ProcessSession session) {
            this.session = session;
            return this;
        }

        public Builder fileStatusIterable(FileStatusIterable fileStatusIterable) {
            this.fileStatusIterable = fileStatusIterable;
            return this;
        }

        public Builder minimumAge(long minimumAge) {
            this.minimumAge = minimumAge;
            return this;
        }

        public Builder maximumAge(long maximumAge) {
            this.maximumAge = maximumAge;
            return this;
        }

        public Builder pathFilter(PathFilter pathFilter) {
            this.pathFilter = pathFilter;
            return this;
        }

        public Builder fileStatusManager(FileStatusManager fileStatusManager) {
            this.fileStatusManager = fileStatusManager;
            return this;
        }

        public Builder previousLatestTimestamp(long previousLatestTimestamp) {
            this.previousLatestTimestamp = previousLatestTimestamp;
            return this;
        }

        public Builder previousLatestFiles(List<String> previousLatestFiles) {
            this.previousLatestFiles = previousLatestFiles;
            return this;
        }

        public Builder successRelationship(Relationship successRelationship) {
            this.successRelationship = successRelationship;
            return this;
        }

        public Builder writerFactory(RecordSetWriterFactory writerFactory) {
            this.writerFactory = writerFactory;
            return this;
        }

        public Builder logger(ComponentLog logger) {
            this.logger = logger;
            return this;
        }

        public Builder hdfsPrefix(String hdfsPrefix) {
            this.hdfsPrefix = hdfsPrefix;
            return this;
        }

        public HadoopFileStatusWriter build() {
            this.validateMandatoryField("session", this.session);
            this.validateMandatoryField("successRelationship", this.successRelationship);
            this.validateMandatoryField("fileStatusIterable", this.fileStatusIterable);
            this.validateMandatoryField("fileStatusManager", this.fileStatusManager);
            if (this.writerFactory == null) {
                return new FlowFileHadoopFileStatusWriter(this.session, this.successRelationship, this.fileStatusIterable, this.fileStatusManager, this.pathFilter, this.minimumAge, this.maximumAge, this.previousLatestTimestamp, this.previousLatestFiles, this.writerFactory, this.hdfsPrefix, this.logger);
            }
            return new RecordHadoopFileStatusWriter(this.session, this.successRelationship, this.fileStatusIterable, this.fileStatusManager, this.pathFilter, this.minimumAge, this.maximumAge, this.previousLatestTimestamp, this.previousLatestFiles, this.writerFactory, this.hdfsPrefix, this.logger);
        }

        private void validateMandatoryField(String variableName, Object variable) {
            if (variable == null) {
                throw new IllegalArgumentException(variableName + " is null but must be set");
            }
        }
    }
}

