/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop.inotify;

import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

class NotificationEventPathFilter
implements PathFilter {
    private final Pattern watchDirectory;
    private final boolean toIgnoreHiddenFiles;

    NotificationEventPathFilter(Pattern watchDirectory, boolean toIgnoreHiddenFiles) {
        this.watchDirectory = watchDirectory;
        this.toIgnoreHiddenFiles = toIgnoreHiddenFiles;
    }

    public boolean accept(Path path) {
        return path != null && (!this.toIgnoreHiddenFiles || !path.getName().startsWith(".")) && this.watchDirectory.matcher(path.toString()).matches();
    }
}

