/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hazelcast.services.cacheclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.distributed.cache.client.AtomicCacheEntry;
import org.apache.nifi.distributed.cache.client.AtomicDistributedMapCacheClient;
import org.apache.nifi.distributed.cache.client.Deserializer;
import org.apache.nifi.distributed.cache.client.Serializer;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.hazelcast.services.cache.HazelcastCache;
import org.apache.nifi.hazelcast.services.cachemanager.HazelcastCacheManager;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.util.StandardValidators;

@Tags(value={"hazelcast", "cache", "map"})
@CapabilityDescription(value="An implementation of DistributedMapCacheClient that uses Hazelcast as the backing cache. This service relies on an other controller service, manages the actual Hazelcast calls, set in Hazelcast Cache Manager.")
public class HazelcastMapCacheClient
extends AbstractControllerService
implements AtomicDistributedMapCacheClient<Long> {
    public static final PropertyDescriptor HAZELCAST_CACHE_MANAGER = new PropertyDescriptor.Builder().name("Hazelcast Cache Manager").description("A Hazelcast Cache Manager which manages connections to Hazelcast and provides cache instances.").identifiesControllerService(HazelcastCacheManager.class).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor HAZELCAST_CACHE_NAME = new PropertyDescriptor.Builder().name("Hazelcast Cache Name").description("The name of a given cache. A Hazelcast cluster may handle multiple independent caches, each identified by a name. Clients using caches with the same name are working on the same data structure within Hazelcast.").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).build();
    public static final PropertyDescriptor HAZELCAST_ENTRY_TTL = new PropertyDescriptor.Builder().name("Hazelcast Entry Lifetime").description("Indicates how long the written entries should exist in Hazelcast. Setting it to '0 secs' means that the datawill exists until its deletion or until the Hazelcast server is shut down. Using `EmbeddedHazelcastCacheManager` ascache manager will not provide policies to limit the size of the cache.").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("5 min").build();
    private static final long STARTING_REVISION = 1L;
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(HAZELCAST_CACHE_MANAGER, HAZELCAST_CACHE_NAME, HAZELCAST_ENTRY_TTL);
    private volatile HazelcastCache cache = null;

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        HazelcastCacheManager hazelcastCacheManager = (HazelcastCacheManager)context.getProperty(HAZELCAST_CACHE_MANAGER).asControllerService(HazelcastCacheManager.class);
        this.cache = hazelcastCacheManager.getCache(context.getProperty(HAZELCAST_CACHE_NAME).evaluateAttributeExpressions().getValue(), context.getProperty(HAZELCAST_ENTRY_TTL).asTimePeriod(TimeUnit.MILLISECONDS).longValue());
        this.getLogger().debug("Enable Hazelcast cache client for cache {}", new Object[]{this.cache.name()});
    }

    @OnDisabled
    public void onDisabled() {
        if (this.cache != null) {
            this.getLogger().debug("Disable Hazelcast cache client for cache {}", new Object[]{this.cache.name()});
            this.cache = null;
        }
    }

    public <K> Set<K> keySet(Deserializer<K> keyDeserializer) throws IOException {
        HashSet<K> keySet = new HashSet<K>();
        for (String key : this.cache.keySet()) {
            keySet.add(HazelcastMapCacheClient.parseCacheEntryKey(key, keyDeserializer));
        }
        return keySet;
    }

    public <K, V> AtomicCacheEntry<K, V, Long> fetch(K key, Serializer<K> keySerializer, Deserializer<V> valueDeserializer) throws IOException {
        byte[] result = this.cache.get(this.serializeCacheEntryKey(key, keySerializer));
        return result == null ? null : new AtomicCacheEntry(key, HazelcastMapCacheClient.parsePayload(valueDeserializer, result), (Object)HazelcastMapCacheClient.parseRevision(result));
    }

    public <K, V> boolean replace(AtomicCacheEntry<K, V, Long> entry, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
        if (entry.getKey() == null) {
            return false;
        }
        String key = this.serializeCacheEntryKey(entry.getKey(), keySerializer);
        try (HazelcastCache.HazelcastCacheEntryLock ignored = this.cache.acquireLock(key);){
            byte[] oldValue = this.cache.get(key);
            if (oldValue == null && (entry.getRevision().isEmpty() || (Long)entry.getRevision().get() < 1L)) {
                this.cache.put(key, this.serializeCacheEntryValue(entry.getValue(), valueSerializer, 1L));
                this.getLogger().debug("Entry with key {} was added during replace", new Object[]{key});
                boolean bl = true;
                return bl;
            }
            if (oldValue != null && Objects.equals(entry.getRevision().get(), HazelcastMapCacheClient.parseRevision(oldValue))) {
                long newRevision = (Long)entry.getRevision().get() + 1L;
                this.cache.put(key, this.serializeCacheEntryValue(entry.getValue(), valueSerializer, newRevision));
                this.getLogger().debug("Entry with key {} was updated during replace, with revision {}", new Object[]{key, newRevision});
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public <K, V> boolean putIfAbsent(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
        return this.cache.putIfAbsent(this.serializeCacheEntryKey(key, keySerializer), this.serializeCacheEntryValue(value, valueSerializer, 1L)) == null;
    }

    public <K, V> V getAndPutIfAbsent(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer, Deserializer<V> valueDeserializer) throws IOException {
        byte[] result = this.cache.putIfAbsent(this.serializeCacheEntryKey(key, keySerializer), this.serializeCacheEntryValue(value, valueSerializer, 1L));
        return result == null ? null : (V)HazelcastMapCacheClient.parsePayload(valueDeserializer, result);
    }

    public <K> boolean containsKey(K key, Serializer<K> keySerializer) throws IOException {
        return this.cache.contains(this.serializeCacheEntryKey(key, keySerializer));
    }

    public <K, V> void put(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
        this.cache.put(this.serializeCacheEntryKey(key, keySerializer), this.serializeCacheEntryValue(value, valueSerializer, 1L));
    }

    public <K, V> V get(K key, Serializer<K> keySerializer, Deserializer<V> valueDeserializer) throws IOException {
        byte[] result = this.cache.get(this.serializeCacheEntryKey(key, keySerializer));
        return result == null ? null : (V)HazelcastMapCacheClient.parsePayload(valueDeserializer, result);
    }

    public <K> boolean remove(K key, Serializer<K> keySerializer) throws IOException {
        return this.cache.remove(this.serializeCacheEntryKey(key, keySerializer));
    }

    public void close() {
        this.getLogger().debug("Closing {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("hazelcast-cache-manager", HAZELCAST_CACHE_MANAGER.getName());
        config.renameProperty("hazelcast-cache-name", HAZELCAST_CACHE_NAME.getName());
        config.renameProperty("hazelcast-entry-ttl", HAZELCAST_ENTRY_TTL.getName());
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    private <S> String serializeCacheEntryKey(S key, Serializer<S> serializer) throws IOException {
        String result;
        if (key instanceof String) {
            result = (String)key;
        } else {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            serializer.serialize(key, (OutputStream)stream);
            result = stream.toString(StandardCharsets.UTF_8);
        }
        if (result.isEmpty()) {
            throw new IOException("Cache record key cannot be empty!");
        }
        return result;
    }

    private static <K> K parseCacheEntryKey(String key, Deserializer<K> keyDeserializer) throws IOException {
        byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
        return (K)keyDeserializer.deserialize(keyBytes);
    }

    private <S> byte[] serializeCacheEntryValue(S value, Serializer<S> serializer, long version) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.write(this.getVersionByteArray(version));
        serializer.serialize(value, (OutputStream)stream);
        return stream.toByteArray();
    }

    private static long parseRevision(byte[] value) {
        return ByteBuffer.wrap(Arrays.copyOfRange(value, 0, 8)).getLong();
    }

    private static <V> V parsePayload(Deserializer<V> deserializer, byte[] value) throws IOException {
        return (V)deserializer.deserialize(Arrays.copyOfRange(value, 8, value.length));
    }

    private byte[] getVersionByteArray(long version) {
        return ByteBuffer.allocate(8).putLong(version).array();
    }
}

