/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.gitlab;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.gitlab.GitLabAuthenticationType;
import org.apache.nifi.gitlab.GitLabRepositoryClient;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.registry.flow.FlowRegistryClientConfigurationContext;
import org.apache.nifi.registry.flow.FlowRegistryException;
import org.apache.nifi.registry.flow.git.AbstractGitFlowRegistryClient;
import org.apache.nifi.registry.flow.git.client.GitRepositoryClient;
import org.apache.nifi.ssl.SSLContextProvider;
import org.gitlab4j.api.GitLabApi;

@Tags(value={"git", "gitlab", "registry", "flow"})
@CapabilityDescription(value="Flow Registry Client that uses the GitLab REST API to version control flows in a GitLab Project.")
public class GitLabFlowRegistryClient
extends AbstractGitFlowRegistryClient {
    static final PropertyDescriptor GITLAB_API_URL = new PropertyDescriptor.Builder().name("GitLab API URL").description("The URL of the GitLab API").addValidator(StandardValidators.URL_VALIDATOR).defaultValue("https://gitlab.com/").required(true).build();
    static final PropertyDescriptor GITLAB_API_VERSION = new PropertyDescriptor.Builder().name("GitLab API Version").description("The version of the GitLab API").allowableValues(GitLabApi.ApiVersion.class).defaultValue(GitLabApi.ApiVersion.V4.name()).required(true).build();
    static final PropertyDescriptor REPOSITORY_NAMESPACE = new PropertyDescriptor.Builder().name("Repository Namespace").description("The namespace of the repository. Typically the name of a group that owns the repository.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).build();
    static final PropertyDescriptor REPOSITORY_NAME = new PropertyDescriptor.Builder().name("Repository Name").description("The name of the repository").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).build();
    static final PropertyDescriptor AUTHENTICATION_TYPE = new PropertyDescriptor.Builder().name("Authentication Type").description("The type of authentication to use for accessing GitLab").allowableValues(GitLabAuthenticationType.class).defaultValue((DescribedValue)GitLabAuthenticationType.ACCESS_TOKEN).required(true).build();
    static final PropertyDescriptor ACCESS_TOKEN = new PropertyDescriptor.Builder().name("Access Token").description("The access token to use for authentication").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).sensitive(true).dependsOn(AUTHENTICATION_TYPE, (DescribedValue)GitLabAuthenticationType.ACCESS_TOKEN, new DescribedValue[0]).build();
    static final PropertyDescriptor CONNECT_TIMEOUT = new PropertyDescriptor.Builder().name("Connect Timeout").defaultValue("The timeout for connecting to the API").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).required(true).defaultValue("10 seconds").build();
    static final PropertyDescriptor READ_TIMEOUT = new PropertyDescriptor.Builder().name("Read Timeout").defaultValue("The timeout for reading from the API").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).required(true).defaultValue("10 seconds").build();
    static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(GITLAB_API_URL, GITLAB_API_VERSION, REPOSITORY_NAMESPACE, REPOSITORY_NAME, AUTHENTICATION_TYPE, ACCESS_TOKEN, CONNECT_TIMEOUT, READ_TIMEOUT);
    static final String STORAGE_LOCATION_PREFIX = "git@gitlab.com:";
    static final String STORAGE_LOCATION_FORMAT = "git@gitlab.com:%s/%s.git";

    protected List<PropertyDescriptor> createPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected String getStorageLocation(GitRepositoryClient repositoryClient) {
        GitLabRepositoryClient gitLabRepositoryClient = (GitLabRepositoryClient)repositoryClient;
        return STORAGE_LOCATION_FORMAT.formatted(gitLabRepositoryClient.getRepoNamespace(), gitLabRepositoryClient.getRepoName());
    }

    public boolean isStorageLocationApplicable(FlowRegistryClientConfigurationContext context, String location) {
        return location != null && location.startsWith(STORAGE_LOCATION_PREFIX);
    }

    protected GitRepositoryClient createRepositoryClient(FlowRegistryClientConfigurationContext context) throws FlowRegistryException {
        return GitLabRepositoryClient.builder().clientId(this.getIdentifier()).logger(this.getLogger()).apiUrl(context.getProperty(GITLAB_API_URL).getValue()).apiVersion((GitLabApi.ApiVersion)context.getProperty(GITLAB_API_VERSION).asAllowableValue(GitLabApi.ApiVersion.class)).repoNamespace(context.getProperty(REPOSITORY_NAMESPACE).getValue()).repoName(context.getProperty(REPOSITORY_NAME).getValue()).repoPath(context.getProperty(REPOSITORY_PATH).getValue()).authenticationType((GitLabAuthenticationType)context.getProperty(AUTHENTICATION_TYPE).asAllowableValue(GitLabAuthenticationType.class)).authToken(context.getProperty(ACCESS_TOKEN).evaluateAttributeExpressions().getValue()).connectTimeout(context.getProperty(CONNECT_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue()).readTimeout(context.getProperty(READ_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue()).sslContext((SSLContextProvider)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextProvider.class)).build();
    }
}

