/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.git.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedParameter;

public class VersionedComponentCollectionSerializer
extends StdSerializer<Collection<?>> {
    public VersionedComponentCollectionSerializer() {
        super(Collection.class);
    }

    public void serialize(Collection<?> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value.isEmpty()) {
            gen.writeStartArray();
            gen.writeEndArray();
            return;
        }
        ArrayList list = new ArrayList(value);
        if (list.get(0) instanceof VersionedComponent) {
            list.sort(Comparator.comparing(c -> ((VersionedComponent)c).getIdentifier()));
        } else if (list.get(0) instanceof VersionedParameter) {
            list.sort(Comparator.comparing(c -> ((VersionedParameter)c).getName()));
        }
        gen.writeStartArray();
        for (Object e : list) {
            serializers.defaultSerializeValue(e, gen);
        }
        gen.writeEndArray();
    }
}

