/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.git.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class SortedStringListSerializer
extends StdSerializer<List<String>>
implements ContextualSerializer {
    private final JsonSerializer<Object> defaultSerializer;
    private final Set<String> fieldsToSkipSorting;
    private final String currentFieldName;

    public SortedStringListSerializer(JsonSerializer<Object> defaultSerializer, Set<String> fieldsToSkipSorting) {
        this(defaultSerializer, fieldsToSkipSorting, null);
    }

    public SortedStringListSerializer(JsonSerializer<Object> defaultSerializer, Set<String> fieldsToSkipSorting, String currentFieldName) {
        super(List.class);
        this.defaultSerializer = defaultSerializer;
        this.fieldsToSkipSorting = fieldsToSkipSorting;
        this.currentFieldName = currentFieldName;
    }

    public void serialize(List<String> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this.fieldsToSkipSorting.contains(this.currentFieldName)) {
            this.defaultSerializer.serialize(value, gen, provider);
            return;
        }
        ArrayList<String> sorted = new ArrayList<String>(value);
        Collections.sort(sorted);
        gen.writeStartArray();
        for (String str : sorted) {
            gen.writeString(str);
        }
        gen.writeEndArray();
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonSerializer defaultSer = prov.findValueSerializer(prov.constructType(List.class), property);
        String fieldName = property != null ? property.getName() : null;
        return new SortedStringListSerializer((JsonSerializer<Object>)defaultSer, this.fieldsToSkipSorting, fieldName);
    }
}

