/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.git.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;
import java.util.Set;

public class SortedEnumSetSerializer
extends StdSerializer<Set<? extends Enum<?>>> {
    public SortedEnumSetSerializer() {
        super(Set.class);
    }

    public void serialize(Set<? extends Enum<?>> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        List<String> sorted = value.stream().map(Enum::name).sorted().toList();
        gen.writeStartArray();
        for (String str : sorted) {
            gen.writeString(str);
        }
        gen.writeEndArray();
    }
}

