/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.git;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.flow.ConnectableComponent;
import org.apache.nifi.flow.Position;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedConnection;
import org.apache.nifi.flow.VersionedFlowCoordinates;
import org.apache.nifi.flow.VersionedParameter;
import org.apache.nifi.flow.VersionedParameterContext;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.registry.flow.AbstractFlowRegistryClient;
import org.apache.nifi.registry.flow.AuthorizationException;
import org.apache.nifi.registry.flow.BucketLocation;
import org.apache.nifi.registry.flow.FlowAlreadyExistsException;
import org.apache.nifi.registry.flow.FlowLocation;
import org.apache.nifi.registry.flow.FlowRegistryBranch;
import org.apache.nifi.registry.flow.FlowRegistryBucket;
import org.apache.nifi.registry.flow.FlowRegistryClientConfigurationContext;
import org.apache.nifi.registry.flow.FlowRegistryClientInitializationContext;
import org.apache.nifi.registry.flow.FlowRegistryException;
import org.apache.nifi.registry.flow.FlowRegistryPermissions;
import org.apache.nifi.registry.flow.FlowVersionLocation;
import org.apache.nifi.registry.flow.RegisterAction;
import org.apache.nifi.registry.flow.RegisteredFlow;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshot;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshotMetadata;
import org.apache.nifi.registry.flow.git.client.GitCommit;
import org.apache.nifi.registry.flow.git.client.GitCreateContentRequest;
import org.apache.nifi.registry.flow.git.client.GitRepositoryClient;
import org.apache.nifi.registry.flow.git.serialize.FlowSnapshotSerializer;
import org.apache.nifi.registry.flow.git.serialize.JacksonFlowSnapshotSerializer;
import org.apache.nifi.util.StringUtils;

public abstract class AbstractGitFlowRegistryClient
extends AbstractFlowRegistryClient {
    public static final PropertyDescriptor REPOSITORY_BRANCH = new PropertyDescriptor.Builder().name("Default Branch").description("The default branch to use for this client").addValidator(StandardValidators.NON_BLANK_VALIDATOR).defaultValue("main").required(true).build();
    public static final PropertyDescriptor REPOSITORY_PATH = new PropertyDescriptor.Builder().name("Repository Path").description("The path in the repository that this client will use to store all data. If left blank, then the root of the repository will be used.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(false).build();
    public static final PropertyDescriptor DIRECTORY_FILTER_EXCLUDE = new PropertyDescriptor.Builder().name("Directory Filter Exclusion").description("Directories whose names match the given regular expression will be ignored when listing buckets.").defaultValue("[.].*").addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).required(true).build();
    public static final PropertyDescriptor PARAMETER_CONTEXT_VALUES = new PropertyDescriptor.Builder().name("Parameter Context Values").description("Specifies what to do with parameter values when storing the versioned flow.").allowableValues(ParameterContextValuesStrategy.class).defaultValue((DescribedValue)ParameterContextValuesStrategy.RETAIN).required(true).build();
    static final String DEFAULT_BUCKET_NAME = "default";
    static final String DEFAULT_BUCKET_KEEP_FILE_PATH = "default/.keep";
    static final String DEFAULT_BUCKET_KEEP_FILE_CONTENT = "Do Not Delete";
    static final String DEFAULT_BUCKET_KEEP_FILE_MESSAGE = "Creating default bucket";
    static final String REGISTER_FLOW_MESSAGE_PREFIX = "Registering Flow";
    static final String REGISTER_FLOW_MESSAGE_FORMAT = "Registering Flow [%s]";
    static final String DEREGISTER_FLOW_MESSAGE_FORMAT = "Deregistering Flow [%s]";
    static final String DEFAULT_FLOW_SNAPSHOT_MESSAGE_FORMAT = "Saving Flow Snapshot %s";
    static final String SNAPSHOT_FILE_EXTENSION = ".json";
    static final String SNAPSHOT_FILE_PATH_FORMAT = "%s/%s.json";
    static final String FLOW_CONTENTS_GROUP_ID = "flow-contents-group";
    private volatile FlowSnapshotSerializer flowSnapshotSerializer;
    private volatile GitRepositoryClient repositoryClient;
    private volatile Pattern directoryExclusionPattern;
    private final AtomicBoolean clientInitialized = new AtomicBoolean(false);
    private volatile List<PropertyDescriptor> propertyDescriptors;

    public void initialize(FlowRegistryClientInitializationContext context) {
        super.initialize(context);
        ArrayList<PropertyDescriptor> combinedPropertyDescriptors = new ArrayList<PropertyDescriptor>(this.createPropertyDescriptors());
        combinedPropertyDescriptors.add(REPOSITORY_BRANCH);
        combinedPropertyDescriptors.add(REPOSITORY_PATH);
        combinedPropertyDescriptors.add(DIRECTORY_FILTER_EXCLUDE);
        combinedPropertyDescriptors.add(PARAMETER_CONTEXT_VALUES);
        this.propertyDescriptors = Collections.unmodifiableList(combinedPropertyDescriptors);
        this.flowSnapshotSerializer = this.createFlowSnapshotSerializer();
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        String repoPath = validationContext.getProperty(REPOSITORY_PATH).getValue();
        if (repoPath != null && (repoPath.startsWith("/") || repoPath.endsWith("/"))) {
            results.add(new ValidationResult.Builder().subject(REPOSITORY_PATH.getDisplayName()).valid(false).explanation("Path can not start or end with /").build());
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        super.onPropertyModified(descriptor, oldValue, newValue);
        AbstractGitFlowRegistryClient abstractGitFlowRegistryClient = this;
        synchronized (abstractGitFlowRegistryClient) {
            this.invalidateClient();
        }
    }

    public boolean isBranchingSupported(FlowRegistryClientConfigurationContext context) {
        return true;
    }

    public Set<FlowRegistryBranch> getBranches(FlowRegistryClientConfigurationContext context) throws FlowRegistryException, IOException {
        GitRepositoryClient repositoryClient = this.getRepositoryClient(context);
        this.verifyReadPermissions(repositoryClient);
        return repositoryClient.getBranches().stream().map(branchName -> {
            FlowRegistryBranch flowRegistryBranch = new FlowRegistryBranch();
            flowRegistryBranch.setName(branchName);
            return flowRegistryBranch;
        }).collect(Collectors.toSet());
    }

    public FlowRegistryBranch getDefaultBranch(FlowRegistryClientConfigurationContext context) {
        FlowRegistryBranch defaultBranch = new FlowRegistryBranch();
        defaultBranch.setName(context.getProperty(REPOSITORY_BRANCH).getValue());
        return defaultBranch;
    }

    public Set<FlowRegistryBucket> getBuckets(FlowRegistryClientConfigurationContext context, String branch) throws IOException, FlowRegistryException {
        GitRepositoryClient repositoryClient = this.getRepositoryClient(context);
        this.verifyReadPermissions(repositoryClient);
        Set<FlowRegistryBucket> buckets = repositoryClient.getTopLevelDirectoryNames(branch).stream().filter(bucketName -> !this.directoryExclusionPattern.matcher((CharSequence)bucketName).matches()).map(bucketName -> this.createFlowRegistryBucket(repositoryClient, (String)bucketName)).collect(Collectors.toSet());
        return buckets.isEmpty() ? Set.of(this.createFlowRegistryBucket(repositoryClient, DEFAULT_BUCKET_NAME)) : buckets;
    }

    public FlowRegistryBucket getBucket(FlowRegistryClientConfigurationContext context, BucketLocation bucketLocation) throws FlowRegistryException, IOException {
        GitRepositoryClient repositoryClient = this.getRepositoryClient(context);
        this.verifyReadPermissions(repositoryClient);
        return this.createFlowRegistryBucket(repositoryClient, bucketLocation.getBucketId());
    }

    public RegisteredFlow registerFlow(FlowRegistryClientConfigurationContext context, RegisteredFlow flow) throws FlowRegistryException, IOException {
        GitRepositoryClient repositoryClient = this.getRepositoryClient(context);
        this.verifyWritePermissions(repositoryClient);
        String branch = flow.getBranch();
        FlowLocation flowLocation = new FlowLocation(branch, flow.getBucketIdentifier(), flow.getIdentifier());
        String filePath = this.getSnapshotFilePath(flowLocation);
        String commitMessage = REGISTER_FLOW_MESSAGE_FORMAT.formatted(flow.getIdentifier());
        Optional<String> existingFileSha = repositoryClient.getContentSha(filePath, branch);
        if (existingFileSha.isPresent()) {
            throw new FlowAlreadyExistsException("Another flow is already registered at [" + filePath + "] on branch [" + branch + "]");
        }
        String originalBucketId = flow.getBucketIdentifier();
        flow.setBucketIdentifier(null);
        flow.setBucketName(null);
        flow.setBranch(null);
        RegisteredFlowSnapshot flowSnapshot = new RegisteredFlowSnapshot();
        flowSnapshot.setFlow(flow);
        GitCreateContentRequest request = GitCreateContentRequest.builder().branch(branch).path(filePath).content(this.flowSnapshotSerializer.serialize(flowSnapshot)).message(commitMessage).build();
        repositoryClient.createContent(request);
        flow.setBucketName(originalBucketId);
        flow.setBucketIdentifier(originalBucketId);
        flow.setBranch(branch);
        return flow;
    }

    public RegisteredFlow deregisterFlow(FlowRegistryClientConfigurationContext context, FlowLocation flowLocation) throws FlowRegistryException, IOException {
        GitRepositoryClient repositoryClient = this.getRepositoryClient(context);
        this.verifyWritePermissions(repositoryClient);
        String branch = flowLocation.getBranch();
        String filePath = this.getSnapshotFilePath(flowLocation);
        String commitMessage = DEREGISTER_FLOW_MESSAGE_FORMAT.formatted(flowLocation.getFlowId());
        try (InputStream deletedSnapshotContent = repositoryClient.deleteContent(filePath, commitMessage, branch);){
            RegisteredFlowSnapshot deletedSnapshot = this.getSnapshot(deletedSnapshotContent);
            this.populateFlowAndSnapshotMetadata(deletedSnapshot, flowLocation);
            this.updateBucketReferences(repositoryClient, deletedSnapshot, flowLocation.getBucketId());
            RegisteredFlow registeredFlow = deletedSnapshot.getFlow();
            return registeredFlow;
        }
    }

    public RegisteredFlow getFlow(FlowRegistryClientConfigurationContext context, FlowLocation flowLocation) throws FlowRegistryException, IOException {
        GitRepositoryClient repositoryClient = this.getRepositoryClient(context);
        this.verifyReadPermissions(repositoryClient);
        String branch = flowLocation.getBranch();
        String filePath = this.getSnapshotFilePath(flowLocation);
        RegisteredFlowSnapshot existingSnapshot = this.getSnapshot(repositoryClient, filePath, branch);
        this.populateFlowAndSnapshotMetadata(existingSnapshot, flowLocation);
        this.updateBucketReferences(repositoryClient, existingSnapshot, flowLocation.getBucketId());
        RegisteredFlow registeredFlow = existingSnapshot.getFlow();
        registeredFlow.setBranch(branch);
        return registeredFlow;
    }

    public Set<RegisteredFlow> getFlows(FlowRegistryClientConfigurationContext context, BucketLocation bucketLocation) throws IOException, FlowRegistryException {
        GitRepositoryClient repositoryClient = this.getRepositoryClient(context);
        this.verifyReadPermissions(repositoryClient);
        String branch = bucketLocation.getBranch();
        String bucketId = bucketLocation.getBucketId();
        return repositoryClient.getFileNames(bucketId, branch).stream().filter(filename -> filename.endsWith(SNAPSHOT_FILE_EXTENSION)).map(filename -> this.mapToRegisteredFlow(bucketLocation, (String)filename)).collect(Collectors.toSet());
    }

    public RegisteredFlowSnapshot getFlowContents(FlowRegistryClientConfigurationContext context, FlowVersionLocation flowVersionLocation) throws FlowRegistryException, IOException {
        GitRepositoryClient repositoryClient = this.getRepositoryClient(context);
        this.verifyReadPermissions(repositoryClient);
        String version = flowVersionLocation.getVersion();
        String filePath = this.getSnapshotFilePath((FlowLocation)flowVersionLocation);
        InputStream inputStream = repositoryClient.getContentFromCommit(filePath, version);
        RegisteredFlowSnapshot flowSnapshot = this.getSnapshot(inputStream);
        this.populateFlowAndSnapshotMetadata(flowSnapshot, (FlowLocation)flowVersionLocation);
        flowSnapshot.getSnapshotMetadata().setVersion(version);
        flowSnapshot.getSnapshotMetadata().setBranch(flowVersionLocation.getBranch());
        flowSnapshot.getFlow().setBranch(flowVersionLocation.getBranch());
        this.updateBucketReferences(repositoryClient, flowSnapshot, flowVersionLocation.getBucketId());
        String latestVersion = this.getLatestVersion(context, (FlowLocation)flowVersionLocation).orElse(null);
        flowSnapshot.setLatest(version.equals(latestVersion));
        return flowSnapshot;
    }

    public RegisteredFlowSnapshot registerFlowSnapshot(FlowRegistryClientConfigurationContext context, RegisteredFlowSnapshot flowSnapshot, RegisterAction action) throws FlowRegistryException, IOException {
        GitRepositoryClient repositoryClient = this.getRepositoryClient(context);
        this.verifyWritePermissions(repositoryClient);
        RegisteredFlowSnapshotMetadata snapshotMetadata = flowSnapshot.getSnapshotMetadata();
        String branch = snapshotMetadata.getBranch();
        FlowLocation flowLocation = new FlowLocation(snapshotMetadata.getBranch(), snapshotMetadata.getBucketIdentifier(), snapshotMetadata.getFlowIdentifier());
        String filePath = this.getSnapshotFilePath(flowLocation);
        String previousSha = repositoryClient.getContentSha(filePath, branch).orElse(null);
        String snapshotComments = snapshotMetadata.getComments();
        String commitMessage = StringUtils.isBlank((String)snapshotComments) ? DEFAULT_FLOW_SNAPSHOT_MESSAGE_FORMAT.formatted(flowLocation.getFlowId()) : snapshotComments;
        RegisteredFlowSnapshot existingSnapshot = this.getSnapshot(repositoryClient, filePath, branch);
        this.populateFlowAndSnapshotMetadata(existingSnapshot, flowLocation);
        RegisteredFlow existingFlow = existingSnapshot.getFlow();
        existingFlow.setBranch(null);
        flowSnapshot.setFlow(existingFlow);
        flowSnapshot.setBucket(null);
        flowSnapshot.getSnapshotMetadata().setBucketIdentifier(null);
        flowSnapshot.getSnapshotMetadata().setBranch(null);
        flowSnapshot.getSnapshotMetadata().setVersion(null);
        flowSnapshot.getSnapshotMetadata().setComments(null);
        ParameterContextValuesStrategy parameterContextValuesStrategy = (ParameterContextValuesStrategy)context.getProperty(PARAMETER_CONTEXT_VALUES).asAllowableValue(ParameterContextValuesStrategy.class);
        Map parameterContexts = flowSnapshot.getParameterContexts();
        if (parameterContexts != null) {
            Map existingParameterContexts;
            if (ParameterContextValuesStrategy.REMOVE.equals((Object)parameterContextValuesStrategy)) {
                parameterContexts.forEach((name, parameterContext) -> parameterContext.getParameters().forEach(parameter -> parameter.setValue(null)));
            } else if (ParameterContextValuesStrategy.IGNORE_CHANGES.equals((Object)parameterContextValuesStrategy) && (existingParameterContexts = existingSnapshot.getParameterContexts()) != null) {
                existingParameterContexts.forEach((name, parameterContext) -> {
                    VersionedParameterContext targetContext = (VersionedParameterContext)parameterContexts.get(name);
                    if (targetContext != null) {
                        Map targetParamMap = targetContext.getParameters().stream().collect(Collectors.toMap(VersionedParameter::getName, Function.identity()));
                        parameterContext.getParameters().forEach(parameter -> {
                            VersionedParameter targetParam = (VersionedParameter)targetParamMap.get(parameter.getName());
                            if (targetParam != null) {
                                targetParam.setValue(parameter.getValue());
                            }
                        });
                    }
                });
            }
        }
        String originalFlowContentsGroupId = this.replaceGroupId(flowSnapshot.getFlowContents(), FLOW_CONTENTS_GROUP_ID);
        Position originalFlowContentsPosition = this.replacePosition(flowSnapshot.getFlowContents(), new Position(0.0, 0.0));
        GitCreateContentRequest createContentRequest = GitCreateContentRequest.builder().branch(branch).path(filePath).content(this.flowSnapshotSerializer.serialize(flowSnapshot)).message(commitMessage).existingContentSha(previousSha).build();
        String createContentCommitSha = repositoryClient.createContent(createContentRequest);
        VersionedFlowCoordinates versionedFlowCoordinates = new VersionedFlowCoordinates();
        versionedFlowCoordinates.setRegistryId(this.getIdentifier());
        versionedFlowCoordinates.setBranch(flowLocation.getBranch());
        versionedFlowCoordinates.setBucketId(flowLocation.getBucketId());
        versionedFlowCoordinates.setFlowId(flowLocation.getFlowId());
        versionedFlowCoordinates.setVersion(createContentCommitSha);
        versionedFlowCoordinates.setStorageLocation(this.getStorageLocation(repositoryClient));
        flowSnapshot.getFlowContents().setVersionedFlowCoordinates(versionedFlowCoordinates);
        flowSnapshot.getFlow().setBranch(branch);
        flowSnapshot.getSnapshotMetadata().setBranch(branch);
        flowSnapshot.getSnapshotMetadata().setVersion(createContentCommitSha);
        flowSnapshot.setLatest(true);
        this.updateBucketReferences(repositoryClient, flowSnapshot, flowLocation.getBucketId());
        this.replaceGroupId(flowSnapshot.getFlowContents(), originalFlowContentsGroupId);
        this.replacePosition(flowSnapshot.getFlowContents(), originalFlowContentsPosition);
        return flowSnapshot;
    }

    public Set<RegisteredFlowSnapshotMetadata> getFlowVersions(FlowRegistryClientConfigurationContext context, FlowLocation flowLocation) throws FlowRegistryException, IOException {
        GitRepositoryClient repositoryClient = this.getRepositoryClient(context);
        this.verifyReadPermissions(repositoryClient);
        String branch = flowLocation.getBranch();
        String filePath = this.getSnapshotFilePath(flowLocation);
        LinkedHashSet<RegisteredFlowSnapshotMetadata> snapshotMetadataSet = new LinkedHashSet<RegisteredFlowSnapshotMetadata>();
        for (GitCommit commit : repositoryClient.getCommits(filePath, branch)) {
            RegisteredFlowSnapshotMetadata snapshotMetadata = this.createSnapshotMetadata(commit, flowLocation);
            if (snapshotMetadata.getComments() != null && snapshotMetadata.getComments().startsWith(REGISTER_FLOW_MESSAGE_PREFIX)) continue;
            snapshotMetadataSet.add(snapshotMetadata);
        }
        return snapshotMetadataSet;
    }

    public Optional<String> getLatestVersion(FlowRegistryClientConfigurationContext context, FlowLocation flowLocation) throws FlowRegistryException, IOException {
        GitRepositoryClient repositoryClient = this.getRepositoryClient(context);
        this.verifyReadPermissions(repositoryClient);
        String branch = flowLocation.getBranch();
        String filePath = this.getSnapshotFilePath(flowLocation);
        List<GitCommit> commits = repositoryClient.getCommits(filePath, branch);
        String latestVersion = commits.isEmpty() ? null : commits.getFirst().id();
        return Optional.ofNullable(latestVersion);
    }

    public String generateFlowId(String flowName) {
        return flowName.trim().replaceAll("\\s", "-").replaceAll("[^a-zA-Z0-9-]", "").replaceAll("(-)\\1+", "$1");
    }

    private FlowRegistryBucket createFlowRegistryBucket(GitRepositoryClient repositoryClient, String name) {
        FlowRegistryPermissions bucketPermissions = new FlowRegistryPermissions();
        bucketPermissions.setCanRead(repositoryClient.hasReadPermission());
        bucketPermissions.setCanWrite(repositoryClient.hasWritePermission());
        bucketPermissions.setCanDelete(repositoryClient.hasWritePermission());
        FlowRegistryBucket bucket = new FlowRegistryBucket();
        bucket.setIdentifier(name);
        bucket.setName(name);
        bucket.setPermissions(bucketPermissions);
        return bucket;
    }

    private RegisteredFlowSnapshotMetadata createSnapshotMetadata(GitCommit commit, FlowLocation flowLocation) throws IOException {
        RegisteredFlowSnapshotMetadata snapshotMetadata = new RegisteredFlowSnapshotMetadata();
        snapshotMetadata.setBranch(flowLocation.getBranch());
        snapshotMetadata.setBucketIdentifier(flowLocation.getBucketId());
        snapshotMetadata.setFlowIdentifier(flowLocation.getFlowId());
        snapshotMetadata.setVersion(commit.id());
        snapshotMetadata.setAuthor(commit.author());
        snapshotMetadata.setComments(commit.message());
        snapshotMetadata.setTimestamp(commit.commitDate().toEpochMilli());
        return snapshotMetadata;
    }

    private RegisteredFlow mapToRegisteredFlow(BucketLocation bucketLocation, String filename) {
        String branch = bucketLocation.getBranch();
        String bucketId = bucketLocation.getBucketId();
        String flowId = filename.replace(SNAPSHOT_FILE_EXTENSION, "");
        RegisteredFlow registeredFlow = new RegisteredFlow();
        registeredFlow.setIdentifier(flowId);
        registeredFlow.setName(flowId);
        registeredFlow.setBranch(branch);
        registeredFlow.setBucketIdentifier(bucketId);
        registeredFlow.setBucketName(bucketId);
        return registeredFlow;
    }

    private String getSnapshotFilePath(FlowLocation flowLocation) {
        return SNAPSHOT_FILE_PATH_FORMAT.formatted(flowLocation.getBucketId(), flowLocation.getFlowId());
    }

    private RegisteredFlowSnapshot getSnapshot(GitRepositoryClient repositoryClient, String filePath, String branch) throws IOException, FlowRegistryException {
        try (InputStream contentInputStream = repositoryClient.getContentFromBranch(filePath, branch);){
            RegisteredFlowSnapshot registeredFlowSnapshot = this.flowSnapshotSerializer.deserialize(contentInputStream);
            return registeredFlowSnapshot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegisteredFlowSnapshot getSnapshot(InputStream inputStream) throws IOException {
        try {
            RegisteredFlowSnapshot registeredFlowSnapshot = this.flowSnapshotSerializer.deserialize(inputStream);
            return registeredFlowSnapshot;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Position replacePosition(VersionedProcessGroup group, Position newPosition) {
        Position originalPosition = group.getPosition();
        group.setPosition(newPosition);
        return originalPosition;
    }

    private String replaceGroupId(VersionedProcessGroup group, String newGroupId) {
        String originalGroupId = group.getIdentifier();
        group.setIdentifier(newGroupId);
        this.replaceGroupId(group.getProcessGroups(), newGroupId);
        this.replaceGroupId(group.getRemoteProcessGroups(), newGroupId);
        this.replaceGroupId(group.getProcessors(), newGroupId);
        this.replaceGroupId(group.getFunnels(), newGroupId);
        this.replaceGroupId(group.getLabels(), newGroupId);
        this.replaceGroupId(group.getInputPorts(), newGroupId);
        this.replaceGroupId(group.getOutputPorts(), newGroupId);
        this.replaceGroupId(group.getControllerServices(), newGroupId);
        this.replaceGroupId(group.getConnections(), newGroupId);
        if (group.getConnections() != null) {
            for (VersionedConnection connection : group.getConnections()) {
                this.replaceGroupId(connection.getSource(), originalGroupId, newGroupId);
                this.replaceGroupId(connection.getDestination(), originalGroupId, newGroupId);
            }
        }
        return originalGroupId;
    }

    private <T extends VersionedComponent> void replaceGroupId(Collection<T> components, String newGroupIdentifier) {
        if (components == null) {
            return;
        }
        components.forEach(c -> c.setGroupIdentifier(newGroupIdentifier));
    }

    private void replaceGroupId(ConnectableComponent connectableComponent, String originalGroupId, String newGroupId) {
        if (connectableComponent == null) {
            return;
        }
        if (originalGroupId.equals(connectableComponent.getGroupId())) {
            connectableComponent.setGroupId(newGroupId);
        }
    }

    private void updateBucketReferences(GitRepositoryClient repositoryClient, RegisteredFlowSnapshot flowSnapshot, String bucketId) {
        FlowRegistryBucket bucket = this.createFlowRegistryBucket(repositoryClient, bucketId);
        flowSnapshot.setBucket(bucket);
        RegisteredFlow flow = flowSnapshot.getFlow();
        flow.setBucketName(bucketId);
        flow.setBucketIdentifier(bucketId);
        RegisteredFlowSnapshotMetadata snapshotMetadata = flowSnapshot.getSnapshotMetadata();
        snapshotMetadata.setBucketIdentifier(bucketId);
    }

    private void populateFlowAndSnapshotMetadata(RegisteredFlowSnapshot flowSnapshot, FlowLocation flowLocation) {
        if (flowSnapshot.getFlow() == null) {
            RegisteredFlow registeredFlow = new RegisteredFlow();
            registeredFlow.setName(flowLocation.getFlowId());
            registeredFlow.setIdentifier(flowLocation.getFlowId());
            flowSnapshot.setFlow(registeredFlow);
        }
        if (flowSnapshot.getSnapshotMetadata() == null) {
            RegisteredFlowSnapshotMetadata snapshotMetadata = new RegisteredFlowSnapshotMetadata();
            snapshotMetadata.setFlowIdentifier(flowLocation.getFlowId());
            flowSnapshot.setSnapshotMetadata(snapshotMetadata);
        }
    }

    private void verifyWritePermissions(GitRepositoryClient repositoryClient) throws AuthorizationException {
        if (!repositoryClient.hasWritePermission()) {
            throw new AuthorizationException("Client does not have write access to the repository");
        }
    }

    private void verifyReadPermissions(GitRepositoryClient repositoryClient) throws AuthorizationException {
        if (!repositoryClient.hasReadPermission()) {
            throw new AuthorizationException("Client does not have read access to the repository");
        }
    }

    protected synchronized GitRepositoryClient getRepositoryClient(FlowRegistryClientConfigurationContext context) throws IOException, FlowRegistryException {
        if (!this.clientInitialized.get()) {
            this.getLogger().info("Initializing repository client");
            this.repositoryClient = this.createRepositoryClient(context);
            this.initializeDefaultBucket(context);
            this.directoryExclusionPattern = Pattern.compile(context.getProperty(DIRECTORY_FILTER_EXCLUDE).getValue());
            this.clientInitialized.set(true);
        }
        return this.repositoryClient;
    }

    protected void invalidateClient() {
        this.clientInitialized.set(false);
        if (this.repositoryClient != null) {
            try {
                this.repositoryClient.close();
            }
            catch (Exception e) {
                this.getLogger().warn("Error closing repository client", (Throwable)e);
            }
        }
        this.repositoryClient = null;
    }

    private void initializeDefaultBucket(FlowRegistryClientConfigurationContext context) throws IOException, FlowRegistryException {
        if (!this.repositoryClient.hasWritePermission()) {
            this.getLogger().info("Repository client [{}] does not have write permissions to the repository, skipping setup of default bucket", new Object[]{this.getIdentifier()});
            return;
        }
        String branch = context.getProperty(REPOSITORY_BRANCH).getValue();
        Set<String> bucketDirectoryNames = this.repositoryClient.getTopLevelDirectoryNames(branch);
        if (!bucketDirectoryNames.isEmpty()) {
            this.getLogger().debug("Found {} existing buckets, skipping setup of default bucket", new Object[]{bucketDirectoryNames.size()});
            return;
        }
        String storageLocation = this.getStorageLocation(this.repositoryClient);
        this.getLogger().info("Creating default bucket in repo [{}] on branch [{}]", new Object[]{storageLocation, branch});
        this.repositoryClient.createContent(GitCreateContentRequest.builder().branch(branch).path(DEFAULT_BUCKET_KEEP_FILE_PATH).content(DEFAULT_BUCKET_KEEP_FILE_CONTENT).message(DEFAULT_BUCKET_KEEP_FILE_MESSAGE).build());
    }

    protected abstract List<PropertyDescriptor> createPropertyDescriptors();

    protected abstract String getStorageLocation(GitRepositoryClient var1);

    protected abstract GitRepositoryClient createRepositoryClient(FlowRegistryClientConfigurationContext var1) throws IOException, FlowRegistryException;

    protected FlowSnapshotSerializer createFlowSnapshotSerializer() {
        return new JacksonFlowSnapshotSerializer();
    }

    static enum ParameterContextValuesStrategy implements DescribedValue
    {
        RETAIN("Retain", "Retain Values in Parameter Contexts without modifications"),
        REMOVE("Remove", "Remove Values from Parameter Context"),
        IGNORE_CHANGES("Ignore Changes", "Ignore any change on existing parameters");

        private final String displayName;
        private final String description;

        private ParameterContextValuesStrategy(String displayName, String description) {
            this.displayName = displayName;
            this.description = description;
        }

        public String getValue() {
            return this.name();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

