/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.git.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.registry.flow.FlowRegistryException;
import org.apache.nifi.registry.flow.git.client.GitCommit;
import org.apache.nifi.registry.flow.git.client.GitCreateContentRequest;

public interface GitRepositoryClient {
    public boolean hasReadPermission();

    public boolean hasWritePermission();

    public Set<String> getBranches() throws IOException, FlowRegistryException;

    public Set<String> getTopLevelDirectoryNames(String var1) throws IOException, FlowRegistryException;

    public Set<String> getFileNames(String var1, String var2) throws IOException, FlowRegistryException;

    public List<GitCommit> getCommits(String var1, String var2) throws IOException, FlowRegistryException;

    public InputStream getContentFromBranch(String var1, String var2) throws IOException, FlowRegistryException;

    public InputStream getContentFromCommit(String var1, String var2) throws IOException, FlowRegistryException;

    public Optional<String> getContentSha(String var1, String var2) throws IOException, FlowRegistryException;

    public String createContent(GitCreateContentRequest var1) throws IOException, FlowRegistryException;

    public InputStream deleteContent(String var1, String var2, String var3) throws FlowRegistryException, IOException;

    default public void close() throws IOException {
    }
}

