/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.git.serialize;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.nifi.flow.ConnectableComponent;
import org.apache.nifi.flow.VersionedComponent;

public class VersionedComponentModule
extends SimpleModule {
    private static final Set<String> EXCLUDE_JSON_FIELDS = Set.of("instanceIdentifier", "instanceGroupId");

    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        context.addBeanSerializerModifier((BeanSerializerModifier)new VersionedComponentBeanSerializerModifier());
    }

    private static class VersionedComponentBeanSerializerModifier
    extends BeanSerializerModifier {
        private VersionedComponentBeanSerializerModifier() {
        }

        public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
            if (!VersionedComponent.class.isAssignableFrom(beanDesc.getBeanClass()) && !ConnectableComponent.class.isAssignableFrom(beanDesc.getBeanClass())) {
                return super.changeProperties(config, beanDesc, beanProperties);
            }
            ArrayList<BeanPropertyWriter> includedProperties = new ArrayList<BeanPropertyWriter>();
            for (BeanPropertyWriter property : beanProperties) {
                if (EXCLUDE_JSON_FIELDS.contains(property.getName())) continue;
                includedProperties.add(property);
            }
            return includedProperties;
        }
    }
}

