/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.vision;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest;
import java.util.List;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.gcp.util.GoogleUtils;
import org.apache.nifi.processors.gcp.vision.AbstractStartGcpVisionOperation;
import org.apache.nifi.processors.gcp.vision.GetGcpVisionAnnotateImagesOperationStatus;

@Tags(value={"Google", "Cloud", "Machine Learning", "Vision"})
@CapabilityDescription(value="Trigger a Vision operation on image input. It should be followed by GetGcpVisionAnnotateImagesOperationStatus processor in order to monitor operation status.")
@SeeAlso(value={GetGcpVisionAnnotateImagesOperationStatus.class})
@WritesAttributes(value={@WritesAttribute(attribute="operationKey", description="A unique identifier of the operation returned by the Vision server.")})
public class StartGcpVisionAnnotateImagesOperation
extends AbstractStartGcpVisionOperation<AsyncBatchAnnotateImagesRequest.Builder> {
    static final PropertyDescriptor JSON_PAYLOAD = new PropertyDescriptor.Builder().name("JSON Payload").description("JSON request for AWS Machine Learning services. The Processor will use FlowFile content for the request when this property is not specified.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("{\n    \"requests\": [{\n        \"image\": {\n            \"source\": {\n                \"imageUri\": \"gs://${gcs.bucket}/${filename}\"\n            }\n        },\n        \"features\": [{\n            \"type\": \"${vision-feature-type}\",\n            \"maxResults\": 4\n        }]\n    }],\n    \"outputConfig\": {\n        \"gcsDestination\": {\n            \"uri\": \"gs://${output-bucket}/${filename}/\"\n        },\n        \"batchSize\": 2\n    }\n}").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(JSON_PAYLOAD, GoogleUtils.GCP_CREDENTIALS_PROVIDER_SERVICE, OUTPUT_BUCKET, FEATURE_TYPE);

    @Override
    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        config.renameProperty("json-payload", JSON_PAYLOAD.getName());
    }

    @Override
    AsyncBatchAnnotateImagesRequest.Builder newBuilder() {
        return AsyncBatchAnnotateImagesRequest.newBuilder();
    }

    @Override
    OperationFuture<?, ?> startOperation(AsyncBatchAnnotateImagesRequest.Builder builder) {
        return this.getVisionClient().asyncBatchAnnotateImagesAsync(builder.build());
    }

    @Override
    PropertyDescriptor getJsonPayloadPropertyDescriptor() {
        return JSON_PAYLOAD;
    }
}

