/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.pubsub;

import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.cloud.pubsub.v1.stub.PublisherStubSettings;
import io.grpc.HttpConnectProxiedSocketAddress;
import io.grpc.ProxiedSocketAddress;
import io.grpc.ProxyDetector;
import jakarta.annotation.Nullable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.VerifiableProcessor;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.gcp.AbstractGCPProcessor;
import org.apache.nifi.proxy.ProxyConfiguration;

public abstract class AbstractGCPubSubProcessor
extends AbstractGCPProcessor
implements VerifiableProcessor {
    public static final PropertyDescriptor BATCH_SIZE_THRESHOLD = new PropertyDescriptor.Builder().name("Batch Size Threshold").description("Indicates the number of messages the cloud service should bundle together in a batch. If not set and left empty, only one message will be used in a batch").required(true).defaultValue("15").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor BATCH_BYTES_THRESHOLD = new PropertyDescriptor.Builder().name("Batch Bytes Threshold").description("Publish request gets triggered based on this Batch Bytes Threshold property and the " + BATCH_SIZE_THRESHOLD.getDisplayName() + " property, whichever condition is met first.").required(true).defaultValue("3 MB").expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();
    public static final PropertyDescriptor BATCH_DELAY_THRESHOLD = new PropertyDescriptor.Builder().name("Batch Delay Threshold").description("Indicates the delay threshold to use for batching. After this amount of time has elapsed (counting from the first element added), the elements will be wrapped up in a batch and sent. This value should not be set too high, usually on the order of milliseconds. Otherwise, calls might appear to never complete.").required(true).defaultValue("100 millis").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor API_ENDPOINT = new PropertyDescriptor.Builder().name("API Endpoint").description("Override the gRPC endpoint in the form of [host:port]").addValidator(StandardValidators.HOSTNAME_PORT_LIST_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).required(true).defaultValue(PublisherStubSettings.getDefaultEndpoint()).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles are routed to this relationship after a successful Google Cloud Pub/Sub operation.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles are routed to this relationship if the Google Cloud Pub/Sub operation fails.").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE);

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @Override
    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        config.renameProperty("gcp-pubsub-publish-batch-size", BATCH_SIZE_THRESHOLD.getName());
        config.renameProperty("gcp-batch-bytes", BATCH_BYTES_THRESHOLD.getName());
        config.renameProperty("gcp-pubsub-publish-batch-delay", BATCH_DELAY_THRESHOLD.getName());
        config.renameProperty("api-endpoint", API_ENDPOINT.getName());
    }

    protected ServiceOptions getServiceOptions(ProcessContext context, GoogleCredentials credentials) {
        return null;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        HashSet<ValidationResult> results = new HashSet<ValidationResult>(super.customValidate(validationContext));
        boolean projectId = validationContext.getProperty(PROJECT_ID).isSet();
        if (!projectId) {
            results.add(new ValidationResult.Builder().subject(PROJECT_ID.getName()).valid(false).explanation("The Project ID must be set for this processor.").build());
        }
        return results;
    }

    @Override
    protected GoogleCredentials getGoogleCredentials(ProcessContext context) {
        return super.getGoogleCredentials(context).createScoped(new String[]{"https://www.googleapis.com/auth/pubsub"});
    }

    protected TransportChannelProvider getTransportChannelProvider(ProcessContext context) {
        final ProxyConfiguration proxyConfiguration = ProxyConfiguration.getConfiguration((PropertyContext)context);
        return TopicAdminSettings.defaultGrpcTransportProviderBuilder().setChannelConfigurator(managedChannelBuilder -> managedChannelBuilder.proxyDetector(new ProxyDetector(){

            @Nullable
            public ProxiedSocketAddress proxyFor(SocketAddress socketAddress) {
                if (Proxy.Type.HTTP.equals((Object)proxyConfiguration.getProxyType())) {
                    return HttpConnectProxiedSocketAddress.newBuilder().setUsername(proxyConfiguration.getProxyUserName()).setPassword(proxyConfiguration.getProxyUserPassword()).setProxyAddress((SocketAddress)new InetSocketAddress(proxyConfiguration.getProxyServerHost(), (int)proxyConfiguration.getProxyServerPort())).setTargetAddress((InetSocketAddress)socketAddress).build();
                }
                return null;
            }
        })).build();
    }
}

