/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.credentials.factory.strategies;

import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.IdentityPoolCredentials;
import com.google.auth.oauth2.IdentityPoolSubjectTokenSupplier;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.oauth2.AccessToken;
import org.apache.nifi.oauth2.OAuth2AccessTokenProvider;
import org.apache.nifi.processors.gcp.credentials.factory.CredentialPropertyDescriptors;
import org.apache.nifi.processors.gcp.credentials.factory.strategies.AbstractCredentialsStrategy;

public class WorkloadIdentityFederationCredentialsStrategy
extends AbstractCredentialsStrategy {
    private static final String ERROR_NO_SUBJECT_TOKEN = "Subject token provider returned no usable token";
    private static final String SUBJECT_TOKEN_PARAMETER_ID_TOKEN = "id_token";
    private static final String SUBJECT_TOKEN_PARAMETER_ACCESS_TOKEN = "access_token";

    public WorkloadIdentityFederationCredentialsStrategy() {
        super("Workload Identity Federation");
    }

    @Override
    public GoogleCredentials getGoogleCredentials(Map<PropertyDescriptor, String> properties, HttpTransportFactory transportFactory) {
        throw new UnsupportedOperationException("Workload Identity Federation requires the controller service configuration context");
    }

    @Override
    public GoogleCredentials getGoogleCredentials(ConfigurationContext context, HttpTransportFactory transportFactory) throws IOException {
        OAuth2AccessTokenProvider subjectTokenProvider = (OAuth2AccessTokenProvider)context.getProperty(CredentialPropertyDescriptors.WORKLOAD_IDENTITY_SUBJECT_TOKEN_PROVIDER).asControllerService(OAuth2AccessTokenProvider.class);
        String audience = context.getProperty(CredentialPropertyDescriptors.WORKLOAD_IDENTITY_AUDIENCE).getValue();
        String scopeValue = context.getProperty(CredentialPropertyDescriptors.WORKLOAD_IDENTITY_SCOPE).getValue();
        String tokenEndpoint = context.getProperty(CredentialPropertyDescriptors.WORKLOAD_IDENTITY_TOKEN_ENDPOINT).getValue();
        String subjectTokenType = context.getProperty(CredentialPropertyDescriptors.WORKLOAD_IDENTITY_SUBJECT_TOKEN_TYPE).getValue();
        List<String> scopes = WorkloadIdentityFederationCredentialsStrategy.parseScopes(scopeValue);
        IdentityPoolSubjectTokenSupplier tokenSupplier = this.createSubjectTokenSupplier(subjectTokenProvider);
        IdentityPoolCredentials.Builder builder = IdentityPoolCredentials.newBuilder().setAudience(audience).setTokenUrl(tokenEndpoint).setSubjectTokenType(subjectTokenType).setSubjectTokenSupplier(tokenSupplier);
        if (!scopes.isEmpty()) {
            builder.setScopes(scopes);
        }
        if (transportFactory != null) {
            builder.setHttpTransportFactory(transportFactory);
        }
        return builder.build();
    }

    private IdentityPoolSubjectTokenSupplier createSubjectTokenSupplier(OAuth2AccessTokenProvider tokenProvider) {
        return (IdentityPoolSubjectTokenSupplier & Serializable)context -> this.getSubjectToken(tokenProvider);
    }

    private String getSubjectToken(OAuth2AccessTokenProvider tokenProvider) throws IOException {
        AccessToken subjectToken = tokenProvider.getAccessDetails();
        String subjectTokenValue = this.extractTokenValue(subjectToken);
        if (StringUtils.isBlank((CharSequence)subjectTokenValue)) {
            throw new IOException(ERROR_NO_SUBJECT_TOKEN);
        }
        return subjectTokenValue;
    }

    private String extractTokenValue(AccessToken subjectToken) {
        String accessTokenValue;
        if (subjectToken == null) {
            return null;
        }
        Map additionalParameters = subjectToken.getAdditionalParameters();
        if (additionalParameters != null) {
            Object idToken = additionalParameters.get(SUBJECT_TOKEN_PARAMETER_ID_TOKEN);
            if (idToken instanceof String && StringUtils.isNotBlank((CharSequence)((String)idToken))) {
                return (String)idToken;
            }
            Object accessToken = additionalParameters.get(SUBJECT_TOKEN_PARAMETER_ACCESS_TOKEN);
            if (accessToken instanceof String && StringUtils.isNotBlank((CharSequence)((String)accessToken))) {
                return (String)accessToken;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(accessTokenValue = subjectToken.getAccessToken()))) {
            return accessTokenValue;
        }
        return null;
    }

    private static List<String> parseScopes(String scopeValue) {
        if (StringUtils.isBlank((CharSequence)scopeValue)) {
            return Collections.emptyList();
        }
        return Arrays.stream(scopeValue.split("[\\s,]+")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }
}

