/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.leader.election;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.leader.election.LeaderElectionManager;
import org.apache.nifi.controller.leader.election.LeaderElectionStateChangeListener;
import org.apache.nifi.util.timebuffer.CountSumMinMaxAccess;
import org.apache.nifi.util.timebuffer.EntityAccess;
import org.apache.nifi.util.timebuffer.LongEntityAccess;
import org.apache.nifi.util.timebuffer.TimedBuffer;
import org.apache.nifi.util.timebuffer.TimestampedLong;
import org.apache.nifi.util.timebuffer.TimestampedLongAggregation;

public abstract class TrackedLeaderElectionManager
implements LeaderElectionManager {
    private final ConcurrentMap<String, TimedBuffer<TimestampedLong>> leaderChanges = new ConcurrentHashMap<String, TimedBuffer<TimestampedLong>>();
    private final TimedBuffer<TimestampedLongAggregation> pollTimes = new TimedBuffer(TimeUnit.SECONDS, 300, (EntityAccess)new CountSumMinMaxAccess());

    public void register(String roleName, LeaderElectionStateChangeListener listener) {
        this.register(roleName, listener, null);
    }

    public Map<String, Integer> getLeadershipChangeCount(long duration, TimeUnit unit) {
        LinkedHashMap<String, Integer> leadershipChangesPerRole = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : this.leaderChanges.entrySet()) {
            String roleName = (String)entry.getKey();
            TimedBuffer buffer = (TimedBuffer)entry.getValue();
            TimestampedLong aggregateValue = (TimestampedLong)buffer.getAggregateValue(System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(duration, unit));
            int leadershipChanges = aggregateValue == null ? 0 : aggregateValue.getValue().intValue();
            leadershipChangesPerRole.put(roleName, leadershipChanges);
        }
        return leadershipChangesPerRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAveragePollTime(TimeUnit timeUnit) {
        long averageNanos;
        TimedBuffer<TimestampedLongAggregation> timedBuffer = this.pollTimes;
        synchronized (timedBuffer) {
            TimestampedLongAggregation.TimestampedAggregation aggregation = ((TimestampedLongAggregation)this.pollTimes.getAggregateValue(0L)).getAggregation();
            if (aggregation == null || aggregation.getCount() == 0L) {
                return 0L;
            }
            averageNanos = aggregation.getSum() / aggregation.getCount();
        }
        return timeUnit.convert(averageNanos, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMinPollTime(TimeUnit timeUnit) {
        long minNanos;
        TimedBuffer<TimestampedLongAggregation> timedBuffer = this.pollTimes;
        synchronized (timedBuffer) {
            TimestampedLongAggregation.TimestampedAggregation aggregation = ((TimestampedLongAggregation)this.pollTimes.getAggregateValue(0L)).getAggregation();
            if (aggregation == null) {
                return 0L;
            }
            minNanos = aggregation.getMin();
        }
        return timeUnit.convert(minNanos, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxPollTime(TimeUnit timeUnit) {
        long maxNanos;
        TimedBuffer<TimestampedLongAggregation> timedBuffer = this.pollTimes;
        synchronized (timedBuffer) {
            TimestampedLongAggregation.TimestampedAggregation aggregation = ((TimestampedLongAggregation)this.pollTimes.getAggregateValue(0L)).getAggregation();
            if (aggregation == null) {
                return 0L;
            }
            maxNanos = aggregation.getMax();
        }
        return timeUnit.convert(maxNanos, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPollCount() {
        TimedBuffer<TimestampedLongAggregation> timedBuffer = this.pollTimes;
        synchronized (timedBuffer) {
            TimestampedLongAggregation.TimestampedAggregation aggregation = ((TimestampedLongAggregation)this.pollTimes.getAggregateValue(0L)).getAggregation();
            if (aggregation == null) {
                return 0L;
            }
            return aggregation.getCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerPollTime(long nanos) {
        TimedBuffer<TimestampedLongAggregation> timedBuffer = this.pollTimes;
        synchronized (timedBuffer) {
            this.pollTimes.add((Object)TimestampedLongAggregation.newValue((long)nanos));
        }
    }

    protected void onLeaderChanged(String roleName) {
        TimedBuffer buffer = this.leaderChanges.computeIfAbsent(roleName, key -> new TimedBuffer(TimeUnit.HOURS, 24, (EntityAccess)new LongEntityAccess()));
        buffer.add((Object)new TimestampedLong(Long.valueOf(1L)));
    }

    protected boolean isParticipating(String participantId) {
        return participantId != null && !participantId.isBlank();
    }
}

