/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kubernetes.state.provider;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.components.state.StateMap;

class StandardStateMap
implements StateMap {
    private final Map<String, String> data;
    private final Optional<String> version;
    private final Optional<ObjectMeta> configMapMetadata;

    StandardStateMap(Map<String, String> data, Optional<String> version, Optional<ObjectMeta> configMapMetadata) {
        this.data = Collections.unmodifiableMap(data == null ? Collections.emptyMap() : data);
        this.version = version;
        this.configMapMetadata = configMapMetadata;
    }

    public Optional<String> getStateVersion() {
        return this.version;
    }

    public String get(String key) {
        return this.data.get(key);
    }

    public Map<String, String> toMap() {
        return this.data;
    }

    public Optional<ObjectMeta> getConfigMapMetadata() {
        return this.configMapMetadata;
    }
}

