/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow.resource;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.net.ssl.SSLContext;
import org.apache.nifi.flow.resource.ExternalResourceDescriptor;
import org.apache.nifi.flow.resource.ExternalResourceProviderInitializationContext;
import org.apache.nifi.util.NiFiProperties;

public final class PropertyBasedExternalResourceProviderInitializationContext
implements ExternalResourceProviderInitializationContext {
    private static Set<String> GUARDED_PROPERTIES = Set.of("implementation");
    private final Map<String, String> properties;
    private final Predicate<ExternalResourceDescriptor> filter;
    private final SSLContext sslContext;

    public PropertyBasedExternalResourceProviderInitializationContext(SSLContext sslContext, NiFiProperties properties, String prefix, Predicate<ExternalResourceDescriptor> filter) {
        this.properties = this.extractProperties(properties, prefix);
        this.filter = filter;
        this.sslContext = sslContext;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Predicate<ExternalResourceDescriptor> getFilter() {
        return this.filter;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    private Map<String, String> extractProperties(NiFiProperties properties, String prefix) {
        Map candidates = properties.getPropertiesWithPrefix(prefix);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : candidates.entrySet()) {
            String parameterKey = ((String)entry.getKey()).substring(prefix.length());
            if (parameterKey.isEmpty() || GUARDED_PROPERTIES.contains(parameterKey)) continue;
            result.put(parameterKey, (String)entry.getValue());
        }
        return result;
    }
}

