/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ParameterContextNameUtils {
    private static final String PATTERN_GROUP_NAME = "name";
    private static final String PATTERN_GROUP_INDEX = "index";
    private static final String LINEAGE_FORMAT = "^(?<name>.+?)( \\((?<index>[0-9]+)\\))?$";
    private static final Pattern LINEAGE_PATTERN = Pattern.compile("^(?<name>.+?)( \\((?<index>[0-9]+)\\))?$");
    public static final String NAME_FORMAT = "%s (%d)";

    private ParameterContextNameUtils() {
    }

    public static boolean isNameWithSuffix(String contextName, String baseName) {
        if (contextName == null || baseName == null) {
            return false;
        }
        Matcher matcher = LINEAGE_PATTERN.matcher(contextName);
        if (!matcher.matches()) {
            return false;
        }
        String extractedBaseName = matcher.group(PATTERN_GROUP_NAME);
        String indexGroup = matcher.group(PATTERN_GROUP_INDEX);
        return indexGroup != null && baseName.equals(extractedBaseName);
    }

    public static String extractBaseName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter context name cannot be null");
        }
        Matcher matcher = LINEAGE_PATTERN.matcher(name);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Parameter context name \"" + name + "\" cannot be parsed");
        }
        return matcher.group(PATTERN_GROUP_NAME);
    }

    public static int extractSuffixIndex(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter context name cannot be null");
        }
        Matcher matcher = LINEAGE_PATTERN.matcher(name);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Parameter context name \"" + name + "\" cannot be parsed");
        }
        String indexGroup = matcher.group(PATTERN_GROUP_INDEX);
        return indexGroup == null ? -1 : Integer.parseInt(indexGroup);
    }

    public static String createNameWithSuffix(String baseName, int index) {
        return String.format(NAME_FORMAT, baseName, index);
    }

    public static Pattern getLineagePattern() {
        return LINEAGE_PATTERN;
    }
}

