/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.migration;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.flow.ExecutionEngine;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.migration.ControllerServiceCreationDetails;
import org.apache.nifi.migration.ControllerServiceFactory;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarClassLoadersHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardControllerServiceFactory
implements ControllerServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(StandardControllerServiceFactory.class);
    private final ExtensionManager extensionManager;
    private final FlowManager flowManager;
    private final ControllerServiceProvider serviceProvider;
    private final ComponentNode creator;

    public StandardControllerServiceFactory(ExtensionManager extensionManager, FlowManager flowManager, ControllerServiceProvider serviceProvider, ComponentNode creator) {
        this.extensionManager = extensionManager;
        this.flowManager = flowManager;
        this.serviceProvider = serviceProvider;
        this.creator = creator;
    }

    public ControllerServiceCreationDetails getCreationDetails(String implementationClassName, Map<String, String> propertyValues) {
        String serviceId = this.determineServiceId(implementationClassName, propertyValues);
        ControllerServiceNode existingNode = this.flowManager.getControllerServiceNode(serviceId);
        if (existingNode != null) {
            Class serviceClass = existingNode.getControllerServiceImplementation().getClass();
            if (this.isImplementation(serviceClass, implementationClassName)) {
                logger.debug("Found existing Controller Service with ID {} for implementation {}", (Object)serviceId, (Object)implementationClassName);
                return this.alreadyExists(existingNode, implementationClassName);
            }
            throw new IllegalArgumentException(String.format("Determined from provided implementation classname, Process Group of creator,and provided property values that the Controller Service to create should have an ID of %s. However,there already exists a Controller Service with that ID (%s) and it is not of the correct type: %s", serviceId, existingNode, implementationClassName));
        }
        Bundle bundle = this.determineBundle(implementationClassName);
        return this.toBeCreated(serviceId, implementationClassName, bundle.getBundleDetails().getCoordinate(), propertyValues);
    }

    public ControllerServiceNode create(ControllerServiceCreationDetails creationDetails) {
        ValidationStatus validationStatus;
        ControllerServiceNode serviceNode = this.flowManager.createControllerService(creationDetails.type(), creationDetails.serviceIdentifier(), creationDetails.serviceBundleCoordinate(), Collections.emptySet(), true, true, null);
        Optional group = this.creator.getParentProcessGroup();
        if (group.isPresent()) {
            ((ProcessGroup)group.get()).addControllerService(serviceNode);
            logger.info("Created {} in {} as a step in the migration of {}", new Object[]{serviceNode, group, this.creator});
        } else {
            this.flowManager.addRootControllerService(serviceNode);
            logger.info("Created {} as a Controller-Level Controller Service as a step in the migration of {}", (Object)serviceNode, (Object)this.creator);
        }
        serviceNode.setProperties(creationDetails.serviceProperties());
        StandardControllerServiceFactory serviceFactory = new StandardControllerServiceFactory(this.extensionManager, this.flowManager, this.serviceProvider, (ComponentNode)serviceNode);
        serviceNode.migrateConfiguration(creationDetails.serviceProperties(), (ControllerServiceFactory)serviceFactory);
        if (this.isEnable() && (validationStatus = serviceNode.performValidation()) == ValidationStatus.VALID) {
            this.serviceProvider.enableControllerService(serviceNode);
            logger.info("Enabled newly created Controller Service {}", (Object)serviceNode);
        }
        return serviceNode;
    }

    private boolean isEnable() {
        ExecutionEngine executionEngine;
        Optional optionalGroup = this.creator.getParentProcessGroup();
        if (optionalGroup.isPresent() && (executionEngine = ((ProcessGroup)optionalGroup.get()).resolveExecutionEngine()) == ExecutionEngine.STATELESS) {
            logger.debug("Will not enable newly created Controller Services because parent group {} is stateless", optionalGroup.get());
            return false;
        }
        return true;
    }

    private ControllerServiceCreationDetails toBeCreated(String serviceId, String type, BundleCoordinate bundleCoordinate, Map<String, String> propertyValues) {
        return new ControllerServiceCreationDetails(serviceId, type, bundleCoordinate, propertyValues, ControllerServiceCreationDetails.CreationState.SERVICE_TO_BE_CREATED);
    }

    private ControllerServiceCreationDetails alreadyExists(ControllerServiceNode serviceNode, String type) {
        HashMap propertyValues = new HashMap();
        serviceNode.getRawPropertyValues().forEach((key, value) -> propertyValues.put(key.getName(), value));
        return new ControllerServiceCreationDetails(serviceNode.getIdentifier(), type, serviceNode.getBundleCoordinate(), propertyValues, ControllerServiceCreationDetails.CreationState.SERVICE_ALREADY_EXISTS);
    }

    private boolean isImplementation(Class<?> clazz, String className) {
        if (className.equals(clazz.getName())) {
            return true;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (Object.class.equals(superClass)) {
            return false;
        }
        return this.isImplementation(superClass, className);
    }

    protected String determineServiceId(String className, Map<String, String> propertyValues) {
        TreeMap<String, String> sortedProperties = new TreeMap<String, String>(propertyValues);
        String componentDescription = this.creator.getProcessGroupIdentifier() + className + String.valueOf(sortedProperties);
        String serviceId = UUID.nameUUIDFromBytes(componentDescription.getBytes(StandardCharsets.UTF_8)).toString();
        logger.debug("For Controller Service of type {} created from {} will use UUID {}", new Object[]{className, this.creator, serviceId});
        return serviceId;
    }

    private Bundle determineBundle(String implementationClassName) {
        logger.debug("Determining which Bundle should be used to create Controller Service of type {} for {}", (Object)implementationClassName, (Object)this.creator);
        List availableBundles = this.extensionManager.getBundles(implementationClassName);
        if (availableBundles.isEmpty()) {
            throw new IllegalArgumentException("Cannot create Controller Service because the implementation Class [%s] is not a known Controller Service".formatted(implementationClassName));
        }
        if (availableBundles.size() == 1) {
            logger.debug("Found exactly 1 Bundle for Controller Service of type {}: {}", (Object)implementationClassName, availableBundles.get(0));
            return (Bundle)availableBundles.get(0);
        }
        logger.debug("There are {} available Bundles for Controller Service of type {}", (Object)availableBundles.size(), (Object)implementationClassName);
        Optional<Bundle> sameBundleMatch = availableBundles.stream().filter(bundle -> bundle.getBundleDetails().getCoordinate().equals((Object)this.creator.getBundleCoordinate())).findFirst();
        if (sameBundleMatch.isPresent()) {
            logger.debug("Found one Bundle that contains the Controller Service implementation {} that also contains the creator ({}). Will use it: {}", new Object[]{implementationClassName, this.creator, sameBundleMatch.get()});
            return sameBundleMatch.get();
        }
        List<Bundle> sameVersionBundleMatch = availableBundles.stream().filter(bundle -> bundle.getBundleDetails().getCoordinate().getVersion().equals(this.creator.getBundleCoordinate().getVersion())).toList();
        if (sameVersionBundleMatch.size() == 1) {
            logger.debug("Found one Bundle that contains the Controller Service implementation {} that also contains the same version as the creator ({}). Will use it: {}", new Object[]{implementationClassName, this.creator, sameVersionBundleMatch.get(0)});
            return sameVersionBundleMatch.get(0);
        }
        Bundle frameworkBundle = this.getFrameworkBundle();
        String frameworkVersion = frameworkBundle.getBundleDetails().getCoordinate().getVersion();
        Optional<Bundle> sameVersionAsFrameworkMatch = availableBundles.stream().filter(bundle -> bundle.getBundleDetails().getCoordinate().getVersion().equals(frameworkVersion)).findFirst();
        if (sameVersionAsFrameworkMatch.isPresent()) {
            logger.debug("Found one Bundle that contains the Controller Service implementation {} that also contains the same version as the NiFi Framework. Will use it: {}", (Object)implementationClassName, (Object)sameVersionAsFrameworkMatch.get());
            return sameVersionAsFrameworkMatch.get();
        }
        logger.debug("Could not find a suitable Bundle for creating Controller Service implementation {} from creator {}", (Object)implementationClassName, (Object)this.creator);
        throw new IllegalArgumentException(String.format("There are %s versions of the %s Controller Service, but the appropriate version could not be resolved from extension %s that is attempting to create the Controller Service", availableBundles.size(), implementationClassName, this.creator));
    }

    protected Bundle getFrameworkBundle() {
        return NarClassLoadersHolder.getInstance().getFrameworkBundle();
    }
}

