/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.groups;

import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.flow.ExecutionEngine;
import org.apache.nifi.groups.AbstractComponentScheduler;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.registry.flow.mapping.VersionedComponentStateLookup;
import org.apache.nifi.remote.RemoteGroupPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultComponentScheduler
extends AbstractComponentScheduler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultComponentScheduler.class);

    public DefaultComponentScheduler(ControllerServiceProvider controllerServiceProvider, VersionedComponentStateLookup stateLookup) {
        super(controllerServiceProvider, stateLookup);
    }

    protected void startNow(Connectable component) {
        if (ExecutionEngine.STATELESS == component.getProcessGroup().resolveExecutionEngine()) {
            logger.info("{} should be running but will not start it because its Process Group is configured to run Stateless", (Object)component);
            return;
        }
        switch (component.getConnectableType()) {
            case PROCESSOR: {
                ProcessorNode processorNode = (ProcessorNode)component;
                processorNode.getProcessGroup().startProcessor(processorNode, false);
                break;
            }
            case INPUT_PORT: {
                Port port = (Port)component;
                port.getProcessGroup().startInputPort(port);
                break;
            }
            case OUTPUT_PORT: {
                Port port = (Port)component;
                port.getProcessGroup().startOutputPort(port);
                break;
            }
            case REMOTE_INPUT_PORT: 
            case REMOTE_OUTPUT_PORT: {
                RemoteGroupPort port = (RemoteGroupPort)component;
                port.getRemoteProcessGroup().startTransmitting(port);
            }
        }
    }

    protected void startNow(ReportingTaskNode reportingTask) {
        reportingTask.start();
    }

    protected void startNow(ProcessGroup statelessGroup) {
        statelessGroup.startProcessing();
    }
}

