/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardPropertyValue;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.resource.ResourceContext;
import org.apache.nifi.components.resource.ResourceReferenceFactory;
import org.apache.nifi.components.resource.StandardResourceContext;
import org.apache.nifi.components.resource.StandardResourceReferenceFactory;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.parameter.ParameterLookup;

public class StandardPropertyContext
implements PropertyContext {
    private final Map<PropertyDescriptor, PreparedQuery> preparedQueries;
    private final Map<PropertyDescriptor, String> properties;
    private final ConfigurableComponent component;
    private final ControllerServiceLookup controllerServiceLookup;

    public StandardPropertyContext(Map<PropertyDescriptor, String> effectivePropertyValues, ConfigurableComponent component, ControllerServiceLookup controllerServiceLookup) {
        this.properties = effectivePropertyValues;
        this.controllerServiceLookup = controllerServiceLookup;
        this.preparedQueries = new HashMap<PropertyDescriptor, PreparedQuery>();
        this.component = component;
        for (Map.Entry<PropertyDescriptor, String> entry : this.properties.entrySet()) {
            PropertyDescriptor desc = entry.getKey();
            String value = entry.getValue();
            if (value == null) {
                value = desc.getDefaultValue();
            }
            PreparedQuery pq = Query.prepareWithParametersPreEvaluated((String)value);
            this.preparedQueries.put(desc, pq);
        }
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        String configuredValue = this.properties.get(property);
        PropertyDescriptor resolvedDescriptor = this.component.getPropertyDescriptor(property.getName());
        String resolvedValue = configuredValue == null ? resolvedDescriptor.getDefaultValue() : configuredValue;
        StandardResourceContext resourceContext = new StandardResourceContext((ResourceReferenceFactory)new StandardResourceReferenceFactory(), property);
        return new StandardPropertyValue((ResourceContext)resourceContext, resolvedValue, this.controllerServiceLookup, ParameterLookup.EMPTY, this.preparedQueries.get(property));
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.properties.entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }
}

