/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.scheduling;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.nifi.controller.scheduling.LifecycleState;
import org.apache.nifi.controller.scheduling.LifecycleStateManager;

public class StandardLifecycleStateManager
implements LifecycleStateManager {
    private final ConcurrentMap<String, LifecycleState> lifecycleStates = new ConcurrentHashMap<String, LifecycleState>();

    public LifecycleState getOrRegisterLifecycleState(String componentId, boolean replaceTerminatedState, boolean replaceUnscheduledState) {
        LifecycleState lifecycleState;
        block2: {
            LifecycleState newLifecycleState;
            Objects.requireNonNull(componentId);
            while (true) {
                if ((lifecycleState = (LifecycleState)this.lifecycleStates.get(componentId)) == null) {
                    lifecycleState = new LifecycleState(componentId);
                    LifecycleState existing = this.lifecycleStates.putIfAbsent(componentId, lifecycleState);
                    if (existing != null) continue;
                    break block2;
                }
                if (!this.isReplace(lifecycleState, replaceTerminatedState, replaceUnscheduledState)) break block2;
                newLifecycleState = new LifecycleState(componentId);
                boolean replaced = this.lifecycleStates.replace(componentId, lifecycleState, newLifecycleState);
                if (replaced) break;
            }
            lifecycleState = newLifecycleState;
        }
        return lifecycleState;
    }

    private boolean isReplace(LifecycleState lifecycleState, boolean replaceTerminated, boolean replaceUnscheduled) {
        if (replaceTerminated && lifecycleState.isTerminated()) {
            return true;
        }
        return replaceUnscheduled && !lifecycleState.isScheduled();
    }

    public Optional<LifecycleState> getLifecycleState(String componentId) {
        if (componentId == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((LifecycleState)this.lifecycleStates.get(componentId));
    }

    public Optional<LifecycleState> removeLifecycleState(String componentId) {
        if (componentId == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((LifecycleState)this.lifecycleStates.remove(componentId));
    }
}

