/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.metrics.ComponentMetricContext;
import org.apache.nifi.controller.metrics.ComponentMetricReporter;
import org.apache.nifi.controller.metrics.CounterRecord;
import org.apache.nifi.controller.metrics.GaugeRecord;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.CounterRepository;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.ProvenanceEventEnricher;
import org.apache.nifi.controller.repository.RepositoryContext;
import org.apache.nifi.controller.repository.StandardProvenanceReporter;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.provenance.InternalProvenanceReporter;
import org.apache.nifi.provenance.ProvenanceEventBuilder;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.provenance.StandardProvenanceEventRecord;
import org.apache.nifi.util.Connectables;

public abstract class AbstractRepositoryContext
implements RepositoryContext {
    private final Connectable connectable;
    private final ContentRepository contentRepo;
    private final FlowFileRepository flowFileRepo;
    private final FlowFileEventRepository flowFileEventRepo;
    private final CounterRepository counterRepo;
    private final ComponentMetricReporter componentMetricReporter;
    private final ProvenanceEventRepository provenanceRepo;
    private final AtomicLong connectionIndex;
    private final StateManager stateManager;
    private final ComponentMetricContext componentMetricContext;
    private final String componentNameCounterContext;
    private final String componentTypeCounterContext;

    public AbstractRepositoryContext(Connectable connectable, AtomicLong connectionIndex, ContentRepository contentRepository, FlowFileRepository flowFileRepository, FlowFileEventRepository flowFileEventRepository, CounterRepository counterRepository, ComponentMetricReporter componentMetricReporter, ProvenanceEventRepository provenanceRepository, StateManager stateManager) {
        this.connectable = connectable;
        this.contentRepo = contentRepository;
        this.flowFileRepo = flowFileRepository;
        this.flowFileEventRepo = flowFileEventRepository;
        this.counterRepo = counterRepository;
        this.componentMetricReporter = componentMetricReporter;
        this.provenanceRepo = provenanceRepository;
        this.connectionIndex = connectionIndex;
        this.stateManager = stateManager;
        Map groupAttributes = connectable.getProcessGroup().getLoggingAttributes();
        this.componentMetricContext = new ComponentMetricContext(connectable.getIdentifier(), connectable.getName(), connectable.getComponentType(), groupAttributes);
        this.componentNameCounterContext = connectable.getName() + " (" + connectable.getIdentifier() + ")";
        this.componentTypeCounterContext = "All " + connectable.getComponentType() + "'s";
    }

    @Override
    public Connectable getConnectable() {
        return this.connectable;
    }

    @Override
    public ComponentMetricContext getComponentMetricContext() {
        return this.componentMetricContext;
    }

    @Override
    public Collection<Connection> getConnections(Relationship relationship) {
        Collection collection = this.connectable.getConnections(relationship);
        if (collection == null) {
            collection = new ArrayList();
        }
        return Collections.unmodifiableCollection(collection);
    }

    @Override
    public List<Connection> getPollableConnections() {
        if (this.pollFromSelfLoopsOnly()) {
            ArrayList<Connection> selfLoops = new ArrayList<Connection>();
            for (Connection connection : this.connectable.getIncomingConnections()) {
                if (connection.getSource() != connection.getDestination()) continue;
                selfLoops.add(connection);
            }
            return selfLoops;
        }
        return this.connectable.getIncomingConnections();
    }

    private boolean isTriggerWhenAnyDestinationAvailable() {
        if (this.connectable.getConnectableType() != ConnectableType.PROCESSOR) {
            return false;
        }
        ProcessorNode procNode = (ProcessorNode)this.connectable;
        return procNode.isTriggerWhenAnyDestinationAvailable();
    }

    private boolean pollFromSelfLoopsOnly() {
        if (this.isTriggerWhenAnyDestinationAvailable()) {
            return !Connectables.anyRelationshipAvailable(this.connectable);
        }
        for (Connection connection : this.connectable.getConnections()) {
            if (!connection.getFlowFileQueue().isFull()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void adjustCounter(String name, long delta) {
        this.counterRepo.adjustCounter(this.componentNameCounterContext, name, delta);
        this.counterRepo.adjustCounter(this.componentTypeCounterContext, name, delta);
        CounterRecord counterRecord = new CounterRecord(name, delta, Instant.now(), this.componentMetricContext);
        this.componentMetricReporter.recordCounter(counterRecord);
    }

    @Override
    public void recordGauge(GaugeRecord gaugeRecord) {
        this.componentMetricReporter.recordGauge(gaugeRecord);
    }

    @Override
    public ContentRepository getContentRepository() {
        return this.contentRepo;
    }

    @Override
    public FlowFileRepository getFlowFileRepository() {
        return this.flowFileRepo;
    }

    @Override
    public FlowFileEventRepository getFlowFileEventRepository() {
        return this.flowFileEventRepo;
    }

    @Override
    public ProvenanceEventRepository getProvenanceRepository() {
        return this.provenanceRepo;
    }

    @Override
    public long getNextFlowFileSequence() {
        return this.flowFileRepo.getNextFlowFileSequence();
    }

    @Override
    public int getNextIncomingConnectionIndex() {
        int numIncomingConnections = this.connectable.getIncomingConnections().size();
        return (int)(this.connectionIndex.getAndIncrement() % (long)Math.max(1, numIncomingConnections));
    }

    @Override
    public boolean isRelationshipAvailabilitySatisfied(int requiredNumber) {
        int unavailable = 0;
        Collection allRelationships = this.connectable.getRelationships();
        int numRelationships = allRelationships.size();
        int maxUnavailable = numRelationships - requiredNumber;
        for (Relationship relationship : allRelationships) {
            Set connections = this.connectable.getConnections(relationship);
            if (connections == null || connections.isEmpty()) continue;
            boolean available = true;
            for (Connection connection : connections) {
                if (connection.getSource() == connection.getDestination() || !connection.getFlowFileQueue().isFull()) continue;
                available = false;
                break;
            }
            if (available || ++unavailable <= maxUnavailable) continue;
            return false;
        }
        return true;
    }

    protected String getProvenanceComponentDescription() {
        return switch (this.connectable.getConnectableType()) {
            case ConnectableType.PROCESSOR -> ((ProcessorNode)this.connectable).getComponentType();
            case ConnectableType.INPUT_PORT -> "Input Port";
            case ConnectableType.OUTPUT_PORT -> "Output Port";
            case ConnectableType.REMOTE_INPUT_PORT -> "Remote Input Port";
            case ConnectableType.REMOTE_OUTPUT_PORT -> "Remote Output Port";
            case ConnectableType.FUNNEL -> "Funnel";
            default -> throw new AssertionError((Object)("Connectable type is " + String.valueOf(this.connectable.getConnectableType())));
        };
    }

    @Override
    public String getConnectableDescription() {
        if (this.connectable.getConnectableType() == ConnectableType.PROCESSOR) {
            return ((ProcessorNode)this.connectable).getProcessor().toString();
        }
        return this.connectable.toString();
    }

    @Override
    public ProvenanceEventBuilder createProvenanceEventBuilder() {
        return new StandardProvenanceEventRecord.Builder();
    }

    @Override
    public InternalProvenanceReporter createProvenanceReporter(Predicate<FlowFile> flowfileKnownCheck, ProvenanceEventEnricher eventEnricher) {
        String componentType = this.getProvenanceComponentDescription();
        return new StandardProvenanceReporter(flowfileKnownCheck, this.getConnectable().getIdentifier(), componentType, this.getProvenanceRepository(), eventEnricher);
    }

    @Override
    public StateManager getStateManager() {
        return this.stateManager;
    }
}

