/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.parameter;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ClassloaderIsolationKeyProvider;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.components.validation.ValidationTrigger;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractComponentNode;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.LoggableComponent;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.controller.ParametersApplication;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.TerminationAwareLogger;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.parameter.ParameterProviderDetails;
import org.apache.nifi.controller.parameter.ParameterProviderInstantiationException;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.migration.ControllerServiceCreationDetails;
import org.apache.nifi.migration.ControllerServiceFactory;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.migration.StandardPropertyConfiguration;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.InstanceClassLoader;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.parameter.ParameterGroup;
import org.apache.nifi.parameter.ParameterGroupConfiguration;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.parameter.ParameterProvider;
import org.apache.nifi.parameter.ParameterSensitivity;
import org.apache.nifi.parameter.VerifiableParameterProvider;
import org.apache.nifi.util.CharacterFilterUtils;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;

public class StandardParameterProviderNode
extends AbstractComponentNode
implements ParameterProviderNode {
    private static final Pattern PARAMETER_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9-_. ]+$");
    private final AtomicReference<ParameterProviderDetails> parameterProviderRef;
    private final ControllerServiceLookup serviceLookup;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final Set<ParameterContext> referencingParameterContexts;
    private final List<ParameterGroup> fetchedParameterGroups = new ArrayList<ParameterGroup>();
    private volatile String comment;
    private final Authorizable parentAuthorizable;

    public StandardParameterProviderNode(LoggableComponent<ParameterProvider> parameterProvider, String id, Authorizable parentAuthorizable, ControllerServiceProvider controllerServiceProvider, ValidationContextFactory validationContextFactory, ReloadComponent reloadComponent, ExtensionManager extensionManager, ValidationTrigger validationTrigger) {
        this(parameterProvider, id, parentAuthorizable, controllerServiceProvider, validationContextFactory, ((ParameterProvider)parameterProvider.getComponent()).getClass().getSimpleName(), ((ParameterProvider)parameterProvider.getComponent()).getClass().getCanonicalName(), reloadComponent, extensionManager, validationTrigger, false);
    }

    public StandardParameterProviderNode(LoggableComponent<ParameterProvider> parameterProvider, String id, Authorizable parentAuthorizable, ControllerServiceProvider controllerServiceProvider, ValidationContextFactory validationContextFactory, String componentType, String canonicalClassName, ReloadComponent reloadComponent, ExtensionManager extensionManager, ValidationTrigger validationTrigger, boolean isExtensionMissing) {
        super(id, validationContextFactory, controllerServiceProvider, componentType, canonicalClassName, reloadComponent, extensionManager, validationTrigger, isExtensionMissing);
        this.parameterProviderRef = new AtomicReference<ParameterProviderDetails>(new ParameterProviderDetails(parameterProvider));
        this.serviceLookup = controllerServiceProvider;
        this.referencingParameterContexts = new HashSet<ParameterContext>();
        this.parentAuthorizable = parentAuthorizable;
    }

    public Authorizable getParentAuthorizable() {
        return this.parentAuthorizable;
    }

    public Resource getResource() {
        return ResourceFactory.getComponentResource((ResourceType)ResourceType.ParameterProvider, (String)this.getIdentifier(), (String)this.getName());
    }

    public boolean isRestricted() {
        return this.getParameterProvider().getClass().isAnnotationPresent(Restricted.class);
    }

    public Class<?> getComponentClass() {
        return this.getParameterProvider().getClass();
    }

    public boolean isDeprecated() {
        return this.getParameterProvider().getClass().isAnnotationPresent(DeprecationNotice.class);
    }

    protected ParameterContext getParameterContext() {
        return null;
    }

    public ConfigurableComponent getComponent() {
        return this.parameterProviderRef.get().getParameterProvider();
    }

    public BundleCoordinate getBundleCoordinate() {
        return this.parameterProviderRef.get().getBundleCoordinate();
    }

    public TerminationAwareLogger getLogger() {
        return this.parameterProviderRef.get().getComponentLog();
    }

    public ParameterProvider getParameterProvider() {
        return this.parameterProviderRef.get().getParameterProvider();
    }

    public void setParameterProvider(LoggableComponent<ParameterProvider> parameterProvider) {
        this.parameterProviderRef.set(new ParameterProviderDetails(parameterProvider));
    }

    public void reload(Set<URL> additionalUrls) throws ParameterProviderInstantiationException {
        String additionalResourcesFingerprint = ClassLoaderUtils.generateAdditionalUrlsFingerprint(additionalUrls, (String)this.determineClasloaderIsolationKey());
        this.setAdditionalResourcesFingerprint(additionalResourcesFingerprint);
        this.getReloadComponent().reload((ParameterProviderNode)this, this.getCanonicalClassName(), this.getBundleCoordinate(), additionalUrls);
    }

    public boolean isValidationNecessary() {
        return true;
    }

    public Optional<ProcessGroup> getParentProcessGroup() {
        return Optional.empty();
    }

    public ConfigurationContext getConfigurationContext() {
        return new StandardConfigurationContext((ComponentNode)this, this.serviceLookup, null);
    }

    public void verifyModifiable() throws IllegalStateException {
    }

    public String getComments() {
        return this.comment;
    }

    public void setComments(String comment) {
        this.comment = CharacterFilterUtils.filterInvalidXmlCharacters((String)comment);
    }

    public void verifyCanClearState() {
    }

    public String toString() {
        return "ParameterProvider[id=" + this.getIdentifier() + "]";
    }

    public String getProcessGroupIdentifier() {
        return null;
    }

    public ParameterLookup getParameterLookup() {
        return ParameterLookup.EMPTY;
    }

    public Set<ParameterContext> getReferences() {
        this.readLock.lock();
        try {
            Set<ParameterContext> set = Collections.unmodifiableSet(this.referencingParameterContexts);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void addReference(ParameterContext reference) {
        this.writeLock.lock();
        try {
            this.referencingParameterContexts.add(reference);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeReference(ParameterContext reference) {
        this.writeLock.lock();
        try {
            this.referencingParameterContexts.remove(reference);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected List<ValidationResult> validateConfig() {
        return Collections.emptyList();
    }

    public void verifyCanFetchParameters() {
        ValidationStatus validationStatus = this.performValidation();
        if (validationStatus != ValidationStatus.VALID) {
            throw new IllegalStateException(String.format("Cannot fetch parameters for %s while validation state is %s", new Object[]{this, validationStatus}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchParameters() {
        List fetchedParameterGroups;
        ParameterProvider parameterProvider = this.parameterProviderRef.get().getParameterProvider();
        ConfigurationContext configurationContext = this.getConfigurationContext();
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), (Class)parameterProvider.getClass(), (String)parameterProvider.getIdentifier());){
            fetchedParameterGroups = parameterProvider.fetchParameters(configurationContext);
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalStateException(String.format("Error fetching parameters for %s: %s", new Object[]{this, e.getMessage()}), e);
        }
        if (fetchedParameterGroups == null || fetchedParameterGroups.isEmpty()) {
            return;
        }
        HashSet<String> parameterGroupNames = new HashSet<String>();
        this.writeLock.lock();
        try {
            this.fetchedParameterGroups.clear();
            for (ParameterGroup group : fetchedParameterGroups) {
                String groupName = group.getGroupName();
                if (parameterGroupNames.contains(groupName)) {
                    throw new IllegalStateException(String.format("Cannot fetch parameters for %s: Parameter group [%s] is provided twice, which is not allowed", new Object[]{this, groupName}));
                }
                List parameters = group.getParameters();
                if (parameters == null) continue;
                ArrayList<Parameter> validParameters = new ArrayList<Parameter>();
                HashSet<String> parameterNames = new HashSet<String>();
                for (Parameter parameter : parameters) {
                    ParameterDescriptor descriptor = parameter.getDescriptor();
                    if (descriptor == null) {
                        throw new IllegalStateException("Cannot fetch parameters for " + String.valueOf((Object)this) + ": a Parameter is missing a ParameterDescriptor in the fetch response");
                    }
                    String parameterName = descriptor.getName();
                    if (parameterNames.contains(parameterName)) {
                        throw new IllegalStateException(String.format("Cannot fetch parameters for %s: Parameter [%s] is provided in group [%s] twice, which is not allowed", new Object[]{this, parameterName, groupName}));
                    }
                    if (parameter.getValue() == null) {
                        this.getLogger().warn("Skipping parameter [{}], which is missing a value", new Object[]{parameterName});
                        continue;
                    }
                    if (PARAMETER_NAME_PATTERN.matcher(parameter.getDescriptor().getName()).matches()) {
                        validParameters.add(parameter);
                        parameterNames.add(parameter.getDescriptor().getName());
                        continue;
                    }
                    this.getLogger().warn("Skipping parameter [{}], whose name has invalid characters. Only alpha-numeric characters (a-z, A-Z, 0-9), hyphens (-), underscores (_), periods (.), and spaces ( ) are accepted for parameter names in NiFi.", new Object[]{parameterName});
                }
                this.fetchedParameterGroups.add(new ParameterGroup(groupName, StandardParameterProviderNode.toProvidedParameters(validParameters)));
                parameterGroupNames.add(groupName);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Optional<ParameterGroup> findFetchedParameterGroup(String parameterGroupName) {
        Objects.requireNonNull(parameterGroupName, "Parameter Group Name required");
        this.readLock.lock();
        try {
            Optional<ParameterGroup> optional = this.fetchedParameterGroups.stream().filter(parameterGroup -> parameterGroup.getGroupName().equals(parameterGroupName)).findFirst();
            return optional;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyCanApplyParameters(Collection<ParameterGroupConfiguration> parameterGroupConfigurations) {
        if (this.fetchedParameterGroups.isEmpty()) {
            return;
        }
        this.readLock.lock();
        try {
            Map parameterGroupConfigurationMap = parameterGroupConfigurations.stream().collect(Collectors.toMap(ParameterGroupConfiguration::getParameterContextName, Function.identity()));
            for (ParameterContext reference : this.getReferences()) {
                ParameterGroupConfiguration groupConfiguration = (ParameterGroupConfiguration)parameterGroupConfigurationMap.get(reference.getName());
                if (groupConfiguration == null) continue;
                Map<String, Parameter> parameterUpdates = this.getFetchedParameterUpdateMap(reference, groupConfiguration);
                HashSet removedParametersWithReferences = new HashSet();
                for (Map.Entry<String, Parameter> entry : parameterUpdates.entrySet()) {
                    String parameterName = entry.getKey();
                    if (entry.getValue() != null) continue;
                    reference.getParameter(parameterName).ifPresent(currentParameter -> {
                        if (reference.hasReferencingComponents(currentParameter)) {
                            removedParametersWithReferences.add(parameterName);
                        }
                    });
                }
                removedParametersWithReferences.forEach(parameterUpdates::remove);
                reference.verifyCanSetParameters(parameterUpdates);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void verifyCanDelete() {
        if (!this.getReferences().isEmpty()) {
            String contextNameList = this.getReferences().stream().map(ParameterContext::getName).collect(Collectors.joining(", "));
            throw new IllegalStateException(String.format("Cannot delete %s while it is referenced by Contexts: [%s]", new Object[]{this, contextNameList}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigVerificationResult> verifyConfiguration(ConfigurationContext context, ComponentLog logger, ExtensionManager extensionManager) {
        ArrayList<ConfigVerificationResult> results;
        block21: {
            results = new ArrayList<ConfigVerificationResult>();
            try {
                long startNanos = System.nanoTime();
                results.addAll(super.verifyConfig(context.getProperties(), context.getAnnotationData(), null));
                long validationComplete = System.nanoTime();
                if (!results.isEmpty() && results.stream().anyMatch(result -> result.getOutcome() == ConfigVerificationResult.Outcome.FAILED)) {
                    return results;
                }
                ParameterProvider parameterProvider = this.getParameterProvider();
                if (parameterProvider instanceof VerifiableParameterProvider) {
                    block20: {
                        logger.debug("{} is a VerifiableParameterProvider. Will perform full verification of configuration.", new Object[]{this});
                        VerifiableParameterProvider verifiable = (VerifiableParameterProvider)parameterProvider;
                        boolean classpathDifferent = this.isClasspathDifferent(context.getProperties());
                        if (classpathDifferent) {
                            Bundle bundle = extensionManager.getBundle(this.getBundleCoordinate());
                            Set classpathUrls = this.getAdditionalClasspathResources(context.getProperties().keySet(), descriptor -> context.getProperty(descriptor).getValue());
                            String classloaderIsolationKey = this.getClassLoaderIsolationKey((PropertyContext)context);
                            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
                            try (InstanceClassLoader detectedClassLoader = extensionManager.createInstanceClassLoader(this.getComponentType(), this.getIdentifier(), bundle, classpathUrls, false, classloaderIsolationKey);){
                                Thread.currentThread().setContextClassLoader((ClassLoader)detectedClassLoader);
                                results.addAll(verifiable.verify(context, logger));
                                break block20;
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(currentClassLoader);
                            }
                        }
                        try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)extensionManager, (Class)parameterProvider.getClass(), (String)this.getIdentifier());){
                            results.addAll(verifiable.verify(context, logger));
                        }
                    }
                    long validationNanos = validationComplete - startNanos;
                    long verificationNanos = System.nanoTime() - validationComplete;
                    logger.debug("{} completed full configuration validation in {} plus {} for validation", new Object[]{this, FormatUtils.formatNanos((long)verificationNanos, (boolean)false), FormatUtils.formatNanos((long)validationNanos, (boolean)false)});
                    break block21;
                }
                logger.debug("{} is not a VerifiableParameterProvider, so will not perform full verification of configuration. Validation took {}", new Object[]{this, FormatUtils.formatNanos((long)(validationComplete - startNanos), (boolean)false)});
            }
            catch (Throwable t) {
                logger.error("Failed to perform verification of Parameter Provider's configuration for {}", new Object[]{this, t});
                results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.FAILED).verificationStepName("Perform Verification").explanation("Encountered unexpected failure when attempting to perform verification: " + String.valueOf(t)).build());
            }
        }
        return results;
    }

    private Map<String, Parameter> getFetchedParameterUpdateMap(ParameterContext parameterContext, ParameterGroupConfiguration parameterGroupConfiguration) {
        HashMap<String, Parameter> parameterUpdateMap = new HashMap<String, Parameter>();
        ParameterGroup parameterGroup = this.fetchedParameterGroups.stream().filter(group -> parameterContext.getParameterProviderConfiguration().getParameterGroupName().equals(group.getGroupName())).findFirst().orElse(null);
        if (parameterGroup == null) {
            return parameterUpdateMap;
        }
        List<Parameter> configuredParameters = this.configureParameters(parameterGroup.getParameters(), parameterGroupConfiguration);
        Map fetchedParameterMap = configuredParameters.stream().collect(Collectors.toMap(Parameter::getDescriptor, Function.identity()));
        Map currentParameters = parameterContext.getParameters();
        currentParameters.keySet().forEach(descriptor -> {
            if (!fetchedParameterMap.containsKey(descriptor)) {
                parameterUpdateMap.put(descriptor.getName(), null);
            }
        });
        for (Map.Entry entry : fetchedParameterMap.entrySet()) {
            boolean isSensitivityChanged;
            ParameterDescriptor descriptor2 = entry.getKey();
            Parameter fetchedParameter = (Parameter)entry.getValue();
            Parameter currentParameter = (Parameter)currentParameters.get(descriptor2);
            if (currentParameter == null) {
                parameterUpdateMap.put(descriptor2.getName(), fetchedParameter);
                continue;
            }
            boolean bl = isSensitivityChanged = currentParameter.getDescriptor().isSensitive() != fetchedParameter.getDescriptor().isSensitive();
            if (Objects.equals(currentParameter.getValue(), fetchedParameter.getValue()) && !isSensitivityChanged) continue;
            parameterUpdateMap.put(descriptor2.getName(), fetchedParameter);
            if (!isSensitivityChanged) continue;
            ParameterSensitivity currentSensitivity = currentParameter.getDescriptor().isSensitive() ? ParameterSensitivity.SENSITIVE : ParameterSensitivity.NON_SENSITIVE;
            ParameterSensitivity fetchedSensitivity = fetchedParameter.getDescriptor().isSensitive() ? ParameterSensitivity.SENSITIVE : ParameterSensitivity.NON_SENSITIVE;
            this.getLogger().info("Parameter [{}] sensitivity is being changed from {} to {}", new Object[]{descriptor2.getName(), currentSensitivity.getName(), fetchedSensitivity.getName()});
        }
        return parameterUpdateMap;
    }

    private List<Parameter> configureParameters(Collection<Parameter> parameters, ParameterGroupConfiguration groupConfiguration) {
        HashSet parameterNameFilter = new HashSet(groupConfiguration.getParameterSensitivities().keySet());
        return parameters == null ? Collections.emptyList() : parameters.stream().filter(parameter -> parameterNameFilter.contains(parameter.getDescriptor().getName())).map(parameter -> {
            String parameterName = parameter.getDescriptor().getName();
            ParameterSensitivity sensitivity = (ParameterSensitivity)groupConfiguration.getParameterSensitivities().get(parameterName);
            if (sensitivity == null) {
                throw new IllegalArgumentException(String.format("Parameter sensitivity must be specified for parameter [%s] in group [%s]", parameterName, groupConfiguration.getGroupName()));
            }
            return new Parameter.Builder().fromParameter(parameter).sensitive(sensitivity == ParameterSensitivity.SENSITIVE).provided(Boolean.valueOf(true)).build();
        }).collect(Collectors.toList());
    }

    private static List<Parameter> toProvidedParameters(Collection<Parameter> parameters) {
        return parameters == null ? Collections.emptyList() : parameters.stream().map(parameter -> new Parameter.Builder().descriptor(parameter.getDescriptor()).value(parameter.getValue()).provided(Boolean.valueOf(true)).build()).collect(Collectors.toList());
    }

    public Collection<ParameterGroupConfiguration> getParameterGroupConfigurations() {
        Map parameterContextMap = this.getReferences().stream().collect(Collectors.toMap(context -> context.getParameterProviderConfiguration().getParameterGroupName(), Function.identity()));
        ArrayList<ParameterGroupConfiguration> parameterGroupConfigurations = new ArrayList<ParameterGroupConfiguration>();
        this.fetchedParameterGroups.forEach(parameterGroup -> {
            String parameterContextName;
            Boolean isSynchronized;
            ParameterContext parameterContext = (ParameterContext)parameterContextMap.get(parameterGroup.getGroupName());
            Set fetchedParameterNames = parameterGroup.getParameters().stream().map(parameter -> parameter.getDescriptor().getName()).collect(Collectors.toSet());
            HashMap parameterSensitivities = new HashMap();
            if (parameterContext != null) {
                isSynchronized = parameterContext.getParameterProviderConfiguration().isSynchronized();
                parameterContextName = parameterContext.getName();
                parameterContext.getParameters().forEach((descriptor, parameter) -> {
                    if (fetchedParameterNames.contains(descriptor.getName())) {
                        ParameterSensitivity sensitivity = descriptor.isSensitive() ? ParameterSensitivity.SENSITIVE : ParameterSensitivity.NON_SENSITIVE;
                        parameterSensitivities.put(descriptor.getName(), sensitivity);
                    }
                });
            } else {
                parameterContextName = parameterGroup.getGroupName();
                isSynchronized = null;
            }
            parameterGroup.getParameters().forEach(parameter -> {
                String parameterName = parameter.getDescriptor().getName();
                if (!parameterSensitivities.containsKey(parameterName)) {
                    parameterSensitivities.put(parameterName, null);
                }
            });
            ParameterGroupConfiguration groupConfiguration = new ParameterGroupConfiguration(parameterGroup.getGroupName(), parameterContextName, parameterSensitivities, isSynchronized);
            parameterGroupConfigurations.add(groupConfiguration);
        });
        return parameterGroupConfigurations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ParametersApplication> getFetchedParametersToApply(Collection<ParameterGroupConfiguration> parameterGroupConfigurations) {
        this.readLock.lock();
        try {
            Map parameterGroupConfigurationMap = parameterGroupConfigurations.stream().collect(Collectors.toMap(ParameterGroupConfiguration::getParameterContextName, Function.identity()));
            ArrayList<ParametersApplication> parametersApplications = new ArrayList<ParametersApplication>();
            for (ParameterContext parameterContext : this.getReferences()) {
                ParameterGroupConfiguration groupConfiguration = (ParameterGroupConfiguration)parameterGroupConfigurationMap.get(parameterContext.getName());
                if (groupConfiguration == null || groupConfiguration.isSynchronized() == null || !groupConfiguration.isSynchronized().booleanValue()) continue;
                Map<String, Parameter> parameterUpdateMap = this.getFetchedParameterUpdateMap(parameterContext, groupConfiguration);
                parametersApplications.add(new ParametersApplication(parameterContext, parameterUpdateMap));
            }
            ArrayList<ParametersApplication> arrayList = parametersApplications;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void migrateConfiguration(Map<String, String> originalPropertyValues, ControllerServiceFactory serviceFactory) {
        HashMap<String, String> effectiveValues = new HashMap<String, String>();
        originalPropertyValues.forEach((key, value) -> effectiveValues.put((String)key, this.mapRawValueToEffectiveValue((String)value)));
        StandardPropertyConfiguration propertyConfig = new StandardPropertyConfiguration(effectiveValues, originalPropertyValues, x$0 -> this.mapRawValueToEffectiveValue((String)x$0), this.toString(), serviceFactory);
        ParameterProvider parameterProvider = this.getParameterProvider();
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), (Class)parameterProvider.getClass(), (String)this.getIdentifier());){
            parameterProvider.migrateProperties((PropertyConfiguration)propertyConfig);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to migrate Property Configuration for {}.", new Object[]{this, e});
        }
        if (propertyConfig.isModified()) {
            List<ControllerServiceCreationDetails> servicesCreated = propertyConfig.getCreatedServices();
            servicesCreated.forEach(arg_0 -> ((ControllerServiceFactory)serviceFactory).create(arg_0));
            this.overwriteProperties(propertyConfig.getRawProperties());
        }
    }

    protected String determineClasloaderIsolationKey() {
        ConfigurableComponent component = this.getComponent();
        if (!(component instanceof ClassloaderIsolationKeyProvider)) {
            return null;
        }
        ValidationContext validationContext = this.getValidationContextFactory().newValidationContext(this.getProperties(), this.getAnnotationData(), this.getProcessGroupIdentifier(), this.getIdentifier(), this.getParameterContext(), true);
        return this.getClassLoaderIsolationKey((PropertyContext)validationContext);
    }
}

