/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.flowanalysis;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.components.validation.ValidationTrigger;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractComponentNode;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.FlowAnalysisRuleNode;
import org.apache.nifi.controller.LoggableComponent;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.TerminationAwareLogger;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.flowanalysis.FlowAnalysisRuleDetails;
import org.apache.nifi.controller.flowanalysis.FlowAnalysisRuleInstantiationException;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.flowanalysis.EnforcementPolicy;
import org.apache.nifi.flowanalysis.FlowAnalysisRule;
import org.apache.nifi.flowanalysis.FlowAnalysisRuleState;
import org.apache.nifi.flowanalysis.VerifiableFlowAnalysisRule;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.LoggingContext;
import org.apache.nifi.logging.StandardLoggingContext;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.InstanceClassLoader;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.util.CharacterFilterUtils;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.ReflectionUtils;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;
import org.apache.nifi.validation.RuleViolationsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFlowAnalysisRuleNode
extends AbstractComponentNode
implements FlowAnalysisRuleNode {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AtomicReference<FlowAnalysisRuleDetails> flowAnalysisRuleRef;
    private final ControllerServiceLookup serviceLookup;
    private final RuleViolationsManager ruleViolationsManager;
    private volatile String comment;
    private EnforcementPolicy enforcementPolicy;
    private volatile FlowAnalysisRuleState state = FlowAnalysisRuleState.DISABLED;

    public AbstractFlowAnalysisRuleNode(LoggableComponent<FlowAnalysisRule> flowAnalysisRule, String id, ControllerServiceProvider controllerServiceProvider, ValidationContextFactory validationContextFactory, RuleViolationsManager ruleViolationsManager, ReloadComponent reloadComponent, ExtensionManager extensionManager, ValidationTrigger validationTrigger) {
        this(flowAnalysisRule, id, controllerServiceProvider, validationContextFactory, ruleViolationsManager, ((FlowAnalysisRule)flowAnalysisRule.getComponent()).getClass().getSimpleName(), ((FlowAnalysisRule)flowAnalysisRule.getComponent()).getClass().getCanonicalName(), reloadComponent, extensionManager, validationTrigger, false);
    }

    public AbstractFlowAnalysisRuleNode(LoggableComponent<FlowAnalysisRule> flowAnalysisRule, String id, ControllerServiceProvider controllerServiceProvider, ValidationContextFactory validationContextFactory, RuleViolationsManager ruleViolationsManager, String componentType, String componentCanonicalClass, ReloadComponent reloadComponent, ExtensionManager extensionManager, ValidationTrigger validationTrigger, boolean isExtensionMissing) {
        super(id, validationContextFactory, controllerServiceProvider, componentType, componentCanonicalClass, reloadComponent, extensionManager, validationTrigger, isExtensionMissing);
        this.flowAnalysisRuleRef = new AtomicReference<FlowAnalysisRuleDetails>(new FlowAnalysisRuleDetails(flowAnalysisRule));
        this.serviceLookup = controllerServiceProvider;
        this.ruleViolationsManager = ruleViolationsManager;
        this.enforcementPolicy = EnforcementPolicy.WARN;
    }

    public EnforcementPolicy getEnforcementPolicy() {
        return this.enforcementPolicy;
    }

    public void setEnforcementPolicy(EnforcementPolicy enforcementPolicy) {
        this.enforcementPolicy = enforcementPolicy;
    }

    public ConfigurableComponent getComponent() {
        return this.flowAnalysisRuleRef.get().getFlowAnalysisRule();
    }

    public BundleCoordinate getBundleCoordinate() {
        return this.flowAnalysisRuleRef.get().getBundleCoordinate();
    }

    public TerminationAwareLogger getLogger() {
        return this.flowAnalysisRuleRef.get().getComponentLog();
    }

    public FlowAnalysisRule getFlowAnalysisRule() {
        return this.flowAnalysisRuleRef.get().getFlowAnalysisRule();
    }

    public void setFlowAnalysisRule(LoggableComponent<FlowAnalysisRule> flowAnalysisRule) {
        if (this.isEnabled()) {
            throw new IllegalStateException("Cannot modify Flow Analysis Rule configuration while it is enabled");
        }
        this.flowAnalysisRuleRef.set(new FlowAnalysisRuleDetails(flowAnalysisRule));
    }

    public void reload(Set<URL> additionalUrls) throws FlowAnalysisRuleInstantiationException {
        if (this.isEnabled()) {
            throw new IllegalStateException("Cannot reload Flow Analysis Rule while it is enabled");
        }
        String additionalResourcesFingerprint = ClassLoaderUtils.generateAdditionalUrlsFingerprint(additionalUrls, (String)this.determineClasloaderIsolationKey());
        this.setAdditionalResourcesFingerprint(additionalResourcesFingerprint);
        this.getReloadComponent().reload((FlowAnalysisRuleNode)this, this.getCanonicalClassName(), this.getBundleCoordinate(), additionalUrls);
    }

    public boolean isEnabled() {
        return FlowAnalysisRuleState.ENABLED.equals((Object)this.state);
    }

    public boolean isValidationNecessary() {
        return !this.isEnabled() || this.getValidationStatus() != ValidationStatus.VALID;
    }

    public ConfigurationContext getConfigurationContext() {
        return new StandardConfigurationContext((ComponentNode)this, this.serviceLookup, null);
    }

    public void verifyModifiable() throws IllegalStateException {
        if (this.isEnabled()) {
            throw new IllegalStateException("Cannot modify Flow Analysis Rule while it is enabled");
        }
    }

    public FlowAnalysisRuleState getState() {
        return this.state;
    }

    public String getComments() {
        return this.comment;
    }

    public void setComments(String comment) {
        this.comment = CharacterFilterUtils.filterInvalidXmlCharacters((String)comment);
    }

    public void verifyCanDelete() {
        if (this.isEnabled()) {
            throw new IllegalStateException("Cannot delete " + this.getFlowAnalysisRule().getIdentifier() + " because it is enabled");
        }
    }

    public void verifyCanDisable() {
        if (!this.isEnabled()) {
            throw new IllegalStateException("Cannot disable " + this.getFlowAnalysisRule().getIdentifier() + " because it is already disabled");
        }
    }

    public void verifyCanEnable() {
        if (this.getValidationStatus() == ValidationStatus.INVALID) {
            throw new IllegalStateException("Cannot enable " + this.getFlowAnalysisRule().getIdentifier() + " because it is in INVALID status");
        }
        if (this.isEnabled()) {
            throw new IllegalStateException("Cannot enable " + this.getFlowAnalysisRule().getIdentifier() + " because it is not disabled");
        }
    }

    public void verifyCanEnable(Set<ControllerServiceNode> ignoredServices) {
        if (this.isEnabled()) {
            throw new IllegalStateException("Cannot enable " + this.getFlowAnalysisRule().getIdentifier() + " because it is not disabled");
        }
        Collection validationResults = this.getValidationErrors(ignoredServices);
        if (!validationResults.isEmpty()) {
            throw new IllegalStateException(String.valueOf((Object)this) + " cannot be enabled because it is not currently valid");
        }
    }

    public void verifyCanUpdate() {
        if (this.isEnabled()) {
            throw new IllegalStateException("Cannot update " + this.getFlowAnalysisRule().getIdentifier() + " because it is currently enabled");
        }
    }

    public void verifyCanClearState() {
        this.verifyCanUpdate();
    }

    public String getProcessGroupIdentifier() {
        return null;
    }

    public ParameterLookup getParameterLookup() {
        return ParameterLookup.EMPTY;
    }

    public String toString() {
        FlowAnalysisRule flowAnalysisRule = this.flowAnalysisRuleRef.get().getFlowAnalysisRule();
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), (Class)flowAnalysisRule.getClass(), (String)flowAnalysisRule.getIdentifier());){
            String string = this.getFlowAnalysisRule().toString();
            return string;
        }
    }

    public void enable() {
        this.verifyCanEnable();
        this.setState(FlowAnalysisRuleState.ENABLED, OnEnabled.class);
    }

    public void disable() {
        this.verifyCanDisable();
        this.setState(FlowAnalysisRuleState.DISABLED, OnDisabled.class);
        this.ruleViolationsManager.removeRuleViolationsForRule(this.getIdentifier());
        this.ruleViolationsManager.cleanUp();
    }

    private void setState(FlowAnalysisRuleState newState, Class<? extends Annotation> annotation) {
        StandardConfigurationContext configContext = new StandardConfigurationContext((ComponentNode)this, this.serviceLookup, null);
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), (Class)this.getFlowAnalysisRule().getClass(), (String)this.getIdentifier());){
            ReflectionUtils.invokeMethodsWithAnnotation(annotation, (Object)this.getFlowAnalysisRule(), (Object[])new Object[]{configContext});
            this.state = newState;
            this.log.debug("Successfully {} {}", (Object)newState.toString().toLowerCase(), (Object)this);
        }
        catch (Exception e) {
            Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
            SimpleProcessLogger componentLog = new SimpleProcessLogger(this.getIdentifier(), this.getFlowAnalysisRule(), (LoggingContext)new StandardLoggingContext());
            componentLog.error("Failed to invoke {} method", cause);
            this.log.error("Failed to invoke {} method of {}", new Object[]{annotation.getSimpleName(), this.getFlowAnalysisRule(), cause});
        }
    }

    public void verifyCanPerformVerification() {
        if (this.isEnabled()) {
            throw new IllegalStateException("Cannot perform verification of " + String.valueOf((Object)this) + " because Flow Analysis Rule is not fully stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigVerificationResult> verifyConfiguration(ConfigurationContext context, ComponentLog logger, ExtensionManager extensionManager) {
        ArrayList<ConfigVerificationResult> results;
        block21: {
            results = new ArrayList<ConfigVerificationResult>();
            try {
                this.verifyCanPerformVerification();
                long startNanos = System.nanoTime();
                results.addAll(super.verifyConfig(context.getProperties(), context.getAnnotationData(), null));
                long validationComplete = System.nanoTime();
                if (!results.isEmpty() && results.stream().anyMatch(result -> result.getOutcome() == ConfigVerificationResult.Outcome.FAILED)) {
                    return results;
                }
                FlowAnalysisRule flowAnalysisRule = this.getFlowAnalysisRule();
                if (flowAnalysisRule instanceof VerifiableFlowAnalysisRule) {
                    block20: {
                        logger.debug("{} is a VerifiableFlowAnalysisRule. Will perform full verification of configuration.", new Object[]{this});
                        VerifiableFlowAnalysisRule verifiable = (VerifiableFlowAnalysisRule)flowAnalysisRule;
                        boolean classpathDifferent = this.isClasspathDifferent(context.getProperties());
                        if (classpathDifferent) {
                            Bundle bundle = extensionManager.getBundle(this.getBundleCoordinate());
                            Set classpathUrls = this.getAdditionalClasspathResources(context.getProperties().keySet(), descriptor -> context.getProperty(descriptor).getValue());
                            String classloaderIsolationKey = this.getClassLoaderIsolationKey((PropertyContext)context);
                            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
                            try (InstanceClassLoader detectedClassLoader = extensionManager.createInstanceClassLoader(this.getComponentType(), this.getIdentifier(), bundle, classpathUrls, false, classloaderIsolationKey);){
                                Thread.currentThread().setContextClassLoader((ClassLoader)detectedClassLoader);
                                results.addAll(verifiable.verify(context, logger));
                                break block20;
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(currentClassLoader);
                            }
                        }
                        try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ExtensionManager)extensionManager, (Class)flowAnalysisRule.getClass(), (String)this.getIdentifier());){
                            results.addAll(verifiable.verify(context, logger));
                        }
                    }
                    long validationNanos = validationComplete - startNanos;
                    long verificationNanos = System.nanoTime() - validationComplete;
                    logger.debug("{} completed full configuration validation in {} plus {} for validation", new Object[]{this, FormatUtils.formatNanos((long)verificationNanos, (boolean)false), FormatUtils.formatNanos((long)validationNanos, (boolean)false)});
                    break block21;
                }
                logger.debug("{} is not a VerifiableFlowAnalysisRule, so will not perform full verification of configuration. Validation took {}", new Object[]{this, FormatUtils.formatNanos((long)(validationComplete - startNanos), (boolean)false)});
            }
            catch (Throwable t) {
                logger.error("Failed to perform verification of Flow Analysis Rule's configuration for {}", new Object[]{this, t});
                results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.FAILED).verificationStepName("Perform Verification").explanation("Encountered unexpected failure when attempting to perform verification: " + String.valueOf(t)).build());
            }
        }
        return results;
    }

    public Optional<ProcessGroup> getParentProcessGroup() {
        return Optional.empty();
    }
}

