/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.nifi.annotation.behavior.DynamicProperties;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.DynamicRelationship;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.flow.ComponentType;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedConfigurableComponent;
import org.apache.nifi.flow.VersionedConnection;
import org.apache.nifi.flow.VersionedControllerService;
import org.apache.nifi.flow.VersionedFlowCoordinates;
import org.apache.nifi.flow.VersionedLabel;
import org.apache.nifi.flow.VersionedPort;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedProcessor;
import org.apache.nifi.flow.VersionedPropertyDescriptor;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.registry.flow.diff.DifferenceType;
import org.apache.nifi.registry.flow.diff.FlowDifference;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedComponent;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedConnection;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedControllerService;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedProcessor;

public class FlowDifferenceFilters {
    private static final Pattern PARAMETER_REFERENCE_PATTERN = Pattern.compile("#\\{[A-Za-z0-9\\-_. ]+}");
    public static Predicate<FlowDifference> FILTER_PUBLIC_PORT_NAME_CHANGES = fd -> !FlowDifferenceFilters.isPublicPortNameChange(fd);
    public static Predicate<FlowDifference> FILTER_ADDED_REMOVED_REMOTE_PORTS = fd -> !FlowDifferenceFilters.isAddedOrRemovedRemotePort(fd);

    public static boolean isEnvironmentalChange(FlowDifference difference, VersionedProcessGroup localGroup, FlowManager flowManager) {
        return FlowDifferenceFilters.isEnvironmentalChange(difference, localGroup, flowManager, EnvironmentalChangeContext.empty());
    }

    public static boolean isEnvironmentalChange(FlowDifference difference, VersionedProcessGroup localGroup, FlowManager flowManager, EnvironmentalChangeContext context) {
        EnvironmentalChangeContext evaluatedContext = Objects.requireNonNull(context, "EnvironmentalChangeContext required");
        return FlowDifferenceFilters.isBundleChange(difference) || FlowDifferenceFilters.isSensitivePropertyDueToGhosting(difference, flowManager) || FlowDifferenceFilters.isRpgUrlChange(difference) || FlowDifferenceFilters.isAddedOrRemovedRemotePort(difference) || FlowDifferenceFilters.isPublicPortNameChange(difference) || FlowDifferenceFilters.isNewPropertyWithDefaultValue(difference, flowManager) || FlowDifferenceFilters.isNewRelationshipAutoTerminatedAndDefaulted(difference, localGroup, flowManager) || FlowDifferenceFilters.isScheduledStateNew(difference) || FlowDifferenceFilters.isLocalScheduleStateChange(difference) || FlowDifferenceFilters.isPropertyMissingFromGhostComponent(difference, flowManager) || FlowDifferenceFilters.isNewRetryConfigWithDefaultValue(difference, flowManager) || FlowDifferenceFilters.isNewZIndexLabelConfigWithDefaultValue(difference, flowManager) || FlowDifferenceFilters.isNewZIndexConnectionConfigWithDefaultValue(difference, flowManager) || FlowDifferenceFilters.isRegistryUrlChange(difference) || FlowDifferenceFilters.isParameterContextChange(difference) || FlowDifferenceFilters.isLogFileSuffixChange(difference) || FlowDifferenceFilters.isStaticPropertyRemoved(difference, flowManager) || FlowDifferenceFilters.isControllerServiceCreatedForNewProperty(difference, evaluatedContext) || FlowDifferenceFilters.isPropertyParameterizationRename(difference, evaluatedContext) || FlowDifferenceFilters.isPropertyRenameWithMatchingValue(difference, evaluatedContext) || FlowDifferenceFilters.isSelectedRelationshipChangeForNewRelationship(difference, flowManager);
    }

    public static boolean isBundleChange(FlowDifference difference) {
        return difference.getDifferenceType() == DifferenceType.BUNDLE_CHANGED;
    }

    private static boolean isSensitivePropertyDueToGhosting(FlowDifference difference, FlowManager flowManager) {
        ComponentNode componentNode;
        String componentBId;
        ComponentNode componentNode2;
        String componentAId;
        DifferenceType differenceType = difference.getDifferenceType();
        if (differenceType != DifferenceType.PROPERTY_SENSITIVITY_CHANGED && differenceType != DifferenceType.PROPERTY_ADDED) {
            return false;
        }
        VersionedComponent componentA = difference.getComponentA();
        if (componentA != null && (componentAId = componentA.getInstanceIdentifier()) != null && (componentNode2 = FlowDifferenceFilters.getComponent(flowManager, componentA.getComponentType(), componentAId)) != null && componentNode2.isExtensionMissing()) {
            return true;
        }
        VersionedComponent componentB = difference.getComponentB();
        return componentB != null && (componentBId = componentB.getInstanceIdentifier()) != null && (componentNode = FlowDifferenceFilters.getComponent(flowManager, componentB.getComponentType(), componentBId)) != null && componentNode.isExtensionMissing();
    }

    private static ComponentNode getComponent(FlowManager flowManager, ComponentType componentType, String componentId) {
        return switch (componentType) {
            case ComponentType.CONTROLLER_SERVICE -> flowManager.getControllerServiceNode(componentId);
            case ComponentType.PROCESSOR -> flowManager.getProcessorNode(componentId);
            case ComponentType.REPORTING_TASK -> flowManager.getReportingTaskNode(componentId);
            default -> null;
        };
    }

    private static ComponentNode getComponent(FlowManager flowManager, VersionedComponent component) {
        if (component instanceof InstantiatedVersionedComponent) {
            InstantiatedVersionedComponent instantiatedComponent = (InstantiatedVersionedComponent)component;
            return FlowDifferenceFilters.getComponent(flowManager, component.getComponentType(), instantiatedComponent.getInstanceIdentifier());
        }
        return null;
    }

    private static boolean supportsDynamicProperties(ConfigurableComponent component) {
        Class componentClass = component.getClass();
        return componentClass.isAnnotationPresent(DynamicProperty.class) || componentClass.isAnnotationPresent(DynamicProperties.class);
    }

    private static boolean isRegistryUrlChange(FlowDifference difference) {
        if (difference.getDifferenceType() != DifferenceType.VERSIONED_FLOW_COORDINATES_CHANGED) {
            return false;
        }
        if (!(difference.getValueA() instanceof VersionedFlowCoordinates)) {
            return false;
        }
        if (!(difference.getValueB() instanceof VersionedFlowCoordinates)) {
            return false;
        }
        VersionedFlowCoordinates coordinatesA = (VersionedFlowCoordinates)difference.getValueA();
        VersionedFlowCoordinates coordinatesB = (VersionedFlowCoordinates)difference.getValueB();
        return Objects.equals(coordinatesA.getBucketId(), coordinatesB.getBucketId()) && Objects.equals(coordinatesA.getFlowId(), coordinatesB.getFlowId()) && Objects.equals(coordinatesA.getVersion(), coordinatesB.getVersion());
    }

    public static boolean isPublicPortNameChange(FlowDifference fd) {
        VersionedPort versionedPort;
        VersionedComponent versionedComponent = fd.getComponentA();
        return fd.getDifferenceType() == DifferenceType.NAME_CHANGED && versionedComponent instanceof VersionedPort && (versionedPort = (VersionedPort)versionedComponent).isAllowRemoteAccess() != false;
    }

    public static boolean isAddedOrRemovedRemotePort(FlowDifference fd) {
        if (fd.getDifferenceType() == DifferenceType.COMPONENT_ADDED || fd.getDifferenceType() == DifferenceType.COMPONENT_REMOVED) {
            VersionedComponent component = fd.getComponentA();
            if (component == null || fd.getComponentB() instanceof InstantiatedVersionedComponent) {
                component = fd.getComponentB();
            }
            if (component.getComponentType() == ComponentType.REMOTE_INPUT_PORT || component.getComponentType() == ComponentType.REMOTE_OUTPUT_PORT) {
                return true;
            }
        }
        return false;
    }

    private static boolean isNewZIndexLabelConfigWithDefaultValue(FlowDifference fd, FlowManager flowManager) {
        Object valueA = fd.getValueA();
        if (valueA != null) {
            return false;
        }
        VersionedComponent componentB = fd.getComponentB();
        if (!(componentB instanceof VersionedLabel)) {
            return false;
        }
        VersionedLabel versionedLabel = (VersionedLabel)componentB;
        if (fd.getDifferenceType() == DifferenceType.ZINDEX_CHANGED) {
            Long zIndex = versionedLabel.getzIndex();
            if (zIndex == null) {
                return false;
            }
            return zIndex == 0L;
        }
        return false;
    }

    private static boolean isNewZIndexConnectionConfigWithDefaultValue(FlowDifference fd, FlowManager flowManager) {
        Object valueA = fd.getValueA();
        if (valueA != null) {
            return false;
        }
        VersionedComponent componentB = fd.getComponentB();
        if (!(componentB instanceof VersionedConnection)) {
            return false;
        }
        VersionedConnection versionedConnection = (VersionedConnection)componentB;
        if (fd.getDifferenceType() == DifferenceType.ZINDEX_CHANGED) {
            Long zIndex = versionedConnection.getzIndex();
            if (zIndex == null) {
                return false;
            }
            return zIndex == 0L;
        }
        return false;
    }

    private static boolean isNewRetryConfigWithDefaultValue(FlowDifference fd, FlowManager flowManager) {
        Object valueA = fd.getValueA();
        if (valueA != null) {
            return false;
        }
        VersionedComponent componentB = fd.getComponentB();
        if (!(componentB instanceof InstantiatedVersionedProcessor)) {
            return false;
        }
        DifferenceType type = fd.getDifferenceType();
        InstantiatedVersionedProcessor instantiatedProcessor = (InstantiatedVersionedProcessor)componentB;
        ProcessorNode processorNode = flowManager.getProcessorNode(instantiatedProcessor.getInstanceIdentifier());
        if (processorNode == null) {
            return false;
        }
        return switch (type) {
            case DifferenceType.RETRIED_RELATIONSHIPS_CHANGED -> processorNode.getRetriedRelationships().isEmpty();
            case DifferenceType.RETRY_COUNT_CHANGED -> {
                if (processorNode.getRetryCount() == 10) {
                    yield true;
                }
                yield false;
            }
            case DifferenceType.MAX_BACKOFF_PERIOD_CHANGED -> "10 mins".equals(processorNode.getMaxBackoffPeriod());
            case DifferenceType.BACKOFF_MECHANISM_CHANGED -> {
                if (ProcessorNode.DEFAULT_BACKOFF_MECHANISM == processorNode.getBackoffMechanism()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static boolean isNewPropertyWithDefaultValue(FlowDifference fd, FlowManager flowManager) {
        if (fd.getDifferenceType() != DifferenceType.PROPERTY_ADDED) {
            return false;
        }
        VersionedComponent componentB = fd.getComponentB();
        if (componentB instanceof InstantiatedVersionedProcessor) {
            InstantiatedVersionedProcessor instantiatedProcessor = (InstantiatedVersionedProcessor)componentB;
            ProcessorNode processorNode = flowManager.getProcessorNode(instantiatedProcessor.getInstanceIdentifier());
            return FlowDifferenceFilters.isNewPropertyWithDefaultValue(fd, (ComponentNode)processorNode);
        }
        if (componentB instanceof InstantiatedVersionedControllerService) {
            InstantiatedVersionedControllerService instantiatedControllerService = (InstantiatedVersionedControllerService)componentB;
            ControllerServiceNode controllerService = flowManager.getControllerServiceNode(instantiatedControllerService.getInstanceIdentifier());
            return FlowDifferenceFilters.isNewPropertyWithDefaultValue(fd, (ComponentNode)controllerService);
        }
        return false;
    }

    private static boolean isNewPropertyWithDefaultValue(FlowDifference fd, ComponentNode componentNode) {
        if (componentNode == null) {
            return false;
        }
        Optional optionalFieldName = fd.getFieldName();
        if (!optionalFieldName.isPresent()) {
            return false;
        }
        String fieldName = (String)optionalFieldName.get();
        PropertyDescriptor propertyDescriptor = componentNode.getPropertyDescriptor(fieldName);
        if (propertyDescriptor == null) {
            return false;
        }
        return Objects.equals(fd.getValueB(), propertyDescriptor.getDefaultValue());
    }

    public static boolean isScheduledStateNew(FlowDifference fd) {
        if (fd.getDifferenceType() != DifferenceType.SCHEDULED_STATE_CHANGED) {
            return false;
        }
        if (fd.getValueA() == null && fd.getValueB() != null) {
            return true;
        }
        return fd.getValueB() == null && fd.getValueA() != null;
    }

    public static boolean isLocalScheduleStateChange(FlowDifference fd) {
        if (fd.getDifferenceType() != DifferenceType.SCHEDULED_STATE_CHANGED) {
            return false;
        }
        if (fd.getComponentA() == null) {
            return false;
        }
        if (fd.getComponentA().getComponentType() == ComponentType.CONTROLLER_SERVICE) {
            return true;
        }
        String scheduledStateB = String.valueOf(fd.getValueB());
        String scheduledStateA = String.valueOf(fd.getValueA());
        if ("RUNNING".equals(scheduledStateB) && ("STOPPED".equals(scheduledStateA) || "ENABLED".equals(scheduledStateA))) {
            return true;
        }
        return "RUNNING".equals(scheduledStateA) && ("STOPPED".equals(scheduledStateB) || "ENABLED".equals(scheduledStateB));
    }

    public static boolean isRpgUrlChange(FlowDifference flowDifference) {
        return flowDifference.getDifferenceType() == DifferenceType.RPG_URL_CHANGED;
    }

    public static boolean isNewRelationshipAutoTerminatedAndDefaulted(FlowDifference fd, VersionedProcessGroup processGroup, FlowManager flowManager) {
        if (fd.getDifferenceType() != DifferenceType.AUTO_TERMINATED_RELATIONSHIPS_CHANGED) {
            return false;
        }
        if (!(fd.getComponentA() instanceof VersionedProcessor) || !(fd.getComponentB() instanceof InstantiatedVersionedProcessor)) {
            return false;
        }
        VersionedProcessor processorA = (VersionedProcessor)fd.getComponentA();
        VersionedProcessor processorB = (VersionedProcessor)fd.getComponentB();
        Set autoTerminatedA = FlowDifferenceFilters.replaceNull(processorA.getAutoTerminatedRelationships(), Collections.emptySet());
        Set autoTerminatedB = FlowDifferenceFilters.replaceNull(processorB.getAutoTerminatedRelationships(), Collections.emptySet());
        if (autoTerminatedB.size() < autoTerminatedA.size() || !autoTerminatedB.containsAll(autoTerminatedA)) {
            return false;
        }
        InstantiatedVersionedProcessor instantiatedVersionedProcessor = (InstantiatedVersionedProcessor)processorB;
        ProcessorNode processorNode = flowManager.getProcessorNode(instantiatedVersionedProcessor.getInstanceIdentifier());
        if (processorNode == null) {
            return false;
        }
        HashSet newlyAddedAutoTerminated = new HashSet(autoTerminatedB);
        newlyAddedAutoTerminated.removeAll(autoTerminatedA);
        for (String relationshipName : newlyAddedAutoTerminated) {
            Relationship relationship = processorNode.getRelationship(relationshipName);
            if (relationship == null) {
                return false;
            }
            boolean defaultAutoTerminated = relationship.isAutoTerminated();
            if (!defaultAutoTerminated) {
                return false;
            }
            if (!FlowDifferenceFilters.hasConnection(processGroup, processorA, relationshipName)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSelectedRelationshipChangeForNewRelationship(FlowDifference difference, FlowManager flowManager) {
        Class processorClass;
        if (difference.getDifferenceType() != DifferenceType.SELECTED_RELATIONSHIPS_CHANGED) {
            return false;
        }
        VersionedComponent versionedComponent = difference.getComponentA();
        if (!(versionedComponent instanceof VersionedConnection)) {
            return false;
        }
        VersionedConnection connectionA = (VersionedConnection)versionedComponent;
        VersionedComponent versionedComponent2 = difference.getComponentB();
        if (!(versionedComponent2 instanceof InstantiatedVersionedConnection)) {
            return false;
        }
        InstantiatedVersionedConnection connectionB = (InstantiatedVersionedConnection)versionedComponent2;
        HashSet selectedA = new HashSet(FlowDifferenceFilters.replaceNull(connectionA.getSelectedRelationships(), Collections.emptySet()));
        HashSet selectedB = new HashSet(FlowDifferenceFilters.replaceNull(connectionB.getSelectedRelationships(), Collections.emptySet()));
        HashSet newlySelected = new HashSet(selectedB);
        newlySelected.removeAll(selectedA);
        if (newlySelected.isEmpty()) {
            return false;
        }
        HashSet removedRelationships = new HashSet(selectedA);
        removedRelationships.removeAll(selectedB);
        if (flowManager == null) {
            return false;
        }
        String connectionInstanceId = connectionB.getInstanceIdentifier();
        String connectionGroupId = connectionB.getInstanceGroupId();
        if (connectionInstanceId == null || connectionGroupId == null) {
            return false;
        }
        ProcessGroup processGroup = flowManager.getGroup(connectionGroupId);
        if (processGroup == null) {
            return false;
        }
        Connection connection = processGroup.getConnection(connectionInstanceId);
        if (connection == null) {
            return false;
        }
        Connectable source = connection.getSource();
        if (source == null || source.getConnectableType() != ConnectableType.PROCESSOR) {
            return false;
        }
        ProcessorNode processorNode = flowManager.getProcessorNode(source.getIdentifier());
        if (processorNode == null) {
            return false;
        }
        Processor processor = processorNode.getProcessor();
        if (processor != null && (processorClass = processor.getClass()).isAnnotationPresent(DynamicRelationship.class)) {
            return false;
        }
        for (String relationshipName : newlySelected) {
            Relationship relationship = processorNode.getRelationship(relationshipName);
            if (relationship == null) {
                return false;
            }
            if (processorNode.isAutoTerminated(relationship)) {
                return false;
            }
            Set<Connection> relationshipConnections = FlowDifferenceFilters.replaceNull(processorNode.getConnections(relationship), Collections.emptySet());
            for (Connection relationshipConnection : relationshipConnections) {
                if (relationshipConnection.getIdentifier().equals(connection.getIdentifier())) continue;
                return false;
            }
        }
        for (String removedRelationshipName : removedRelationships) {
            Relationship removedRelationship = processorNode.getRelationship(removedRelationshipName);
            if (removedRelationship == null) continue;
            return false;
        }
        return true;
    }

    private static <T> T replaceNull(T value, T replacement) {
        return value == null ? replacement : value;
    }

    public static boolean isStaticPropertyRemoved(FlowDifference difference, FlowManager flowManager) {
        DifferenceType differenceType = difference.getDifferenceType();
        if (differenceType != DifferenceType.PROPERTY_REMOVED) {
            return false;
        }
        Optional fieldName = difference.getFieldName();
        if (!fieldName.isPresent()) {
            return false;
        }
        VersionedComponent componentB = difference.getComponentB();
        if (componentB instanceof InstantiatedVersionedProcessor) {
            InstantiatedVersionedProcessor instantiatedProcessor = (InstantiatedVersionedProcessor)componentB;
            ProcessorNode processorNode = flowManager.getProcessorNode(instantiatedProcessor.getInstanceIdentifier());
            return FlowDifferenceFilters.isStaticPropertyRemoved((String)fieldName.get(), (ComponentNode)processorNode);
        }
        if (componentB instanceof InstantiatedVersionedControllerService) {
            InstantiatedVersionedControllerService instantiatedControllerService = (InstantiatedVersionedControllerService)componentB;
            ControllerServiceNode controllerService = flowManager.getControllerServiceNode(instantiatedControllerService.getInstanceIdentifier());
            return FlowDifferenceFilters.isStaticPropertyRemoved((String)fieldName.get(), (ComponentNode)controllerService);
        }
        return false;
    }

    private static boolean isStaticPropertyRemoved(String propertyName, ComponentNode componentNode) {
        if (componentNode == null) {
            return false;
        }
        ConfigurableComponent configurableComponent = componentNode.getComponent();
        if (configurableComponent == null) {
            return false;
        }
        boolean staticallyDefined = configurableComponent.getPropertyDescriptors().stream().map(PropertyDescriptor::getName).anyMatch(propertyName::equals);
        if (staticallyDefined) {
            return false;
        }
        return !FlowDifferenceFilters.supportsDynamicProperties(configurableComponent);
    }

    public static boolean isPropertyMissingFromGhostComponent(FlowDifference difference, FlowManager flowManager) {
        if (difference.getDifferenceType() != DifferenceType.PROPERTY_REMOVED) {
            return false;
        }
        Optional fieldName = difference.getFieldName();
        if (!fieldName.isPresent()) {
            return false;
        }
        VersionedComponent componentB = difference.getComponentB();
        if (componentB instanceof InstantiatedVersionedProcessor) {
            ProcessorNode procNode = flowManager.getProcessorNode(componentB.getInstanceIdentifier());
            return procNode.isExtensionMissing() && FlowDifferenceFilters.isPropertyPresent((ComponentNode)procNode, difference);
        }
        if (componentB instanceof InstantiatedVersionedControllerService) {
            ControllerServiceNode serviceNode = flowManager.getControllerServiceNode(componentB.getInstanceIdentifier());
            return serviceNode.isExtensionMissing() && FlowDifferenceFilters.isPropertyPresent((ComponentNode)serviceNode, difference);
        }
        return false;
    }

    private static boolean isPropertyPresent(ComponentNode componentNode, FlowDifference difference) {
        if (componentNode == null) {
            return false;
        }
        Optional fieldNameOptional = difference.getFieldName();
        if (!fieldNameOptional.isPresent()) {
            return false;
        }
        PropertyDescriptor descriptor = componentNode.getPropertyDescriptor((String)fieldNameOptional.get());
        String rawPropertyValue = componentNode.getRawPropertyValue(descriptor);
        return rawPropertyValue != null;
    }

    private static boolean hasConnection(VersionedProcessGroup processGroup, VersionedProcessor processor, String relationship) {
        for (VersionedConnection connection : processGroup.getConnections()) {
            if (!connection.getSource().getId().equals(processor.getIdentifier()) || !connection.getSelectedRelationships().contains(relationship)) continue;
            return true;
        }
        return false;
    }

    private static boolean isParameterContextChange(FlowDifference flowDifference) {
        return flowDifference.getDifferenceType() == DifferenceType.PARAMETER_CONTEXT_CHANGED;
    }

    private static boolean isLogFileSuffixChange(FlowDifference flowDifference) {
        return flowDifference.getDifferenceType() == DifferenceType.LOG_FILE_SUFFIX_CHANGED;
    }

    public static EnvironmentalChangeContext buildEnvironmentalChangeContext(Collection<FlowDifference> differences, FlowManager flowManager) {
        String componentId;
        if (differences == null || differences.isEmpty() || flowManager == null) {
            return EnvironmentalChangeContext.empty();
        }
        HashMap parameterizedAddsByComponent = new HashMap();
        HashMap<String, List> parameterizationRemovalsByComponent = new HashMap<String, List>();
        HashMap<String, List> controllerServicePropertyAddsByValue = new HashMap<String, List>();
        HashMap propertyAddsByComponent = new HashMap();
        HashMap<String, List> propertyRemovalsByComponent = new HashMap<String, List>();
        for (FlowDifference flowDifference : differences) {
            if (flowDifference.getDifferenceType() == DifferenceType.PROPERTY_ADDED) {
                Optional<String> optional;
                Optional<String> optional2 = FlowDifferenceFilters.getComponentInstanceIdentifier(flowDifference);
                if (optional2.isPresent()) {
                    PropertyDiffInfo propertyDiffInfo = new PropertyDiffInfo(FlowDifferenceFilters.getPropertyValue(flowDifference, false), flowDifference);
                    propertyAddsByComponent.computeIfAbsent(optional2.get(), key -> new ArrayList()).add(propertyDiffInfo);
                }
                if ((optional = FlowDifferenceFilters.getPropertyValue(flowDifference, false)).isPresent() && !FlowDifferenceFilters.isParameterReference(optional.get()) && FlowDifferenceFilters.isControllerServiceProperty(flowDifference, flowManager)) {
                    controllerServicePropertyAddsByValue.computeIfAbsent(optional.get(), key -> new ArrayList()).add(new PropertyDiffInfo(optional, flowDifference));
                }
            }
            if (flowDifference.getDifferenceType() == DifferenceType.PROPERTY_REMOVED) {
                Optional<String> optional = FlowDifferenceFilters.getComponentInstanceIdentifier(flowDifference);
                if (!optional.isPresent()) continue;
                PropertyDiffInfo propertyDiffInfo = new PropertyDiffInfo(FlowDifferenceFilters.getPropertyValue(flowDifference, true), flowDifference);
                propertyRemovalsByComponent.computeIfAbsent(optional.get(), key -> new ArrayList()).add(propertyDiffInfo);
                continue;
            }
            if (flowDifference.getDifferenceType() != DifferenceType.PROPERTY_PARAMETERIZED && flowDifference.getDifferenceType() != DifferenceType.PROPERTY_PARAMETERIZATION_REMOVED) continue;
            Optional optional = flowDifference.getFieldName();
            Optional<String> optional3 = FlowDifferenceFilters.getComponentInstanceIdentifier(flowDifference);
            if (optional.isEmpty() || optional3.isEmpty()) continue;
            componentId = optional3.get();
            Optional<String> propertyValue = flowDifference.getDifferenceType() == DifferenceType.PROPERTY_PARAMETERIZED ? FlowDifferenceFilters.getParameterReferenceValue(flowDifference, false) : FlowDifferenceFilters.getParameterReferenceValue(flowDifference, true);
            PropertyDiffInfo diffInfo2 = new PropertyDiffInfo(propertyValue, flowDifference);
            if (flowDifference.getDifferenceType() == DifferenceType.PROPERTY_PARAMETERIZED) {
                parameterizedAddsByComponent.computeIfAbsent(componentId, key -> new ArrayList()).add(diffInfo2);
                continue;
            }
            parameterizationRemovalsByComponent.computeIfAbsent(componentId, key -> new ArrayList()).add(diffInfo2);
        }
        HashSet<String> serviceIdsWithMatchingAdditions = new HashSet<String>();
        for (FlowDifference flowDifference : differences) {
            if (flowDifference.getDifferenceType() != DifferenceType.COMPONENT_ADDED) continue;
            for (String candidateId : FlowDifferenceFilters.getControllerServiceIdentifiers(flowDifference)) {
                if (!controllerServicePropertyAddsByValue.containsKey(candidateId)) continue;
                serviceIdsWithMatchingAdditions.add(candidateId);
            }
        }
        HashSet<FlowDifference> hashSet = new HashSet<FlowDifference>();
        for (Map.Entry entry : parameterizationRemovalsByComponent.entrySet()) {
            componentId = (String)entry.getKey();
            List removals = (List)entry.getValue();
            ArrayList additions = new ArrayList(parameterizedAddsByComponent.getOrDefault(componentId, Collections.emptyList()));
            if (additions.isEmpty()) continue;
            for (PropertyDiffInfo removalInfo : removals) {
                Optional<String> removalValue = removalInfo.propertyValue();
                if (removalValue.isPresent() && !FlowDifferenceFilters.isParameterReference(removalValue.get())) continue;
                PropertyDiffInfo matchingAddition = null;
                Iterator iterator = additions.iterator();
                while (iterator.hasNext()) {
                    PropertyDiffInfo additionInfo = (PropertyDiffInfo)iterator.next();
                    Optional<String> additionValue = additionInfo.propertyValue();
                    if (additionValue.isPresent() && !FlowDifferenceFilters.isParameterReference(additionValue.get()) || !FlowDifferenceFilters.valuesMatch(removalValue, additionValue)) continue;
                    matchingAddition = additionInfo;
                    iterator.remove();
                    break;
                }
                if (matchingAddition == null) continue;
                hashSet.add(removalInfo.difference());
                hashSet.add(matchingAddition.difference());
            }
        }
        HashSet<FlowDifference> hashSet2 = new HashSet<FlowDifference>();
        for (Map.Entry entry : propertyRemovalsByComponent.entrySet()) {
            String componentId2 = (String)entry.getKey();
            List removals = (List)entry.getValue();
            ArrayList additions = new ArrayList(propertyAddsByComponent.getOrDefault(componentId2, Collections.emptyList()));
            if (additions.isEmpty()) continue;
            for (PropertyDiffInfo removalInfo : removals) {
                String additionField;
                String removalField;
                Optional<String> removalValue = removalInfo.propertyValue();
                if (removalValue.isEmpty()) continue;
                PropertyDiffInfo matchingAddition = null;
                Iterator iterator = additions.iterator();
                while (iterator.hasNext()) {
                    PropertyDiffInfo additionInfo = (PropertyDiffInfo)iterator.next();
                    Optional<String> additionValue = additionInfo.propertyValue();
                    if (additionValue.isEmpty() || !FlowDifferenceFilters.valuesMatch(removalValue, additionValue)) continue;
                    matchingAddition = additionInfo;
                    iterator.remove();
                    break;
                }
                if (matchingAddition == null || Objects.equals(removalField = (String)removalInfo.difference().getFieldName().orElse(null), additionField = (String)matchingAddition.difference().getFieldName().orElse(null))) continue;
                hashSet2.add(removalInfo.difference());
                hashSet2.add(matchingAddition.difference());
            }
        }
        if (serviceIdsWithMatchingAdditions.isEmpty() && hashSet.isEmpty() && hashSet2.isEmpty()) {
            return EnvironmentalChangeContext.empty();
        }
        return new EnvironmentalChangeContext(serviceIdsWithMatchingAdditions, hashSet, hashSet2);
    }

    public static boolean isControllerServiceCreatedForNewProperty(FlowDifference difference, EnvironmentalChangeContext context) {
        EnvironmentalChangeContext evaluatedContext = Objects.requireNonNull(context, "EnvironmentalChangeContext required");
        return FlowDifferenceFilters.isControllerServiceCreatedForNewPropertyInternal(difference, evaluatedContext);
    }

    private static boolean isControllerServiceCreatedForNewPropertyInternal(FlowDifference difference, EnvironmentalChangeContext context) {
        if (context.serviceIdsCreatedForNewProperties().isEmpty()) {
            return false;
        }
        if (difference.getDifferenceType() == DifferenceType.PROPERTY_ADDED) {
            return FlowDifferenceFilters.getPropertyValue(difference, false).filter(value -> context.serviceIdsCreatedForNewProperties().contains(value)).isPresent();
        }
        if (difference.getDifferenceType() == DifferenceType.COMPONENT_ADDED) {
            for (String candidateId : FlowDifferenceFilters.getControllerServiceIdentifiers(difference)) {
                if (!context.serviceIdsCreatedForNewProperties().contains(candidateId)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static Set<String> getControllerServiceIdentifiers(FlowDifference difference) {
        HashSet<String> identifiers = new HashSet<String>();
        FlowDifferenceFilters.addControllerServiceIdentifiers(difference.getComponentB(), identifiers);
        FlowDifferenceFilters.addControllerServiceIdentifiers(difference.getComponentA(), identifiers);
        return identifiers;
    }

    private static void addControllerServiceIdentifiers(VersionedComponent component, Set<String> identifiers) {
        String identifier;
        InstantiatedVersionedControllerService instantiatedControllerService;
        String instanceIdentifier;
        if (component == null) {
            return;
        }
        if (component instanceof InstantiatedVersionedControllerService && (instanceIdentifier = (instantiatedControllerService = (InstantiatedVersionedControllerService)component).getInstanceIdentifier()) != null) {
            identifiers.add(instanceIdentifier);
        }
        if (component instanceof VersionedControllerService && (identifier = component.getIdentifier()) != null) {
            identifiers.add(identifier);
        }
    }

    public static boolean isPropertyParameterizationRename(FlowDifference difference, EnvironmentalChangeContext context) {
        EnvironmentalChangeContext evaluatedContext = Objects.requireNonNull(context, "EnvironmentalChangeContext required");
        return evaluatedContext.parameterizedPropertyRenames().isEmpty() ? false : evaluatedContext.parameterizedPropertyRenames().contains(difference);
    }

    public static boolean isPropertyRenameWithMatchingValue(FlowDifference difference, EnvironmentalChangeContext context) {
        EnvironmentalChangeContext evaluatedContext = Objects.requireNonNull(context, "EnvironmentalChangeContext required");
        return evaluatedContext.propertyRenamesWithMatchingValues().isEmpty() ? false : evaluatedContext.propertyRenamesWithMatchingValues().contains(difference);
    }

    private static Optional<String> getComponentInstanceIdentifier(FlowDifference difference) {
        Optional<String> identifierB = FlowDifferenceFilters.getComponentInstanceIdentifier(difference.getComponentB());
        if (identifierB.isPresent()) {
            return identifierB;
        }
        return FlowDifferenceFilters.getComponentInstanceIdentifier(difference.getComponentA());
    }

    private static Optional<String> getComponentInstanceIdentifier(VersionedComponent component) {
        String instanceId;
        if (component == null) {
            return Optional.empty();
        }
        if (component instanceof InstantiatedVersionedComponent && (instanceId = ((InstantiatedVersionedComponent)component).getInstanceIdentifier()) != null) {
            return Optional.of(instanceId);
        }
        return Optional.ofNullable(component.getIdentifier());
    }

    private static Optional<String> getParameterReferenceValue(FlowDifference difference, boolean fromComponentA) {
        Optional<String> parameterReference;
        VersionedComponent primaryComponent = fromComponentA ? difference.getComponentA() : difference.getComponentB();
        VersionedComponent secondaryComponent = fromComponentA ? difference.getComponentB() : difference.getComponentA();
        Map<String, String> primaryProperties = FlowDifferenceFilters.getProperties(primaryComponent);
        if (primaryProperties.isEmpty()) {
            parameterReference = Optional.empty();
        } else {
            String fieldName;
            String propertyValue;
            Map<String, String> secondaryProperties = FlowDifferenceFilters.getProperties(secondaryComponent);
            Optional<Object> resolvedReference = Optional.empty();
            Optional fieldNameOptional = difference.getFieldName();
            if (fieldNameOptional.isPresent() && (propertyValue = primaryProperties.get(fieldName = (String)fieldNameOptional.get())) != null) {
                resolvedReference = Optional.of(propertyValue);
            }
            if (resolvedReference.isEmpty()) {
                for (Map.Entry<String, String> entry : primaryProperties.entrySet()) {
                    String propertyName = entry.getKey();
                    String propertyValue2 = entry.getValue();
                    if (!FlowDifferenceFilters.isParameterReference(propertyValue2) || secondaryProperties.containsKey(propertyName)) continue;
                    resolvedReference = Optional.of(propertyValue2);
                    break;
                }
            }
            parameterReference = resolvedReference;
        }
        return parameterReference;
    }

    private static Optional<String> getPropertyValue(FlowDifference difference, boolean fromComponentA) {
        Object differenceValue;
        Optional fieldNameOptional = difference.getFieldName();
        if (fieldNameOptional.isEmpty()) {
            return Optional.empty();
        }
        VersionedComponent component = fromComponentA ? difference.getComponentA() : difference.getComponentB();
        Map<String, String> properties = FlowDifferenceFilters.getProperties(component);
        String propertyValue = properties.get(fieldNameOptional.get());
        if (propertyValue != null) {
            return Optional.of(propertyValue);
        }
        Object object = differenceValue = fromComponentA ? difference.getValueA() : difference.getValueB();
        if (differenceValue instanceof String) {
            String stringValue = (String)differenceValue;
            return Optional.of(stringValue);
        }
        return Optional.empty();
    }

    private static Optional<PropertyDescriptor> getComponentPropertyDescriptor(FlowManager flowManager, FlowDifference difference, String propertyName) {
        ComponentNode componentNode = Optional.ofNullable(FlowDifferenceFilters.getComponent(flowManager, difference.getComponentB())).orElseGet(() -> FlowDifferenceFilters.getComponent(flowManager, difference.getComponentA()));
        if (componentNode == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(componentNode.getPropertyDescriptor(propertyName));
    }

    private static Optional<VersionedPropertyDescriptor> getVersionedPropertyDescriptor(FlowDifference difference, boolean fromComponentA) {
        VersionedComponent component = fromComponentA ? difference.getComponentA() : difference.getComponentB();
        Map<String, VersionedPropertyDescriptor> descriptors = FlowDifferenceFilters.getPropertyDescriptors(component);
        if (descriptors == null || descriptors.isEmpty()) {
            return Optional.empty();
        }
        Optional fieldNameOptional = difference.getFieldName();
        if (fieldNameOptional.isEmpty()) {
            return Optional.empty();
        }
        String fieldName = (String)fieldNameOptional.get();
        VersionedPropertyDescriptor descriptor = descriptors.get(fieldName);
        if (descriptor == null) {
            descriptor = descriptors.values().stream().filter(candidate -> fieldName.equals(candidate.getName()) || fieldName.equals(candidate.getDisplayName())).findFirst().orElse(null);
        }
        return Optional.ofNullable(descriptor);
    }

    private static Map<String, VersionedPropertyDescriptor> getPropertyDescriptors(VersionedComponent component) {
        Map descriptors;
        if (component == null) {
            descriptors = Collections.emptyMap();
        } else if (component instanceof VersionedConfigurableComponent) {
            VersionedConfigurableComponent configurableComponent = (VersionedConfigurableComponent)component;
            descriptors = configurableComponent.getPropertyDescriptors();
        } else if (component instanceof VersionedProcessor) {
            VersionedProcessor processor = (VersionedProcessor)component;
            descriptors = processor.getPropertyDescriptors();
        } else if (component instanceof VersionedControllerService) {
            VersionedControllerService controllerService = (VersionedControllerService)component;
            descriptors = controllerService.getPropertyDescriptors();
        } else {
            descriptors = Collections.emptyMap();
        }
        return descriptors == null ? Collections.emptyMap() : descriptors;
    }

    private static Map<String, String> getProperties(VersionedComponent component) {
        Map properties;
        if (component == null) {
            properties = Collections.emptyMap();
        } else if (component instanceof VersionedConfigurableComponent) {
            VersionedConfigurableComponent configurableComponent = (VersionedConfigurableComponent)component;
            properties = configurableComponent.getProperties();
        } else if (component instanceof VersionedProcessor) {
            VersionedProcessor processor = (VersionedProcessor)component;
            properties = processor.getProperties();
        } else if (component instanceof VersionedControllerService) {
            VersionedControllerService controllerService = (VersionedControllerService)component;
            properties = controllerService.getProperties();
        } else {
            properties = Collections.emptyMap();
        }
        return properties == null ? Collections.emptyMap() : properties;
    }

    private static boolean isControllerServiceProperty(FlowDifference difference, FlowManager flowManager) {
        Optional fieldNameOptional = difference.getFieldName();
        if (fieldNameOptional.isEmpty()) {
            return false;
        }
        String propertyName = (String)fieldNameOptional.get();
        Optional<PropertyDescriptor> componentDescriptor = FlowDifferenceFilters.getComponentPropertyDescriptor(flowManager, difference, propertyName);
        if (componentDescriptor.isPresent()) {
            PropertyDescriptor descriptor = componentDescriptor.get();
            return !descriptor.isDynamic() && descriptor.getControllerServiceDefinition() != null;
        }
        Optional<VersionedPropertyDescriptor> versionedDescriptor = FlowDifferenceFilters.getVersionedPropertyDescriptor(difference, false);
        if (versionedDescriptor.isPresent()) {
            VersionedPropertyDescriptor descriptor = versionedDescriptor.get();
            return Boolean.TRUE.equals(descriptor.getIdentifiesControllerService());
        }
        return false;
    }

    private static boolean valuesMatch(Optional<String> first, Optional<String> second) {
        return first.isPresent() && second.isPresent() && first.get().equals(second.get());
    }

    private static boolean isParameterReference(String propertyValue) {
        return propertyValue != null && PARAMETER_REFERENCE_PATTERN.matcher(propertyValue).matches();
    }

    public static final class EnvironmentalChangeContext {
        private static final EnvironmentalChangeContext EMPTY = new EnvironmentalChangeContext(Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        private final Set<String> serviceIdsCreatedForNewProperties;
        private final Set<FlowDifference> parameterizedPropertyRenames;
        private final Set<FlowDifference> propertyRenamesWithMatchingValues;

        private EnvironmentalChangeContext(Set<String> serviceIdsCreatedForNewProperties, Set<FlowDifference> parameterizedPropertyRenames, Set<FlowDifference> propertyRenamesWithMatchingValues) {
            this.serviceIdsCreatedForNewProperties = Collections.unmodifiableSet(new HashSet<String>(serviceIdsCreatedForNewProperties));
            this.parameterizedPropertyRenames = Collections.unmodifiableSet(new HashSet<FlowDifference>(parameterizedPropertyRenames));
            this.propertyRenamesWithMatchingValues = Collections.unmodifiableSet(new HashSet<FlowDifference>(propertyRenamesWithMatchingValues));
        }

        static EnvironmentalChangeContext empty() {
            return EMPTY;
        }

        Set<String> serviceIdsCreatedForNewProperties() {
            return this.serviceIdsCreatedForNewProperties;
        }

        Set<FlowDifference> parameterizedPropertyRenames() {
            return this.parameterizedPropertyRenames;
        }

        Set<FlowDifference> propertyRenamesWithMatchingValues() {
            return this.propertyRenamesWithMatchingValues;
        }
    }

    private static final class PropertyDiffInfo {
        private final Optional<String> propertyValue;
        private final FlowDifference difference;

        private PropertyDiffInfo(Optional<String> propertyValue, FlowDifference difference) {
            this.propertyValue = propertyValue;
            this.difference = difference;
        }

        Optional<String> propertyValue() {
            return this.propertyValue;
        }

        FlowDifference difference() {
            return this.difference;
        }
    }
}

