/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter;

import java.util.Objects;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.parameter.ParameterValueMapper;
import org.apache.nifi.registry.flow.mapping.SensitiveValueEncryptor;

public class StandardParameterValueMapper
implements ParameterValueMapper {
    static final String PROVIDED_MAPPING = "provided:parameter";
    private static final String ENCRYPTED_FORMAT = "enc{%s}";
    private final SensitiveValueEncryptor sensitiveValueEncryptor;

    public StandardParameterValueMapper(SensitiveValueEncryptor sensitiveValueEncryptor) {
        this.sensitiveValueEncryptor = sensitiveValueEncryptor;
    }

    @Override
    public String getMapped(Parameter parameter, String value) {
        String mapped;
        Objects.requireNonNull(parameter, "Parameter required");
        ParameterDescriptor descriptor = parameter.getDescriptor();
        if (value == null) {
            mapped = null;
        } else if (parameter.isProvided()) {
            mapped = PROVIDED_MAPPING;
        } else if (descriptor.isSensitive()) {
            if (this.sensitiveValueEncryptor == null) {
                mapped = value;
            } else {
                String encrypted = this.sensitiveValueEncryptor.encrypt(value);
                mapped = ENCRYPTED_FORMAT.formatted(encrypted);
            }
        } else {
            mapped = value;
        }
        return mapped;
    }
}

