/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.logging;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.logging.GroupedComponent;
import org.apache.nifi.logging.LoggingContext;

public class StandardLoggingContext
implements LoggingContext {
    private static final String KEY = "logFileSuffix";
    private volatile GroupedComponent component;

    public StandardLoggingContext() {
        this.component = null;
    }

    public StandardLoggingContext(GroupedComponent component) {
        this.component = Objects.requireNonNull(component, "Group Component required");
    }

    @Override
    public Map<String, String> getAttributes() {
        ProcessGroup processGroup;
        Map<Object, Object> attributes = this.component == null ? Map.of() : ((processGroup = this.component.getProcessGroup()) == null ? Map.of() : processGroup.getLoggingAttributes());
        return attributes;
    }

    @Override
    public Optional<String> getLogFileSuffix() {
        if (this.component != null) {
            return this.getSuffix(this.component.getProcessGroup());
        }
        return Optional.empty();
    }

    @Override
    public String getDiscriminatorKey() {
        return KEY;
    }

    private Optional<String> getSuffix(ProcessGroup group) {
        if (group == null) {
            return Optional.empty();
        }
        if (group.getLogFileSuffix() != null && !group.getLogFileSuffix().isEmpty()) {
            return Optional.of(group.getLogFileSuffix());
        }
        if (group.isRootGroup()) {
            return Optional.empty();
        }
        return this.getSuffix(group.getParent());
    }

    public void setComponent(GroupedComponent component) {
        this.component = component;
    }
}

