/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.logging;

import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogMessage;
import org.apache.nifi.logging.LogObserver;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ComponentType;
import org.apache.nifi.reporting.Severity;

public class ControllerServiceLogObserver
implements LogObserver {
    private final BulletinRepository bulletinRepository;
    private final ControllerServiceNode serviceNode;

    public ControllerServiceLogObserver(BulletinRepository bulletinRepository, ControllerServiceNode serviceNode) {
        this.bulletinRepository = bulletinRepository;
        this.serviceNode = serviceNode;
    }

    public void onLogMessage(LogMessage message) {
        String bulletinLevel = message.getLogLevel() == LogLevel.WARN ? Severity.WARNING.name() : message.getLogLevel().toString();
        ProcessGroup pg = this.serviceNode.getProcessGroup();
        String groupId = pg == null ? null : pg.getIdentifier();
        String groupName = pg == null ? null : pg.getName();
        Bulletin bulletin = BulletinFactory.createBulletin((String)groupId, (String)groupName, (String)this.serviceNode.getIdentifier(), (ComponentType)ComponentType.CONTROLLER_SERVICE, (String)this.serviceNode.getName(), (String)"Log Message", (String)bulletinLevel, (String)message.getMessage(), (Throwable)message.getThrowable());
        this.bulletinRepository.addBulletin(bulletin);
    }

    public String getComponentDescription() {
        return this.serviceNode.toString();
    }
}

