/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.state;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.components.state.StateMap;

public class StandardStateMap
implements StateMap {
    private final Map<String, String> stateValues;
    private final Optional<String> stateVersion;

    public StandardStateMap(Map<String, String> stateValues, Optional<String> stateVersion) {
        this.stateValues = Collections.unmodifiableMap(stateValues == null ? Collections.emptyMap() : stateValues);
        this.stateVersion = stateVersion;
    }

    public Optional<String> getStateVersion() {
        return this.stateVersion;
    }

    public String get(String key) {
        return this.stateValues.get(key);
    }

    public Map<String, String> toMap() {
        return this.stateValues;
    }

    public String toString() {
        return "StandardStateMap[version=" + String.valueOf(this.stateVersion) + ", values=" + String.valueOf(this.stateValues) + "]";
    }
}

