/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.nifi.annotation.behavior.DynamicProperties;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.flow.ComponentType;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedConnection;
import org.apache.nifi.flow.VersionedFlowCoordinates;
import org.apache.nifi.flow.VersionedLabel;
import org.apache.nifi.flow.VersionedPort;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedProcessor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.registry.flow.diff.DifferenceType;
import org.apache.nifi.registry.flow.diff.FlowDifference;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedComponent;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedControllerService;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedProcessor;

public class FlowDifferenceFilters {
    public static Predicate<FlowDifference> FILTER_PUBLIC_PORT_NAME_CHANGES = fd -> !FlowDifferenceFilters.isPublicPortNameChange(fd);
    public static Predicate<FlowDifference> FILTER_ADDED_REMOVED_REMOTE_PORTS = fd -> !FlowDifferenceFilters.isAddedOrRemovedRemotePort(fd);

    public static boolean isEnvironmentalChange(FlowDifference difference, VersionedProcessGroup localGroup, FlowManager flowManager) {
        return difference.getDifferenceType() == DifferenceType.BUNDLE_CHANGED || FlowDifferenceFilters.isSensitivePropertyDueToGhosting(difference, flowManager) || FlowDifferenceFilters.isRpgUrlChange(difference) || FlowDifferenceFilters.isAddedOrRemovedRemotePort(difference) || FlowDifferenceFilters.isPublicPortNameChange(difference) || FlowDifferenceFilters.isNewPropertyWithDefaultValue(difference, flowManager) || FlowDifferenceFilters.isNewRelationshipAutoTerminatedAndDefaulted(difference, localGroup, flowManager) || FlowDifferenceFilters.isScheduledStateNew(difference) || FlowDifferenceFilters.isLocalScheduleStateChange(difference) || FlowDifferenceFilters.isPropertyMissingFromGhostComponent(difference, flowManager) || FlowDifferenceFilters.isNewRetryConfigWithDefaultValue(difference, flowManager) || FlowDifferenceFilters.isNewZIndexLabelConfigWithDefaultValue(difference, flowManager) || FlowDifferenceFilters.isNewZIndexConnectionConfigWithDefaultValue(difference, flowManager) || FlowDifferenceFilters.isRegistryUrlChange(difference) || FlowDifferenceFilters.isParameterContextChange(difference) || FlowDifferenceFilters.isLogFileSuffixChange(difference) || FlowDifferenceFilters.isStaticPropertyRemoved(difference, flowManager);
    }

    private static boolean isSensitivePropertyDueToGhosting(FlowDifference difference, FlowManager flowManager) {
        ComponentNode componentNode;
        ComponentNode componentNode2;
        DifferenceType differenceType = difference.getDifferenceType();
        if (differenceType != DifferenceType.PROPERTY_SENSITIVITY_CHANGED && differenceType != DifferenceType.PROPERTY_ADDED) {
            return false;
        }
        String componentAId = difference.getComponentA().getInstanceIdentifier();
        if (componentAId != null && (componentNode2 = FlowDifferenceFilters.getComponent(flowManager, difference.getComponentA().getComponentType(), componentAId)) != null && componentNode2.isExtensionMissing()) {
            return true;
        }
        String componentBId = difference.getComponentB().getInstanceIdentifier();
        return componentBId != null && (componentNode = FlowDifferenceFilters.getComponent(flowManager, difference.getComponentA().getComponentType(), componentBId)) != null && componentNode.isExtensionMissing();
    }

    private static ComponentNode getComponent(FlowManager flowManager, ComponentType componentType, String componentId) {
        return switch (componentType) {
            case ComponentType.CONTROLLER_SERVICE -> flowManager.getControllerServiceNode(componentId);
            case ComponentType.PROCESSOR -> flowManager.getProcessorNode(componentId);
            case ComponentType.REPORTING_TASK -> flowManager.getReportingTaskNode(componentId);
            default -> null;
        };
    }

    private static boolean supportsDynamicProperties(ConfigurableComponent component, String propertyName) {
        PropertyDescriptor descriptor = component.getPropertyDescriptor(propertyName);
        if (descriptor != null && descriptor.isDynamic()) {
            return true;
        }
        Class componentClass = component.getClass();
        return componentClass.isAnnotationPresent(DynamicProperty.class) || componentClass.isAnnotationPresent(DynamicProperties.class);
    }

    private static boolean isRegistryUrlChange(FlowDifference difference) {
        if (difference.getDifferenceType() != DifferenceType.VERSIONED_FLOW_COORDINATES_CHANGED) {
            return false;
        }
        if (!(difference.getValueA() instanceof VersionedFlowCoordinates)) {
            return false;
        }
        if (!(difference.getValueB() instanceof VersionedFlowCoordinates)) {
            return false;
        }
        VersionedFlowCoordinates coordinatesA = (VersionedFlowCoordinates)difference.getValueA();
        VersionedFlowCoordinates coordinatesB = (VersionedFlowCoordinates)difference.getValueB();
        return Objects.equals(coordinatesA.getBucketId(), coordinatesB.getBucketId()) && Objects.equals(coordinatesA.getFlowId(), coordinatesB.getFlowId()) && Objects.equals(coordinatesA.getVersion(), coordinatesB.getVersion());
    }

    public static boolean isPublicPortNameChange(FlowDifference fd) {
        VersionedPort versionedPort;
        VersionedComponent versionedComponent = fd.getComponentA();
        return fd.getDifferenceType() == DifferenceType.NAME_CHANGED && versionedComponent instanceof VersionedPort && (versionedPort = (VersionedPort)versionedComponent).isAllowRemoteAccess() != false;
    }

    public static boolean isAddedOrRemovedRemotePort(FlowDifference fd) {
        if (fd.getDifferenceType() == DifferenceType.COMPONENT_ADDED || fd.getDifferenceType() == DifferenceType.COMPONENT_REMOVED) {
            VersionedComponent component = fd.getComponentA();
            if (component == null || fd.getComponentB() instanceof InstantiatedVersionedComponent) {
                component = fd.getComponentB();
            }
            if (component.getComponentType() == ComponentType.REMOTE_INPUT_PORT || component.getComponentType() == ComponentType.REMOTE_OUTPUT_PORT) {
                return true;
            }
        }
        return false;
    }

    private static boolean isNewZIndexLabelConfigWithDefaultValue(FlowDifference fd, FlowManager flowManager) {
        Object valueA = fd.getValueA();
        if (valueA != null) {
            return false;
        }
        VersionedComponent componentB = fd.getComponentB();
        if (!(componentB instanceof VersionedLabel)) {
            return false;
        }
        VersionedLabel versionedLabel = (VersionedLabel)componentB;
        if (fd.getDifferenceType() == DifferenceType.ZINDEX_CHANGED) {
            Long zIndex = versionedLabel.getzIndex();
            if (zIndex == null) {
                return false;
            }
            return zIndex == 0L;
        }
        return false;
    }

    private static boolean isNewZIndexConnectionConfigWithDefaultValue(FlowDifference fd, FlowManager flowManager) {
        Object valueA = fd.getValueA();
        if (valueA != null) {
            return false;
        }
        VersionedComponent componentB = fd.getComponentB();
        if (!(componentB instanceof VersionedConnection)) {
            return false;
        }
        VersionedConnection versionedConnection = (VersionedConnection)componentB;
        if (fd.getDifferenceType() == DifferenceType.ZINDEX_CHANGED) {
            Long zIndex = versionedConnection.getzIndex();
            if (zIndex == null) {
                return false;
            }
            return zIndex == 0L;
        }
        return false;
    }

    private static boolean isNewRetryConfigWithDefaultValue(FlowDifference fd, FlowManager flowManager) {
        Object valueA = fd.getValueA();
        if (valueA != null) {
            return false;
        }
        VersionedComponent componentB = fd.getComponentB();
        if (!(componentB instanceof InstantiatedVersionedProcessor)) {
            return false;
        }
        DifferenceType type = fd.getDifferenceType();
        InstantiatedVersionedProcessor instantiatedProcessor = (InstantiatedVersionedProcessor)componentB;
        ProcessorNode processorNode = flowManager.getProcessorNode(instantiatedProcessor.getInstanceIdentifier());
        if (processorNode == null) {
            return false;
        }
        return switch (type) {
            case DifferenceType.RETRIED_RELATIONSHIPS_CHANGED -> processorNode.getRetriedRelationships().isEmpty();
            case DifferenceType.RETRY_COUNT_CHANGED -> {
                if (processorNode.getRetryCount() == 10) {
                    yield true;
                }
                yield false;
            }
            case DifferenceType.MAX_BACKOFF_PERIOD_CHANGED -> "10 mins".equals(processorNode.getMaxBackoffPeriod());
            case DifferenceType.BACKOFF_MECHANISM_CHANGED -> {
                if (ProcessorNode.DEFAULT_BACKOFF_MECHANISM == processorNode.getBackoffMechanism()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static boolean isNewPropertyWithDefaultValue(FlowDifference fd, FlowManager flowManager) {
        if (fd.getDifferenceType() != DifferenceType.PROPERTY_ADDED) {
            return false;
        }
        VersionedComponent componentB = fd.getComponentB();
        if (componentB instanceof InstantiatedVersionedProcessor) {
            InstantiatedVersionedProcessor instantiatedProcessor = (InstantiatedVersionedProcessor)componentB;
            ProcessorNode processorNode = flowManager.getProcessorNode(instantiatedProcessor.getInstanceIdentifier());
            return FlowDifferenceFilters.isNewPropertyWithDefaultValue(fd, (ComponentNode)processorNode);
        }
        if (componentB instanceof InstantiatedVersionedControllerService) {
            InstantiatedVersionedControllerService instantiatedControllerService = (InstantiatedVersionedControllerService)componentB;
            ControllerServiceNode controllerService = flowManager.getControllerServiceNode(instantiatedControllerService.getInstanceIdentifier());
            return FlowDifferenceFilters.isNewPropertyWithDefaultValue(fd, (ComponentNode)controllerService);
        }
        return false;
    }

    private static boolean isNewPropertyWithDefaultValue(FlowDifference fd, ComponentNode componentNode) {
        if (componentNode == null) {
            return false;
        }
        Optional optionalFieldName = fd.getFieldName();
        if (!optionalFieldName.isPresent()) {
            return false;
        }
        String fieldName = (String)optionalFieldName.get();
        PropertyDescriptor propertyDescriptor = componentNode.getPropertyDescriptor(fieldName);
        if (propertyDescriptor == null) {
            return false;
        }
        return Objects.equals(fd.getValueB(), propertyDescriptor.getDefaultValue());
    }

    public static boolean isScheduledStateNew(FlowDifference fd) {
        if (fd.getDifferenceType() != DifferenceType.SCHEDULED_STATE_CHANGED) {
            return false;
        }
        if (fd.getValueA() == null && fd.getValueB() != null) {
            return true;
        }
        return fd.getValueB() == null && fd.getValueA() != null;
    }

    public static boolean isLocalScheduleStateChange(FlowDifference fd) {
        if (fd.getDifferenceType() != DifferenceType.SCHEDULED_STATE_CHANGED) {
            return false;
        }
        if (fd.getComponentA() == null) {
            return false;
        }
        if (fd.getComponentA().getComponentType() == ComponentType.CONTROLLER_SERVICE) {
            return true;
        }
        String scheduledStateB = String.valueOf(fd.getValueB());
        String scheduledStateA = String.valueOf(fd.getValueA());
        if ("RUNNING".equals(scheduledStateB) && ("STOPPED".equals(scheduledStateA) || "ENABLED".equals(scheduledStateA))) {
            return true;
        }
        return "RUNNING".equals(scheduledStateA) && ("STOPPED".equals(scheduledStateB) || "ENABLED".equals(scheduledStateB));
    }

    public static boolean isRpgUrlChange(FlowDifference flowDifference) {
        return flowDifference.getDifferenceType() == DifferenceType.RPG_URL_CHANGED;
    }

    public static boolean isNewRelationshipAutoTerminatedAndDefaulted(FlowDifference fd, VersionedProcessGroup processGroup, FlowManager flowManager) {
        if (fd.getDifferenceType() != DifferenceType.AUTO_TERMINATED_RELATIONSHIPS_CHANGED) {
            return false;
        }
        if (!(fd.getComponentA() instanceof VersionedProcessor) || !(fd.getComponentB() instanceof InstantiatedVersionedProcessor)) {
            return false;
        }
        VersionedProcessor processorA = (VersionedProcessor)fd.getComponentA();
        VersionedProcessor processorB = (VersionedProcessor)fd.getComponentB();
        Set autoTerminatedA = FlowDifferenceFilters.replaceNull(processorA.getAutoTerminatedRelationships(), Collections.emptySet());
        Set autoTerminatedB = FlowDifferenceFilters.replaceNull(processorB.getAutoTerminatedRelationships(), Collections.emptySet());
        if (autoTerminatedB.size() < autoTerminatedA.size() || !autoTerminatedB.containsAll(autoTerminatedA)) {
            return false;
        }
        InstantiatedVersionedProcessor instantiatedVersionedProcessor = (InstantiatedVersionedProcessor)processorB;
        ProcessorNode processorNode = flowManager.getProcessorNode(instantiatedVersionedProcessor.getInstanceIdentifier());
        if (processorNode == null) {
            return false;
        }
        HashSet newlyAddedAutoTerminated = new HashSet(autoTerminatedB);
        newlyAddedAutoTerminated.removeAll(autoTerminatedA);
        for (String relationshipName : newlyAddedAutoTerminated) {
            Relationship relationship = processorNode.getRelationship(relationshipName);
            if (relationship == null) {
                return false;
            }
            boolean defaultAutoTerminated = relationship.isAutoTerminated();
            if (!defaultAutoTerminated) {
                return false;
            }
            if (!FlowDifferenceFilters.hasConnection(processGroup, processorA, relationshipName)) continue;
            return false;
        }
        return true;
    }

    private static <T> T replaceNull(T value, T replacement) {
        return value == null ? replacement : value;
    }

    public static boolean isStaticPropertyRemoved(FlowDifference difference, FlowManager flowManager) {
        DifferenceType differenceType = difference.getDifferenceType();
        if (differenceType != DifferenceType.PROPERTY_REMOVED) {
            return false;
        }
        Optional fieldName = difference.getFieldName();
        if (!fieldName.isPresent()) {
            return false;
        }
        VersionedComponent componentB = difference.getComponentB();
        if (componentB instanceof InstantiatedVersionedProcessor) {
            InstantiatedVersionedProcessor instantiatedProcessor = (InstantiatedVersionedProcessor)componentB;
            ProcessorNode processorNode = flowManager.getProcessorNode(instantiatedProcessor.getInstanceIdentifier());
            return FlowDifferenceFilters.isStaticPropertyRemoved((String)fieldName.get(), (ComponentNode)processorNode);
        }
        if (componentB instanceof InstantiatedVersionedControllerService) {
            InstantiatedVersionedControllerService instantiatedControllerService = (InstantiatedVersionedControllerService)componentB;
            ControllerServiceNode controllerService = flowManager.getControllerServiceNode(instantiatedControllerService.getInstanceIdentifier());
            return FlowDifferenceFilters.isStaticPropertyRemoved((String)fieldName.get(), (ComponentNode)controllerService);
        }
        return false;
    }

    private static boolean isStaticPropertyRemoved(String propertyName, ComponentNode componentNode) {
        if (componentNode == null) {
            return false;
        }
        ConfigurableComponent configurableComponent = componentNode.getComponent();
        if (configurableComponent == null) {
            return false;
        }
        boolean staticallyDefined = configurableComponent.getPropertyDescriptors().stream().map(PropertyDescriptor::getName).anyMatch(propertyName::equals);
        if (staticallyDefined) {
            return false;
        }
        return !FlowDifferenceFilters.supportsDynamicProperties(configurableComponent, propertyName);
    }

    public static boolean isPropertyMissingFromGhostComponent(FlowDifference difference, FlowManager flowManager) {
        if (difference.getDifferenceType() != DifferenceType.PROPERTY_REMOVED) {
            return false;
        }
        Optional fieldName = difference.getFieldName();
        if (!fieldName.isPresent()) {
            return false;
        }
        VersionedComponent componentB = difference.getComponentB();
        if (componentB instanceof InstantiatedVersionedProcessor) {
            ProcessorNode procNode = flowManager.getProcessorNode(componentB.getInstanceIdentifier());
            return procNode.isExtensionMissing() && FlowDifferenceFilters.isPropertyPresent((ComponentNode)procNode, difference);
        }
        if (componentB instanceof InstantiatedVersionedControllerService) {
            ControllerServiceNode serviceNode = flowManager.getControllerServiceNode(componentB.getInstanceIdentifier());
            return serviceNode.isExtensionMissing() && FlowDifferenceFilters.isPropertyPresent((ComponentNode)serviceNode, difference);
        }
        return false;
    }

    private static boolean isPropertyPresent(ComponentNode componentNode, FlowDifference difference) {
        if (componentNode == null) {
            return false;
        }
        Optional fieldNameOptional = difference.getFieldName();
        if (!fieldNameOptional.isPresent()) {
            return false;
        }
        PropertyDescriptor descriptor = componentNode.getPropertyDescriptor((String)fieldNameOptional.get());
        String rawPropertyValue = componentNode.getRawPropertyValue(descriptor);
        return rawPropertyValue != null;
    }

    private static boolean hasConnection(VersionedProcessGroup processGroup, VersionedProcessor processor, String relationship) {
        for (VersionedConnection connection : processGroup.getConnections()) {
            if (!connection.getSource().getId().equals(processor.getIdentifier()) || !connection.getSelectedRelationships().contains(relationship)) continue;
            return true;
        }
        return false;
    }

    private static boolean isParameterContextChange(FlowDifference flowDifference) {
        return flowDifference.getDifferenceType() == DifferenceType.PARAMETER_CONTEXT_CHANGED;
    }

    private static boolean isLogFileSuffixChange(FlowDifference flowDifference) {
        return flowDifference.getDifferenceType() == DifferenceType.LOG_FILE_SUFFIX_CHANGED;
    }
}

